/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment.cluster;

import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;

public class MapSessionBeanToContainerIDDeployer
implements DynamicDeployer {
    private final String containerId;
    private final SessionType containerSessionType;

    public MapSessionBeanToContainerIDDeployer(String containerId, SessionType containerSessionType) {
        if (null == containerId) {
            throw new IllegalArgumentException("containerId is required");
        }
        this.containerId = containerId;
        this.containerSessionType = containerSessionType;
    }

    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            EjbJar ejbJar = ejbModule.getEjbJar();
            block5: for (EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
                if (!(enterpriseBean instanceof SessionBean)) continue;
                SessionBean sessionBean = (SessionBean)enterpriseBean;
                switch (sessionBean.getSessionType()) {
                    case STATEFUL: {
                        EjbDeployment ejbDeployment;
                        String ejbName;
                        if (this.containerSessionType == SessionType.STATEFUL) {
                            ejbName = sessionBean.getEjbName();
                            ejbDeployment = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(ejbName);
                            if (null == ejbDeployment) {
                                throw new OpenEJBException("No ejbDeployment for ejbName [" + ejbName + "]");
                            }
                            ejbDeployment.setContainerId(this.containerId);
                        }
                    }
                    case STATELESS: {
                        if (this.containerSessionType != SessionType.STATELESS) continue block5;
                        String ejbName = sessionBean.getEjbName();
                        EjbDeployment ejbDeployment = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(ejbName);
                        if (null == ejbDeployment) {
                            throw new OpenEJBException("No ejbDeployment for ejbName [" + ejbName + "]");
                        }
                        ejbDeployment.setContainerId(this.containerId);
                    }
                }
            }
        }
        return appModule;
    }
}

