/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ClassLoadingRule;
import org.apache.geronimo.kernel.repository.ClassLoadingRules;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.openejb.xbeans.ejbjar.OpenejbEjbJarDocument;
import org.apache.geronimo.openejb.xbeans.ejbjar.OpenejbGeronimoEjbJarType;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.javaee.EjbJarDocument;
import org.apache.geronimo.xbeans.javaee.EjbJarType;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceContextType;
import org.apache.openejb.jee.oejb2.ArtifactType;
import org.apache.openejb.jee.oejb2.DependencyType;
import org.apache.openejb.jee.oejb2.EnvironmentType;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlUtil {
    public static final QName OPENEJBJAR_QNAME = OpenejbEjbJarDocument.type.getDocumentElementName();
    private static final QName CMP_VERSION = new QName("http://java.sun.com/xml/ns/j2ee", "cmp-version");

    private XmlUtil() {
    }

    public static <T> String marshal(T object) throws DeploymentException {
        try {
            Class<?> type = object.getClass();
            if (object instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)object;
                type = element.getValue().getClass();
            }
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{type});
            Marshaller marshaller = ctx.createMarshaller();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal(object, (OutputStream)baos);
            String xml = new String(baos.toByteArray());
            return xml;
        }
        catch (JAXBException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public static EjbJarType convertToXmlbeans(EjbJar ejbJar) throws DeploymentException {
        for (EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
            for (PersistenceContextRef ref : enterpriseBean.getPersistenceContextRef()) {
                if (ref.getPersistenceContextType() != PersistenceContextType.TRANSACTION) continue;
                ref.setPersistenceContextType(null);
            }
        }
        String xml = XmlUtil.marshal(ejbJar);
        try {
            EjbJarDocument ejbJarDoc = XmlUtil.convertToEJBSchema(XmlBeansUtil.parse((String)xml));
            EjbJarType ejbJarType = ejbJarDoc.getEjbJar();
            return ejbJarType;
        }
        catch (XmlException e) {
            throw new DeploymentException("Error parsing ejb-jar.xml", (Throwable)e);
        }
    }

    public static OpenejbGeronimoEjbJarType convertToXmlbeans(GeronimoEjbJarType geronimoEjbJarType) throws DeploymentException {
        JAXBElement root = new JAXBElement(new QName("http://geronimo.apache.org/xml/ns/j2ee/ejb/openejb-2.0", "ejb-jar"), GeronimoEjbJarType.class, (Object)geronimoEjbJarType);
        String xml = XmlUtil.marshal(root);
        try {
            XmlObject xmlObject = XmlBeansUtil.parse((String)xml);
            OpenejbGeronimoEjbJarType geronimoOpenejb = (OpenejbGeronimoEjbJarType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)xmlObject, (QName)OPENEJBJAR_QNAME, (SchemaType)OpenejbGeronimoEjbJarType.type);
            return geronimoOpenejb;
        }
        catch (Throwable e) {
            String filePath = "<error: could not be written>";
            try {
                File tempFile = File.createTempFile("openejb-jar-", ".xml");
                try {
                    FileOutputStream out = new FileOutputStream(tempFile);
                    out.write(xml.getBytes());
                    out.close();
                }
                catch (Exception weTried) {
                    // empty catch block
                }
                filePath = tempFile.getAbsolutePath();
            }
            catch (IOException notImportant) {
                // empty catch block
            }
            throw new DeploymentException("Error parsing geronimo-openejb.xml with xmlbeans.  For debug purposes, XML content written to: " + filePath, e);
        }
    }

    public static Environment buildEnvironment(EnvironmentType environmentType, Environment defaultEnvironment) {
        Environment environment = new Environment();
        if (environmentType != null) {
            List filter;
            if (environmentType.getModuleId() != null) {
                environment.setConfigId(XmlUtil.toArtifact(environmentType.getModuleId(), null));
            }
            if (environmentType.getDependencies() != null) {
                for (DependencyType dependencyType : environmentType.getDependencies().getDependency()) {
                    Dependency dependency = XmlUtil.toDependency(dependencyType);
                    environment.addDependency(dependency);
                }
            }
            environment.setSuppressDefaultEnvironment(environmentType.isSuppressDefaultEnvironment());
            ClassLoadingRules classLoadingRules = environment.getClassLoadingRules();
            classLoadingRules.setInverseClassLoading(environmentType.isInverseClassloading());
            if (environmentType.getHiddenClasses() != null) {
                ClassLoadingRule hiddenRule = classLoadingRules.getHiddenRule();
                filter = environmentType.getHiddenClasses().getFilter();
                hiddenRule.setClassPrefixes(new HashSet(filter));
            }
            if (environmentType.getNonOverridableClasses() != null) {
                ClassLoadingRule nonOverrideableRule = classLoadingRules.getNonOverrideableRule();
                filter = environmentType.getNonOverridableClasses().getFilter();
                nonOverrideableRule.setClassPrefixes(new HashSet(filter));
            }
        }
        if (!environment.isSuppressDefaultEnvironment()) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)defaultEnvironment);
        }
        return environment;
    }

    private static Dependency toDependency(DependencyType dependencyType) {
        Artifact artifact = XmlUtil.toArtifact((ArtifactType)dependencyType, null);
        if (org.apache.openejb.jee.oejb2.ImportType.CLASSES.equals((Object)dependencyType.getImport())) {
            return new Dependency(artifact, ImportType.CLASSES);
        }
        if (org.apache.openejb.jee.oejb2.ImportType.SERVICES.equals((Object)dependencyType.getImport())) {
            return new Dependency(artifact, ImportType.SERVICES);
        }
        if (dependencyType.getImport() == null) {
            return new Dependency(artifact, ImportType.ALL);
        }
        throw new IllegalArgumentException("Unknown import type: " + dependencyType.getImport());
    }

    private static Artifact toArtifact(ArtifactType artifactType, String defaultType) {
        String groupId = artifactType.getGroupId();
        String type = artifactType.getType();
        if (type == null) {
            type = defaultType;
        }
        String artifactId = artifactType.getArtifactId();
        String version = artifactType.getVersion();
        return new Artifact(groupId, artifactId, version, type);
    }

    public static GeronimoEjbJarType createDefaultPlan(String name, EjbJar ejbJar) {
        String id = ejbJar.getId();
        if (id == null) {
            id = name;
            if (id.endsWith(".jar")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        ArtifactType artifactType = new ArtifactType();
        artifactType.setArtifactId(id);
        EnvironmentType environmentType = new EnvironmentType();
        environmentType.setModuleId(artifactType);
        GeronimoEjbJarType geronimoEjbJarType = new GeronimoEjbJarType();
        geronimoEjbJarType.setEnvironment(environmentType);
        return geronimoEjbJarType;
    }

    public static String getJ2eeStringValue(org.apache.geronimo.xbeans.javaee.String string) {
        if (string == null) {
            return null;
        }
        return string.getStringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EjbJarDocument convertToEJBSchema(XmlObject xmlObject) throws XmlException {
        if (EjbJarDocument.type.equals(xmlObject.schemaType())) {
            return (EjbJarDocument)xmlObject;
        }
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        try {
            String cmpVersion;
            cursor.toFirstChild();
            if (EjbJarDocument.type.getDocumentElementName().getNamespaceURI().equals(cursor.getName().getNamespaceURI())) {
                XmlObject result = xmlObject.changeType(EjbJarDocument.type);
                EjbJarDocument ejbJarDocument = (EjbJarDocument)result;
                return ejbJarDocument;
            }
            XmlDocumentProperties xmlDocumentProperties = cursor.documentProperties();
            String publicId = xmlDocumentProperties.getDoctypePublicId();
            if ("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN".equals(publicId)) {
                cmpVersion = "1.x";
            } else if ("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN".equals(publicId)) {
                cmpVersion = null;
            } else {
                throw new XmlException("Unrecognized document type: " + publicId);
            }
            String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd";
            String version = "2.1";
            SchemaConversionUtils.convertToSchema((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/j2ee", (String)schemaLocationURL, (String)version);
            cursor.toStartDoc();
            XmlUtil.convertBeans(cursor, moveable, cmpVersion);
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
        XmlObject result = xmlObject.changeType(EjbJarDocument.type);
        if (result != null) {
            XmlBeansUtil.validateDD((XmlObject)result);
            return (EjbJarDocument)result;
        }
        XmlBeansUtil.validateDD((XmlObject)xmlObject);
        return (EjbJarDocument)xmlObject;
    }

    private static void convertBeans(XmlCursor cursor, XmlCursor moveable, String cmpVersion) {
        cursor.toChild("http://java.sun.com/xml/ns/j2ee", "ejb-jar");
        cursor.toChild("http://java.sun.com/xml/ns/j2ee", "enterprise-beans");
        if (cursor.toFirstChild()) {
            do {
                cursor.push();
                String type = cursor.getName().getLocalPart();
                if ("session".equals(type)) {
                    cursor.toChild("http://java.sun.com/xml/ns/j2ee", "transaction-type");
                    cursor.toNextSibling();
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup((String)"http://java.sun.com/xml/ns/j2ee", (XmlCursor)cursor, (XmlCursor)moveable);
                } else if ("entity".equals(type)) {
                    cursor.toChild("http://java.sun.com/xml/ns/j2ee", "persistence-type");
                    String persistenceType = cursor.getTextValue();
                    cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "reentrant");
                    cursor.setTextValue(cursor.getTextValue().toLowerCase());
                    if (cmpVersion != null && !cursor.toNextSibling(CMP_VERSION) && "Container".equals(persistenceType)) {
                        cursor.toNextSibling();
                        cursor.insertElementWithText(CMP_VERSION, cmpVersion);
                    }
                    cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "abstract-schema-name");
                    while (cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "cmp-field")) {
                    }
                    cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "primkey-field");
                    cursor.toNextSibling();
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup((String)"http://java.sun.com/xml/ns/j2ee", (XmlCursor)cursor, (XmlCursor)moveable);
                } else if ("message-driven".equals(type)) {
                    cursor.toFirstChild();
                    if (cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "messaging-type")) {
                        cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "transaction-type");
                    } else {
                        cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "transaction-type");
                        cursor.insertElementWithText("messaging-type", "http://java.sun.com/xml/ns/j2ee", "javax.jms.MessageListener");
                    }
                    if (!cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "activation-config")) {
                        cursor.toNextSibling();
                        moveable.toCursor(cursor);
                        cursor.push();
                        cursor.beginElement("activation-config", "http://java.sun.com/xml/ns/j2ee");
                        boolean hasProperties = XmlUtil.addActivationConfigProperty(moveable, cursor, "message-selector", "messageSelector");
                        hasProperties |= XmlUtil.addActivationConfigProperty(moveable, cursor, "acknowledge-mode", "acknowledgeMode");
                        if (new QName("http://java.sun.com/xml/ns/j2ee", "message-driven-destination").equals(moveable.getName()) || moveable.toNextSibling("http://java.sun.com/xml/ns/j2ee", "message-driven-destination")) {
                            moveable.push();
                            moveable.toFirstChild();
                            hasProperties |= XmlUtil.addActivationConfigProperty(moveable, cursor, "destination-type", "destinationType");
                            hasProperties |= XmlUtil.addActivationConfigProperty(moveable, cursor, "subscription-durability", "subscriptionDurability");
                            moveable.pop();
                            moveable.removeXml();
                        }
                        cursor.pop();
                        if (!hasProperties) {
                            cursor.toPrevSibling();
                            cursor.removeXml();
                        }
                    } else {
                        cursor.toNextSibling();
                    }
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup((String)"http://java.sun.com/xml/ns/j2ee", (XmlCursor)cursor, (XmlCursor)moveable);
                }
                cursor.pop();
            } while (cursor.toNextSibling());
        }
    }

    private static boolean addActivationConfigProperty(XmlCursor moveable, XmlCursor cursor, String elementName, String propertyName) {
        QName name = new QName("http://java.sun.com/xml/ns/j2ee", elementName);
        if (name.equals(moveable.getName()) || moveable.toNextSibling(name)) {
            cursor.push();
            cursor.beginElement("activation-config-property", "http://java.sun.com/xml/ns/j2ee");
            cursor.insertElementWithText("activation-config-property-name", "http://java.sun.com/xml/ns/j2ee", propertyName);
            cursor.insertElementWithText("activation-config-property-value", "http://java.sun.com/xml/ns/j2ee", moveable.getTextValue());
            moveable.removeXml();
            cursor.pop();
            cursor.toNextSibling();
            return true;
        }
        return false;
    }

    public static class ValidationEventHandler
    implements javax.xml.bind.ValidationEventHandler {
        public boolean handleEvent(ValidationEvent validationEvent) {
            System.out.println(validationEvent.getMessage());
            return true;
        }
    }
}

