/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarFile;
import javax.ejb.EntityContext;
import javax.ejb.MessageDrivenContext;
import javax.ejb.SessionContext;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.connector.ResourceAdapterWrapperGBean;
import org.apache.geronimo.deployment.ClassPathList;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.ModuleList;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.service.GBeanBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedEjbJar;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.classloader.TemporaryClassLoader;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.openejb.EjbContainer;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.openejb.EjbModuleImplGBean;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.openejb.deployment.EjbDeploymentBuilder;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.geronimo.openejb.deployment.XmlUtil;
import org.apache.geronimo.openejb.xbeans.ejbjar.OpenejbGeronimoEjbJarType;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerSecurityDocument;
import org.apache.geronimo.xbeans.javaee.EjbJarType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.CmpJarBuilder;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.ContainerSystemInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.FacilitiesInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.MessageDrivenBeanInfo;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.UnknownModuleTypeException;
import org.apache.openejb.config.UnsupportedModuleTypeException;
import org.apache.openejb.config.ValidationError;
import org.apache.openejb.config.ValidationFailedException;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.jpa.unit.TransactionType;
import org.apache.openejb.jee.oejb2.EjbRefType;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.openejb.jee.oejb2.MessageDrivenBeanType;
import org.apache.openejb.jee.oejb2.OpenejbJarType;
import org.apache.openejb.jee.oejb2.PatternType;
import org.apache.openejb.jee.oejb2.ResourceLocatorType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbModuleBuilder
implements ModuleBuilder {
    private static final Log log = LogFactory.getLog(EjbModuleBuilder.class);
    private static final String OPENEJBJAR_NAMESPACE = XmlUtil.OPENEJBJAR_QNAME.getNamespaceURI();
    private final Environment defaultEnvironment;
    private final String defaultCmpJTADataSource;
    private final String defaultCmpNonJTADataSource;
    private final NamespaceDrivenBuilderCollection securityBuilders;
    private final NamespaceDrivenBuilderCollection serviceBuilders;
    private final NamingBuilder namingBuilder;
    private final ResourceEnvironmentSetter resourceEnvironmentSetter;
    private final Collection<ModuleBuilderExtension> moduleBuilderExtensions;
    private static final String LINE_SEP = System.getProperty("line.separator");
    public static final GBeanInfo GBEAN_INFO;

    public EjbModuleBuilder(Environment defaultEnvironment, String defaultCmpJTADataSource, String defaultCmpNonJTADataSource, Collection<ModuleBuilderExtension> moduleBuilderExtensions, Collection securityBuilders, Collection serviceBuilders, NamingBuilder namingBuilders, ResourceEnvironmentSetter resourceEnvironmentSetter) {
        this.defaultEnvironment = defaultEnvironment;
        this.defaultCmpJTADataSource = defaultCmpJTADataSource;
        this.defaultCmpNonJTADataSource = defaultCmpNonJTADataSource;
        this.securityBuilders = new NamespaceDrivenBuilderCollection(securityBuilders, GerSecurityDocument.type.getDocumentElementName());
        this.serviceBuilders = new NamespaceDrivenBuilderCollection(serviceBuilders, GBeanBuilder.SERVICE_QNAME);
        this.namingBuilder = namingBuilders;
        this.resourceEnvironmentSetter = resourceEnvironmentSetter;
        if (moduleBuilderExtensions == null) {
            moduleBuilderExtensions = Collections.emptyList();
        }
        this.moduleBuilderExtensions = moduleBuilderExtensions;
        System.setProperty("duct tape", "");
        System.setProperty("admin.disabled", "true");
        System.setProperty("openejb.logger.external", "true");
        this.setDefaultProperty("openejb.deploymentId.format", "{moduleId}/{ejbName}");
        this.setDefaultProperty("openejb.jndiname.strategy.class", "org.apache.openejb.assembler.classic.JndiBuilder$TemplatedStrategy");
        this.setDefaultProperty("openejb.jndiname.format", "{deploymentId}/{interfaceClass}");
        System.setProperty("openejb.naming", "xbean");
    }

    private void setDefaultProperty(String key, String value) {
        SystemInstance systemInstance = SystemInstance.get();
        String format = systemInstance.getProperty(key);
        if (format == null) {
            systemInstance.setProperty(key, value);
        }
    }

    public String getSchemaNamespace() {
        return OPENEJBJAR_NAMESPACE;
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, "ejb.jar", null, null, null, naming, idBuilder);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, environment, earName, naming, idBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment earEnvironment, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        AbstractName moduleName;
        AppModule appModule;
        if (moduleFile == null) {
            throw new NullPointerException("moduleFile is null");
        }
        if (targetPath == null) {
            throw new NullPointerException("targetPath is null");
        }
        if (targetPath.endsWith("/")) {
            throw new IllegalArgumentException("targetPath must not end with a '/'");
        }
        DeploymentLoader loader = new DeploymentLoader();
        try {
            appModule = loader.load(new File(moduleFile.getName()));
        }
        catch (UnknownModuleTypeException e) {
            return null;
        }
        catch (UnsupportedModuleTypeException e) {
            return null;
        }
        catch (OpenEJBException e) {
            Throwable t = e.getCause();
            if (t instanceof UnknownModuleTypeException || t instanceof UnsupportedModuleTypeException) {
                return null;
            }
            throw new DeploymentException((Throwable)e);
        }
        if (appModule.getEjbModules().size() == 0) {
            return null;
        }
        org.apache.openejb.config.EjbModule ejbModule = (org.apache.openejb.config.EjbModule)appModule.getEjbModules().get(0);
        if (specDDUrl != null) {
            ejbModule.setEjbJar(null);
            ejbModule.getAltDDs().put("ejb-jar.xml", specDDUrl);
        }
        XmlObject unknownXmlObject = null;
        if (plan instanceof XmlObject) {
            unknownXmlObject = (XmlObject)plan;
        } else if (plan != null) {
            try {
                unknownXmlObject = XmlBeansUtil.parse((URL)((File)plan).toURL(), (ClassLoader)XmlUtil.class.getClassLoader());
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        if (unknownXmlObject != null) {
            XmlCursor xmlCursor = unknownXmlObject.newCursor();
            QName qname = xmlCursor.getName();
            if (qname == null) {
                xmlCursor.toFirstChild();
                qname = xmlCursor.getName();
            }
            if (qname.getLocalPart().equals("openejb-jar")) {
                ejbModule.getAltDDs().put("openejb-jar.xml", xmlCursor.xmlText());
            } else if (qname.getLocalPart().equals("ejb-jar") && qname.getNamespaceURI().equals("http://geronimo.apache.org/xml/ns/j2ee/ejb/openejb-2.0")) {
                ejbModule.getAltDDs().put("geronimo-openejb.xml", xmlCursor.xmlText());
            }
        }
        ReadDescriptors readDescriptors = new ReadDescriptors();
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            try {
                readDescriptors.deploy(appModule);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
        }
        catch (OpenEJBException e) {
            throw new DeploymentException("Failed parsing descriptors for module: " + moduleFile.getName(), (Throwable)e);
        }
        boolean standAlone = earEnvironment == null;
        GeronimoEjbJarType geronimoEjbJarType = (GeronimoEjbJarType)ejbModule.getAltDDs().get("geronimo-openejb.xml");
        if (geronimoEjbJarType == null) {
            String path = standAlone ? new File(moduleFile.getName()).getName() : targetPath;
            geronimoEjbJarType = XmlUtil.createDefaultPlan(path, ejbModule.getEjbJar());
            ejbModule.getAltDDs().put("geronimo-openejb.xml", geronimoEjbJarType);
        }
        Environment environment = XmlUtil.buildEnvironment(geronimoEjbJarType.getEnvironment(), this.defaultEnvironment);
        if (earEnvironment != null) {
            EnvironmentBuilder.mergeEnvironments((Environment)earEnvironment, (Environment)environment);
            environment = earEnvironment;
            if (!environment.getConfigId().isResolved()) {
                throw new IllegalStateException("EJB module ID should be fully resolved (not " + environment.getConfigId() + ")");
            }
        } else {
            idBuilder.resolve(environment, new File(moduleFile.getName()).getName(), "jar");
        }
        if (earName == null) {
            earName = naming.createRootName(environment.getConfigId(), "null", "J2EEApplication");
            moduleName = naming.createChildName(earName, environment.getConfigId().toString(), "EJBModule");
            ejbModule.setModuleId(environment.getConfigId().getArtifactId());
        } else {
            moduleName = naming.createChildName(earName, targetPath, "EJBModule");
            ejbModule.setModuleId(targetPath);
        }
        EjbJar ejbJar = ejbModule.getEjbJar();
        EjbJarType ejbJarType = XmlUtil.convertToXmlbeans(ejbJar);
        AnnotatedEjbJar annotatedEjbJar = new AnnotatedEjbJar(ejbJarType);
        EjbModule module = new EjbModule(ejbModule, standAlone, moduleName, environment, moduleFile, targetPath, "", (AnnotatedApp)annotatedEjbJar);
        for (ModuleBuilderExtension builder : this.moduleBuilderExtensions) {
            try {
                builder.createModule((Module)module, plan, moduleFile, targetPath, specDDUrl, environment, null, earName, naming, idBuilder);
            }
            catch (Throwable t) {
                String builderName = builder.getClass().getSimpleName();
                log.error((Object)(builderName + ".createModule() failed: " + t.getMessage()), t);
            }
        }
        return module;
    }

    protected static void unmapReferences(EjbJar ejbJar, GeronimoEjbJarType geronimoEjbJarType) {
        TreeSet<String> corbaEjbRefs = new TreeSet<String>();
        for (EjbRefType ejbRef : geronimoEjbJarType.getEjbRef()) {
            if (ejbRef.getNsCorbaloc() == null) continue;
            corbaEjbRefs.add(ejbRef.getRefName());
        }
        for (EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
            EjbRef ref2;
            enterpriseBean.getEnvEntry().clear();
            enterpriseBean.getEjbLocalRef().clear();
            Iterator iterator = enterpriseBean.getEjbRef().iterator();
            while (iterator.hasNext()) {
                ref2 = (EjbRef)iterator.next();
                if (!corbaEjbRefs.contains(ref2.getEjbRefName())) {
                    iterator.remove();
                    continue;
                }
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
            for (EjbRef ref2 : enterpriseBean.getMessageDestinationRef()) {
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
            for (EjbRef ref2 : enterpriseBean.getPersistenceContextRef()) {
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
            for (EjbRef ref2 : enterpriseBean.getPersistenceUnitRef()) {
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
            for (EjbRef ref2 : enterpriseBean.getResourceRef()) {
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
            iterator = enterpriseBean.getResourceEnvRef().iterator();
            while (iterator.hasNext()) {
                ref2 = (ResourceEnvRef)iterator.next();
                if (ref2.getType().equals(SessionContext.class.getName())) {
                    iterator.remove();
                } else if (ref2.getType().equals(EntityContext.class.getName())) {
                    iterator.remove();
                } else if (ref2.getType().equals(MessageDrivenContext.class.getName())) {
                    iterator.remove();
                } else {
                    ref2.setMappedName(null);
                }
                ref2.getInjectionTarget().clear();
            }
            for (EjbRef ref2 : enterpriseBean.getServiceRef()) {
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
        }
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
        EARContext moduleContext;
        this.installModule(module, earContext);
        if (module.isStandAlone()) {
            moduleContext = earContext;
        } else {
            Environment environment = earContext.getConfiguration().getEnvironment();
            File configurationDir = new File(earContext.getBaseDir(), module.getTargetPath());
            try {
                File inPlaceConfigurationDir = null;
                if (null != earContext.getInPlaceConfigurationDir()) {
                    inPlaceConfigurationDir = new File(earContext.getInPlaceConfigurationDir(), module.getTargetPath());
                }
                moduleContext = new EARContext(configurationDir, inPlaceConfigurationDir, environment, ConfigurationModuleType.EJB, module.getModuleName(), earContext);
            }
            catch (DeploymentException e) {
                this.cleanupConfigurationDir(configurationDir);
                throw e;
            }
        }
        module.setEarContext(moduleContext);
        module.setRootEarContext(earContext);
        if (((EjbModule)module).getEjbJar().getAssemblyDescriptor() != null) {
            this.namingBuilder.buildEnvironment(null, null, module.getEnvironment());
        }
        for (ModuleBuilderExtension builder : this.moduleBuilderExtensions) {
            try {
                builder.installModule(earFile, earContext, module, configurationStores, targetConfigurationStore, repository);
            }
            catch (Throwable t) {
                String builderName = builder.getClass().getSimpleName();
                log.error((Object)(builderName + ".installModule() failed: " + t.getMessage()), t);
            }
        }
    }

    private void installModule(Module module, EARContext earContext) throws DeploymentException {
        EarData earData = (EarData)earContext.getGeneralData().get(EarData.class);
        if (earData == null) {
            earData = new EarData();
            earContext.getGeneralData().put(EarData.class, earData);
        }
        earData.addEjbModule((EjbModule)module);
        JarFile moduleFile = module.getModuleFile();
        try {
            earContext.addIncludeAsPackedJar(URI.create(module.getTargetPath()), moduleFile);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to copy ejb module jar into configuration: " + moduleFile.getName(), (Throwable)e);
        }
    }

    private boolean cleanupConfigurationDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!DeploymentUtil.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn((Object)("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir.getAbsolutePath() + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? (String)cannotBeDeletedList.getFirst() : "")));
            return false;
        }
        return true;
    }

    public void initContext(EARContext earContext, Module module, ClassLoader classLoader) throws DeploymentException {
        EjbModule ejbModule = (EjbModule)module;
        EjbJarInfo ejbJarInfo = this.getEjbJarInfo(earContext, ejbModule, classLoader);
        ejbModule.setEjbJarInfo(ejbJarInfo);
        EjbJar ejbJar = ejbModule.getEjbJar();
        ejbModule.setOriginalSpecDD(XmlUtil.marshal(ejbModule.getEjbJar()));
        GeronimoEjbJarType geronimoEjbJarType = (GeronimoEjbJarType)ejbModule.getEjbModule().getAltDDs().get("geronimo-openejb.xml");
        EjbModuleBuilder.unmapReferences(ejbJar, geronimoEjbJarType);
        EjbJarType ejbJarType = XmlUtil.convertToXmlbeans(ejbJar);
        ejbModule.setSpecDD((XmlObject)ejbJarType);
        OpenejbGeronimoEjbJarType geronimoOpenejb = XmlUtil.convertToXmlbeans(geronimoEjbJarType);
        ejbModule.setVendorDD(geronimoOpenejb);
        if (ejbJarType.getAssemblyDescriptor() != null) {
            this.namingBuilder.initContext((XmlObject)ejbJarType.getAssemblyDescriptor(), (XmlObject)geronimoOpenejb, (Module)ejbModule);
        }
        EjbDeploymentBuilder ejbDeploymentBuilder = new EjbDeploymentBuilder(earContext, ejbModule, this.namingBuilder, this.resourceEnvironmentSetter);
        ejbModule.setEjbBuilder(ejbDeploymentBuilder);
        ejbDeploymentBuilder.initContext();
        this.securityBuilders.build((XmlObject)geronimoOpenejb, (DeploymentContext)earContext, (DeploymentContext)(ejbModule.isStandAlone() ? ejbModule.getEarContext() : null));
        this.serviceBuilders.build((XmlObject)geronimoOpenejb, (DeploymentContext)earContext, (DeploymentContext)ejbModule.getEarContext());
        ClassPathList manifestcp = new ClassPathList();
        manifestcp.add((Object)module.getTargetPath());
        EARContext moduleContext = module.getEarContext();
        ModuleList moduleLocations = (ModuleList)module.getRootEarContext().getGeneralData().get(ModuleList.class);
        URI baseUri = URI.create(module.getTargetPath());
        moduleContext.getCompleteManifestClassPath(module.getModuleFile(), baseUri, URI.create("."), manifestcp, moduleLocations);
        moduleContext.getGeneralData().put(ClassPathList.class, manifestcp);
        for (ModuleBuilderExtension builder : this.moduleBuilderExtensions) {
            try {
                builder.initContext(earContext, module, classLoader);
            }
            catch (Throwable t) {
                String builderName = builder.getClass().getSimpleName();
                log.error((Object)(builderName + ".initContext() failed: " + t.getMessage()), t);
            }
        }
    }

    private EjbJarInfo getEjbJarInfo(EARContext earContext, EjbModule ejbModule, ClassLoader classLoader) throws DeploymentException {
        EarData earData = (EarData)earContext.getGeneralData().get(EarData.class);
        if (earData.getEjbJars().isEmpty()) {
            AppInfo appInfo;
            TemporaryClassLoader temporaryClassLoader = new TemporaryClassLoader(new URL[0], classLoader);
            AppModule appModule = new AppModule(classLoader, earContext.getConfigID().toString());
            for (EjbModule module : earData.getEjbModuels()) {
                module.setClassLoader((ClassLoader)temporaryClassLoader);
                appModule.getEjbModules().add(module.getEjbModule());
            }
            try {
                appInfo = this.configureApplication(appModule, earContext.getConfiguration());
            }
            catch (ValidationFailedException set) {
                StringBuilder sb = new StringBuilder();
                sb.append("Jar failed validation: ").append(appModule.getModuleId());
                for (ValidationError validationError : set.getErrors()) {
                    sb.append(validationError.getPrefix()).append(" ... ").append(validationError.getComponentName()).append(":\t").append(validationError.getMessage(2));
                }
                for (ValidationError validationError : set.getFailures()) {
                    sb.append(validationError.getPrefix()).append(" ... ").append(validationError.getComponentName()).append(":\t").append(validationError.getMessage(2));
                }
                throw new DeploymentException(sb.toString());
            }
            catch (OpenEJBException e) {
                throw new DeploymentException((Throwable)e);
            }
            for (EjbJarInfo ejbJar : appInfo.ejbJars) {
                earData.addEjbJar(ejbJar);
            }
            CmpJarBuilder cmp2Builder = new CmpJarBuilder(appInfo, classLoader);
            try {
                File generatedJar = cmp2Builder.getJarFile();
                if (generatedJar != null) {
                    String generatedPath = ejbModule.getTargetPath();
                    if (generatedPath.endsWith(".jar")) {
                        generatedPath = generatedPath.substring(0, generatedPath.length() - 4);
                    }
                    generatedPath = generatedPath + "-cmp2.jar";
                    earContext.addInclude(URI.create(generatedPath), generatedJar);
                }
            }
            catch (IOException e) {
                throw new DeploymentException((Throwable)e);
            }
            if (appInfo.cmpMappingsXml != null) {
                this.addGeronimmoOpenEJBPersistenceUnit(ejbModule);
            }
        }
        EjbJarInfo ejbJarInfo = earData.getEjbJar(ejbModule.getEjbModule().getModuleId());
        return ejbJarInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppInfo configureApplication(AppModule appModule, Configuration configuration) throws OpenEJBException {
        OpenEjbConfiguration openEjbConfiguration = new OpenEjbConfiguration();
        openEjbConfiguration.containerSystem = new ContainerSystemInfo();
        openEjbConfiguration.facilities = new FacilitiesInfo();
        boolean offline = true;
        ConfigurationFactory configurationFactory = new ConfigurationFactory(offline, openEjbConfiguration);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(appModule.getClassLoader());
        try {
            this.addContainerInfos(configuration, openEjbConfiguration.containerSystem, configurationFactory);
            this.addResourceAdapterMDBInfos(configuration, openEjbConfiguration.containerSystem, configurationFactory);
            AppInfo appInfo = configurationFactory.configureApplication(appModule);
            return appInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void addContainerInfos(Configuration configuration, ContainerSystemInfo containerSystem, ConfigurationFactory configurationFactory) throws OpenEJBException {
        LinkedHashSet containerDatas = configuration.findGBeanDatas(Collections.singleton(new AbstractNameQuery(EjbContainer.class.getName())));
        for (GBeanData containerData : containerDatas) {
            Class infoClass = (Class)containerData.getAttribute("infoType");
            if (infoClass == null) {
                String type = (String)containerData.getAttribute("type");
                infoClass = EjbContainer.getInfoType((String)type);
            }
            String serviceId = (String)containerData.getAttribute("id");
            Properties declaredProperties = (Properties)containerData.getAttribute("properties");
            String providerId = (String)containerData.getAttribute("provider");
            ContainerInfo containerInfo = (ContainerInfo)configurationFactory.configureService(infoClass, serviceId, declaredProperties, providerId, "Container");
            containerSystem.containers.add(containerInfo);
        }
    }

    private void addResourceAdapterMDBInfos(Configuration configuration, ContainerSystemInfo containerSystem, ConfigurationFactory configurationFactory) throws OpenEJBException {
        LinkedHashSet resourceAdapterWrappers = configuration.findGBeanDatas(Collections.singleton(new AbstractNameQuery(ResourceAdapterWrapperGBean.class.getName())));
        for (GBeanData resourceAdapterWrapperData : resourceAdapterWrappers) {
            String resourceAdapterId = this.getResourceAdapterId(resourceAdapterWrapperData.getAbstractName());
            Map messageListenerToActivationSpecMap = (Map)resourceAdapterWrapperData.getAttribute("messageListenerToActivationSpecMap");
            if (messageListenerToActivationSpecMap == null) continue;
            for (Map.Entry entry : messageListenerToActivationSpecMap.entrySet()) {
                String messageListenerInterface = (String)entry.getKey();
                String activationSpecClass = (String)entry.getValue();
                String containerName = resourceAdapterId + "-" + messageListenerInterface;
                ContainerInfo containerInfo = (ContainerInfo)configurationFactory.configureService(MdbContainerInfo.class);
                containerInfo.id = containerName;
                containerInfo.displayName = containerName;
                try {
                    containerInfo.properties.put("MessageListenerInterface", configuration.getConfigurationClassLoader().loadClass(messageListenerInterface));
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Could not load MessageListenerInterface " + messageListenerInterface + " in classloader: " + configuration.getConfigurationClassLoader(), (Throwable)e);
                }
                try {
                    containerInfo.properties.put("ActivationSpecClass", configuration.getConfigurationClassLoader().loadClass(activationSpecClass));
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Could not load ActivationSpecClass " + activationSpecClass + " in classloader: " + configuration.getConfigurationClassLoader(), (Throwable)e);
                }
                containerSystem.containers.add(containerInfo);
            }
        }
    }

    private void addGeronimmoOpenEJBPersistenceUnit(EjbModule ejbModule) {
        GeronimoEjbJarType geronimoEjbJarType = (GeronimoEjbJarType)ejbModule.getEjbModule().getAltDDs().get("geronimo-openejb.xml");
        PersistenceUnit persistenceUnit = null;
        block0: for (Persistence persistence : geronimoEjbJarType.getPersistence()) {
            for (PersistenceUnit unit : persistence.getPersistenceUnit()) {
                if (!"cmp".equals(unit.getName())) continue;
                persistenceUnit = unit;
                continue block0;
            }
        }
        if (persistenceUnit == null) {
            String datasourceName;
            ResourceLocatorType cmpConnectionFactory;
            String jtaDataSource = null;
            Object altDD = ejbModule.getEjbModule().getAltDDs().get("openejb-jar.xml");
            if (altDD instanceof OpenejbJarType && (cmpConnectionFactory = ((OpenejbJarType)altDD).getCmpConnectionFactory()) != null && (datasourceName = cmpConnectionFactory.getResourceLink()) != null) {
                jtaDataSource = datasourceName.trim();
            }
            persistenceUnit = new PersistenceUnit();
            persistenceUnit.setName("cmp");
            persistenceUnit.setTransactionType(TransactionType.JTA);
            if (jtaDataSource != null) {
                persistenceUnit.setJtaDataSource(jtaDataSource);
            } else {
                persistenceUnit.setJtaDataSource(this.defaultCmpJTADataSource);
            }
            persistenceUnit.setNonJtaDataSource(this.defaultCmpNonJTADataSource);
            persistenceUnit.setExcludeUnlistedClasses(Boolean.valueOf(true));
            Persistence persistence = new Persistence();
            persistence.setVersion("1.0");
            persistence.getPersistenceUnit().add(persistenceUnit);
            geronimoEjbJarType.getPersistence().add(persistence);
        }
        persistenceUnit.getMappingFile().add("META-INF/openejb-cmp-generated-orm.xml");
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl, Collection repositories) throws DeploymentException {
        EjbModule ejbModule = (EjbModule)module;
        EjbDeploymentBuilder ejbDeploymentBuilder = ejbModule.getEjbBuilder();
        ejbDeploymentBuilder.buildEnc();
        GBeanData ejbModuleGBeanData = new GBeanData(ejbModule.getModuleName(), EjbModuleImplGBean.GBEAN_INFO);
        try {
            ejbModuleGBeanData.setReferencePattern("J2EEServer", earContext.getServerName());
            if (!ejbModule.isStandAlone()) {
                ejbModuleGBeanData.setReferencePattern("J2EEApplication", earContext.getModuleName());
            }
            ejbModuleGBeanData.setAttribute("deploymentDescriptor", (Object)ejbModule.getOriginalSpecDD());
            ejbModuleGBeanData.setReferencePatterns("EJBCollection", new ReferencePatterns(new AbstractNameQuery(null, Collections.singletonMap("EJBModule", ejbModule.getModuleName().getNameProperty("name")), EjbDeployment.class.getName())));
            ejbModuleGBeanData.setReferencePattern("OpenEjbSystem", new AbstractNameQuery(null, Collections.EMPTY_MAP, OpenEjbSystem.class.getName()));
            ejbModuleGBeanData.setAttribute("ejbJarInfo", (Object)ejbModule.getEjbJarInfo());
            earContext.addGBean(ejbModuleGBeanData);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize EJBModule GBean " + ejbModuleGBeanData.getAbstractName(), (Throwable)e);
        }
        ejbDeploymentBuilder.addEjbModuleDependency(ejbModuleGBeanData.getAbstractName());
        ComponentPermissions componentPermissions = ejbDeploymentBuilder.buildComponentPermissions();
        earContext.addSecurityContext(ejbModule.getEjbJarInfo().moduleId, (Object)componentPermissions);
        this.setMdbContainerIds(earContext, ejbModule, ejbModuleGBeanData);
        for (ModuleBuilderExtension builder : this.moduleBuilderExtensions) {
            try {
                builder.addGBeans(earContext, module, cl, repositories);
            }
            catch (Throwable t) {
                String builderName = builder.getClass().getSimpleName();
                log.error((Object)(builderName + ".addGBeans() failed: " + t.getMessage()), t);
            }
        }
    }

    private void setMdbContainerIds(EARContext earContext, EjbModule ejbModule, GBeanData ejbModuleGBeanData) throws DeploymentException {
        Object altDD = ejbModule.getEjbModule().getAltDDs().get("openejb-jar.xml");
        if (!(altDD instanceof OpenejbJarType)) {
            return;
        }
        OpenejbJarType openejbJarType = (OpenejbJarType)altDD;
        EjbJarInfo ejbJarInfo = ejbModule.getEjbJarInfo();
        TreeMap<String, MessageDrivenBeanInfo> mdbs = new TreeMap<String, MessageDrivenBeanInfo>();
        for (EnterpriseBeanInfo enterpriseBean : ejbJarInfo.enterpriseBeans) {
            if (!(enterpriseBean instanceof MessageDrivenBeanInfo)) continue;
            mdbs.put(enterpriseBean.ejbName, (MessageDrivenBeanInfo)enterpriseBean);
        }
        for (EnterpriseBeanInfo enterpriseBean : openejbJarType.getEnterpriseBeans()) {
            AbstractName resourceAdapterAbstractName;
            MessageDrivenBeanType bean;
            MessageDrivenBeanInfo messageDrivenBeanInfo;
            if (!(enterpriseBean instanceof MessageDrivenBeanType) || (messageDrivenBeanInfo = (MessageDrivenBeanInfo)mdbs.get((bean = (MessageDrivenBeanType)enterpriseBean).getEjbName())) == null || messageDrivenBeanInfo.containerId != null) continue;
            if (bean.getResourceAdapter() == null) {
                throw new DeploymentException("No Resource Adapter defined for MDB '" + bean.getEjbName() + "'");
            }
            AbstractNameQuery resourceAdapterNameQuery = EjbModuleBuilder.getResourceAdapterNameQuery(bean.getResourceAdapter());
            try {
                resourceAdapterAbstractName = earContext.findGBean(resourceAdapterNameQuery);
            }
            catch (GBeanNotFoundException e) {
                throw new DeploymentException("Resource Adapter for MDB '" + bean.getEjbName() + "'not found: " + resourceAdapterNameQuery, (Throwable)e);
            }
            String resourceAdapterId = this.getResourceAdapterId(resourceAdapterAbstractName);
            messageDrivenBeanInfo.containerId = resourceAdapterId + "-" + messageDrivenBeanInfo.mdbInterface;
            ejbModuleGBeanData.addDependency(resourceAdapterAbstractName);
        }
    }

    private String getResourceAdapterId(AbstractName resourceAdapterAbstractName) {
        Map properties = resourceAdapterAbstractName.getName();
        String shortName = (String)properties.get("name");
        String moduleName = (String)properties.get("ResourceAdapterModule");
        if (shortName != null && moduleName != null) {
            return moduleName + "." + shortName;
        }
        return resourceAdapterAbstractName.getObjectName().toString();
    }

    private static AbstractNameQuery getResourceAdapterNameQuery(ResourceLocatorType resourceLocator) {
        if (resourceLocator.getResourceLink() != null) {
            HashMap<String, String> nameMap = new HashMap<String, String>();
            nameMap.put("name", resourceLocator.getResourceLink());
            nameMap.put("j2eeType", "JCAResourceAdapter");
            return new AbstractNameQuery(null, nameMap);
        }
        PatternType pattern = resourceLocator.getPattern();
        Artifact artifact = null;
        if (pattern.getArtifactId() != null) {
            artifact = new Artifact(pattern.getGroupId(), pattern.getArtifactId(), pattern.getVersion(), "car");
        }
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("name", pattern.getName());
        nameMap.put("j2eeType", "JCAResourceAdapter");
        if (pattern.getModule() != null) {
            nameMap.put("ResourceAdapterModule", pattern.getModule());
        }
        return new AbstractNameQuery(artifact, nameMap, (Set)null);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(EjbModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true);
        infoBuilder.addAttribute("defaultCmpJTADataSource", String.class, true);
        infoBuilder.addAttribute("defaultCmpNonJTADataSource", String.class, true);
        infoBuilder.addReference("ModuleBuilderExtensions", ModuleBuilderExtension.class, "ModuleBuilder");
        infoBuilder.addReference("SecurityBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ServiceBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("NamingBuilders", NamingBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ResourceEnvironmentSetter", ResourceEnvironmentSetter.class, "ModuleBuilder");
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "defaultCmpJTADataSource", "defaultCmpNonJTADataSource", "ModuleBuilderExtensions", "SecurityBuilders", "ServiceBuilders", "NamingBuilders", "ResourceEnvironmentSetter"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EarData {
        private final Map<String, EjbModule> ejbModules = new TreeMap<String, EjbModule>();
        private final Map<String, EjbJarInfo> ejbJars = new TreeMap<String, EjbJarInfo>();

        public void addEjbModule(EjbModule ejbModule) {
            this.ejbModules.put(ejbModule.getEjbModule().getModuleId(), ejbModule);
        }

        public EjbModule getEjbModule(String moduleId) throws DeploymentException {
            EjbModule ejbModule = this.ejbModules.get(moduleId);
            if (ejbModule == null) {
                throw new DeploymentException("Ejb  module " + moduleId + " was not found in configured module list " + this.ejbModules.keySet());
            }
            return ejbModule;
        }

        public Collection<EjbModule> getEjbModuels() {
            return this.ejbModules.values();
        }

        public void addEjbJar(EjbJarInfo ejbJarInfo) {
            this.ejbJars.put(ejbJarInfo.moduleId, ejbJarInfo);
        }

        public EjbJarInfo getEjbJar(String moduleId) throws DeploymentException {
            EjbJarInfo ejbJarInfo = this.ejbJars.get(moduleId);
            if (ejbJarInfo == null) {
                throw new DeploymentException("Ejb jar configuration passed but expected module " + moduleId + " was not found in configured module list " + this.ejbJars.keySet());
            }
            return ejbJarInfo;
        }

        public Collection<EjbJarInfo> getEjbJars() {
            return this.ejbJars.values();
        }
    }
}

