/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gjndi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.xbean.naming.context.ContextAccess;
import org.apache.xbean.naming.context.WritableContext;

public class KernelContextGBean
extends WritableContext
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)KernelContextGBean.class);
    private final Kernel kernel;
    private final AbstractNameQuery abstractNameQuery;
    private final LifecycleListener listener = new ContextLifecycleListener();
    private final Map bindingsByAbstractName = new HashMap();
    private Map bindingsByName = new HashMap();
    public static final GBeanInfo GBEAN_INFO;

    public KernelContextGBean(String nameInNamespace, AbstractNameQuery abstractNameQuery, Kernel kernel) throws NamingException {
        super(nameInNamespace, Collections.EMPTY_MAP, ContextAccess.UNMODIFIABLE, false);
        this.abstractNameQuery = abstractNameQuery;
        this.kernel = kernel;
    }

    public synchronized void doStart() {
        this.kernel.getLifecycleMonitor().addLifecycleListener(this.listener, this.abstractNameQuery);
        Set set = this.kernel.listGBeans(this.abstractNameQuery);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AbstractName abstractName = (AbstractName)iterator.next();
            try {
                if (!this.kernel.isRunning(abstractName)) continue;
                this.addBinding(abstractName);
            }
            catch (NamingException e) {
                log.error((Object)("Error adding binding for " + abstractName));
            }
        }
    }

    public void doStop() {
        this.destroy();
    }

    public void doFail() {
        this.destroy();
    }

    private synchronized void destroy() {
        this.kernel.getLifecycleMonitor().removeLifecycleListener(this.listener);
        HashSet abstractNames = new HashSet(this.bindingsByAbstractName.keySet());
        Iterator iterator = abstractNames.iterator();
        while (iterator.hasNext()) {
            AbstractName abstractName = (AbstractName)iterator.next();
            this.removeBinding(abstractName);
        }
        this.bindingsByAbstractName.clear();
    }

    protected synchronized void addBinding(AbstractName abstractName) throws NamingException {
        if (this.bindingsByAbstractName.containsKey(abstractName)) {
            return;
        }
        Object instance = null;
        try {
            instance = this.kernel.getGBean(abstractName);
        }
        catch (GBeanNotFoundException e) {
            throw new NamingException("GBean not found: " + abstractName);
        }
        Map bindings = this.createBindings(abstractName, instance);
        if (bindings == null || bindings.isEmpty()) {
            return;
        }
        Iterator iterator = bindings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Name name = (Name)entry.getKey();
            Object value = entry.getValue();
            this.addBinding(abstractName, name, value);
        }
        this.bindingsByAbstractName.put(abstractName, bindings.keySet());
    }

    private synchronized void addBinding(AbstractName abstractName, Name name, Object value) throws NamingException {
        LinkedHashMap<AbstractName, Object> bindings = (LinkedHashMap<AbstractName, Object>)this.bindingsByName.get(name);
        if (bindings == null) {
            this.addDeepBinding(name, value, true, true);
            bindings = new LinkedHashMap<AbstractName, Object>();
            bindings.put(abstractName, value);
            this.bindingsByName.put(name, bindings);
        } else {
            bindings.put(abstractName, value);
        }
    }

    protected synchronized void removeBinding(AbstractName abstractName) {
        Set bindingNames = (Set)this.bindingsByAbstractName.remove(abstractName);
        if (bindingNames == null) {
            return;
        }
        Iterator iterator = bindingNames.iterator();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            LinkedHashMap bindings = (LinkedHashMap)this.bindingsByName.get(name);
            if (bindings == null) continue;
            if (KernelContextGBean.first(bindings).getKey().equals(abstractName)) {
                bindings.remove(abstractName);
                Map.Entry newEntry = KernelContextGBean.first(bindings);
                if (newEntry != null) {
                    Object newAbstractName = newEntry.getValue();
                    Object newValue = newEntry.getValue();
                    try {
                        this.addDeepBinding(name, newValue, true, true);
                    }
                    catch (NamingException e) {
                        boolean logged = false;
                        try {
                            this.removeDeepBinding(name, true);
                        }
                        catch (NamingException e1) {
                            logged = true;
                            log.error((Object)("Unable to remove binding " + name + " to " + abstractName), (Throwable)e);
                        }
                        if (logged) continue;
                        log.error((Object)("Unable to rebind binding " + name + " to " + newAbstractName));
                    }
                    continue;
                }
                this.bindingsByName.remove(name);
                try {
                    this.removeDeepBinding(name, true, true);
                }
                catch (NamingException e) {
                    log.error((Object)("Unable to remove binding " + name + " to " + abstractName), (Throwable)e);
                }
                continue;
            }
            bindings.remove(abstractName);
        }
    }

    private static Map.Entry first(LinkedHashMap map) {
        if (map.isEmpty()) {
            return null;
        }
        return map.entrySet().iterator().next();
    }

    protected Map createBindings(AbstractName abstractName, Object value) throws NamingException {
        Name name = this.createBindingName(abstractName, value);
        if (name == null) {
            return null;
        }
        if ((value = this.preprocessVaue(abstractName, name, value)) == null) {
            return null;
        }
        Map<Name, Object> bindings = Collections.singletonMap(name, value);
        return bindings;
    }

    protected Name createBindingName(AbstractName abstractName, Object value) throws NamingException {
        String shortName = (String)abstractName.getName().get("name");
        return this.getNameParser().parse(shortName);
    }

    protected Object preprocessVaue(AbstractName abstractName, Name name, Object value) throws NamingException {
        return value;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder builder = GBeanInfoBuilder.createStatic((Class)KernelContextGBean.class, (String)"Context");
        builder.addAttribute("nameInNamespace", String.class, true);
        builder.addAttribute("abstractNameQuery", AbstractNameQuery.class, true);
        builder.setConstructor(new String[]{"nameInNamespace", "abstractNameQuery", "kernel"});
        GBEAN_INFO = builder.getBeanInfo();
    }

    private class ContextLifecycleListener
    extends LifecycleAdapter {
        private ContextLifecycleListener() {
        }

        public void running(AbstractName abstractName) {
            try {
                KernelContextGBean.this.addBinding(abstractName);
            }
            catch (NamingException e) {
                log.error((Object)("Error adding binding for " + abstractName));
            }
        }

        public void stopping(AbstractName abstractName) {
            KernelContextGBean.this.removeBinding(abstractName);
        }

        public void stopped(AbstractName abstractName) {
            KernelContextGBean.this.removeBinding(abstractName);
        }

        public void failed(AbstractName abstractName) {
            KernelContextGBean.this.removeBinding(abstractName);
        }

        public void unloaded(AbstractName abstractName) {
            KernelContextGBean.this.removeBinding(abstractName);
        }
    }
}

