/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.ResourceAnnotationHelper;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.reference.ClassReference;
import org.apache.geronimo.naming.reference.JndiReference;
import org.apache.geronimo.naming.reference.KernelReference;
import org.apache.geronimo.xbeans.geronimo.naming.GerEnvEntryDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerEnvEntryType;
import org.apache.geronimo.xbeans.javaee6.DescriptionType;
import org.apache.geronimo.xbeans.javaee6.EnvEntryType;
import org.apache.geronimo.xbeans.javaee6.EnvEntryTypeValuesType;
import org.apache.geronimo.xbeans.javaee6.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee6.JndiNameType;
import org.apache.geronimo.xbeans.javaee6.XsdStringType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentEntryBuilder
extends AbstractNamingBuilder
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentEntryBuilder.class);
    private static final Map<String, String> NAMESPACE_UPDATES = new HashMap<String, String>();
    private static final QName GER_ENV_ENTRY_QNAME;
    private static final QNameSet GER_ENV_ENTRY_QNAME_SET;
    private final QNameSet envEntryQNameSet;
    public static final GBeanInfo GBEAN_INFO;

    public EnvironmentEntryBuilder(String[] eeNamespaces) {
        this.envEntryQNameSet = EnvironmentEntryBuilder.buildQNameSet(eeNamespaces, "env-entry");
    }

    public void doStart() throws Exception {
        XmlBeansUtil.registerNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doStop() {
        XmlBeansUtil.unregisterNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doFail() {
        this.doStop();
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map<EARContext.Key, Object> sharedContext) throws DeploymentException {
        if (module != null && module.getClassFinder() != null) {
            try {
                ResourceAnnotationHelper.processAnnotations((AnnotatedApp)module.getAnnotatedApp(), (ClassFinder)module.getClassFinder(), (ResourceAnnotationHelper.ResourceProcessor)EnvEntryRefProcessor.INSTANCE);
            }
            catch (Exception e) {
                log.warn("Unable to process @Resource annotations for module" + module.getName(), (Throwable)e);
            }
        }
        Bundle bundle = module.getEarContext().getDeploymentBundle();
        List<EnvEntryType> envEntriesUntyped = EnvironmentEntryBuilder.convert(specDD.selectChildren(this.envEntryQNameSet), JEE_CONVERTER, EnvEntryType.class, EnvEntryType.type);
        XmlObject[] gerEnvEntryUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_ENV_ENTRY_QNAME_SET);
        Map<String, String> envEntryMap = this.mapEnvEntries(gerEnvEntryUntyped);
        for (EnvEntryType envEntry : envEntriesUntyped) {
            Object value;
            String name;
            block26: {
                String lookupName;
                Class typeClass;
                name = EnvironmentEntryBuilder.getStringValue((org.apache.geronimo.xbeans.javaee6.String)envEntry.getEnvEntryName());
                String type = EnvironmentEntryBuilder.getStringValue((org.apache.geronimo.xbeans.javaee6.String)envEntry.getEnvEntryType());
                try {
                    typeClass = bundle.loadClass(type);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException("Could not env-entry type class " + type, (Throwable)e);
                }
                value = null;
                String strValue = envEntryMap.remove(name);
                if (strValue == null && (strValue = EnvironmentEntryBuilder.getStringValue(envEntry.getEnvEntryValue())) == null && (lookupName = EnvironmentEntryBuilder.getStringValue(envEntry.getLookupName())) != null) {
                    if (lookupName.equals(this.getJndiName(name))) {
                        throw new DeploymentException("env-entry lookup name refers to itself");
                    }
                    value = new JndiReference(lookupName);
                }
                if (value == null) {
                    if (strValue == null) {
                        if ("org.apache.geronimo.kernel.Kernel".equals(type)) {
                            value = new KernelReference();
                        }
                    } else {
                        try {
                            if (String.class.equals((Object)typeClass)) {
                                value = strValue;
                                break block26;
                            }
                            if (Character.class.equals((Object)typeClass)) {
                                value = Character.valueOf(strValue.charAt(0));
                                break block26;
                            }
                            if (Boolean.class.equals((Object)typeClass)) {
                                value = Boolean.valueOf(strValue);
                                break block26;
                            }
                            if (Byte.class.equals((Object)typeClass)) {
                                value = Byte.valueOf(strValue);
                                break block26;
                            }
                            if (Short.class.equals((Object)typeClass)) {
                                value = Short.valueOf(strValue);
                                break block26;
                            }
                            if (Integer.class.equals((Object)typeClass)) {
                                value = Integer.valueOf(strValue);
                                break block26;
                            }
                            if (Long.class.equals((Object)typeClass)) {
                                value = Long.valueOf(strValue);
                                break block26;
                            }
                            if (Float.class.equals((Object)typeClass)) {
                                value = Float.valueOf(strValue);
                                break block26;
                            }
                            if (Double.class.equals((Object)typeClass)) {
                                value = Double.valueOf(strValue);
                                break block26;
                            }
                            if (Class.class.equals((Object)typeClass)) {
                                value = new ClassReference(strValue);
                                break block26;
                            }
                            if (typeClass.isEnum()) {
                                value = Enum.valueOf(typeClass, strValue);
                                break block26;
                            }
                            throw new DeploymentException("Unrecognized env-entry type: " + type);
                        }
                        catch (NumberFormatException e) {
                            throw new DeploymentException("Invalid env-entry value for name: " + name, (Throwable)e);
                        }
                    }
                }
            }
            if (value == null) continue;
            this.addInjections(name, envEntry.getInjectionTargetArray(), sharedContext);
            this.put(name, value, this.getJndiContextMap(sharedContext));
        }
        if (!envEntryMap.isEmpty()) {
            throw new DeploymentException("Unknown env-entry elements in geronimo plan: " + envEntryMap);
        }
    }

    private Map<String, String> mapEnvEntries(XmlObject[] refs) {
        HashMap<String, String> envEntryMap = new HashMap<String, String>();
        if (refs != null) {
            for (XmlObject ref1 : refs) {
                GerEnvEntryType ref = (GerEnvEntryType)ref1.copy().changeType(GerEnvEntryType.type);
                envEntryMap.put(ref.getEnvEntryName().trim(), ref.getEnvEntryValue().trim());
            }
        }
        return envEntryMap;
    }

    public QNameSet getSpecQNameSet() {
        return this.envEntryQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.EMPTY;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/naming", "http://geronimo.apache.org/xml/ns/naming-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/naming-1.1", "http://geronimo.apache.org/xml/ns/naming-1.2");
        GER_ENV_ENTRY_QNAME = GerEnvEntryDocument.type.getDocumentElementName();
        GER_ENV_ENTRY_QNAME_SET = QNameSet.singleton((QName)GER_ENV_ENTRY_QNAME);
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(EnvironmentEntryBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("eeNamespaces", String[].class, true, true);
        infoBuilder.setConstructor(new String[]{"eeNamespaces"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    public static class EnvEntryRefProcessor
    extends ResourceAnnotationHelper.ResourceProcessor {
        public static final EnvEntryRefProcessor INSTANCE = new EnvEntryRefProcessor();

        private EnvEntryRefProcessor() {
        }

        public boolean processResource(AnnotatedApp annotatedApp, Resource annotation, Class cls, Method method, Field field) {
            String resourceName = EnvEntryRefProcessor.getResourceName((Resource)annotation, (Method)method, (Field)field);
            Class resourceType = EnvEntryRefProcessor.getResourceTypeClass((Resource)annotation, (Method)method, (Field)field);
            if (resourceType.equals(String.class) || resourceType.equals(Character.class) || resourceType.equals(Integer.class) || resourceType.equals(Boolean.class) || resourceType.equals(Double.class) || resourceType.equals(Byte.class) || resourceType.equals(Short.class) || resourceType.equals(Long.class) || resourceType.equals(Float.class) || resourceType.equals(Class.class) || resourceType.isEnum()) {
                EnvEntryType[] envEntries;
                log.debug("addResource(): <env-entry> found");
                boolean exists = false;
                for (EnvEntryType envEntry : envEntries = annotatedApp.getEnvEntryArray()) {
                    InjectionTargetType[] targets;
                    if (!AbstractNamingBuilder.getStringValue((org.apache.geronimo.xbeans.javaee6.String)envEntry.getEnvEntryName()).equals(resourceName)) continue;
                    exists = true;
                    if (method == null && field == null || EnvEntryRefProcessor.hasTarget((Method)method, (Field)field, (InjectionTargetType[])(targets = envEntry.getInjectionTargetArray()))) break;
                    EnvEntryRefProcessor.configureInjectionTarget((InjectionTargetType)envEntry.addNewInjectionTarget(), (Method)method, (Field)field);
                    break;
                }
                if (!exists) {
                    try {
                        String lookup;
                        String descriptionAnnotation;
                        String mappdedNameAnnotation;
                        log.debug("addResource(): Does not exist in DD: " + resourceName);
                        EnvEntryType envEntry = annotatedApp.addNewEnvEntry();
                        JndiNameType envEntryName = envEntry.addNewEnvEntryName();
                        envEntryName.setStringValue(resourceName);
                        if (!resourceType.equals(Object.class)) {
                            EnvEntryTypeValuesType envEntryType = envEntry.addNewEnvEntryType();
                            envEntryType.setStringValue(resourceType.getCanonicalName());
                        }
                        if (method != null || field != null) {
                            InjectionTargetType injectionTarget = envEntry.addNewInjectionTarget();
                            EnvEntryRefProcessor.configureInjectionTarget((InjectionTargetType)injectionTarget, (Method)method, (Field)field);
                        }
                        if (!(mappdedNameAnnotation = annotation.mappedName()).equals("")) {
                            XsdStringType mappedName = envEntry.addNewMappedName();
                            mappedName.setStringValue(mappdedNameAnnotation);
                        }
                        if (!(descriptionAnnotation = annotation.description()).equals("")) {
                            DescriptionType description = envEntry.addNewDescription();
                            description.setStringValue(descriptionAnnotation);
                        }
                        if (!(lookup = annotation.lookup()).equals("")) {
                            XsdStringType lookupName = envEntry.addNewLookupName();
                            lookupName.setStringValue(lookup);
                        }
                    }
                    catch (Exception anyException) {
                        log.debug("ResourceAnnotationHelper: Exception caught while processing <env-entry>");
                    }
                }
            }
            return false;
        }
    }
}

