/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;

public class ENCConfigBuilder {
    public static AbstractNameQuery getGBeanQuery(String j2eeType, GerGbeanLocatorType gerGbeanLocator) {
        AbstractNameQuery abstractNameQuery;
        if (gerGbeanLocator.isSetGbeanLink()) {
            String linkName = gerGbeanLocator.getGbeanLink().trim();
            abstractNameQuery = ENCConfigBuilder.buildAbstractNameQuery(null, null, linkName, j2eeType, null);
        } else {
            GerPatternType patternType = gerGbeanLocator.getPattern();
            abstractNameQuery = ENCConfigBuilder.buildAbstractNameQuery(patternType, j2eeType, null, null);
        }
        return abstractNameQuery;
    }

    public static AbstractNameQuery buildAbstractNameQuery(GerPatternType pattern, String type, String moduleType, Set interfaceTypes) {
        return ENCConfigBuilder.buildAbstractNameQueryFromPattern(pattern, "car", type, moduleType, interfaceTypes);
    }

    public static AbstractNameQuery buildAbstractNameQueryFromPattern(GerPatternType pattern, String artifactType, String type, String moduleType, Set interfaceTypes) {
        String groupId = pattern.isSetGroupId() ? pattern.getGroupId().trim() : null;
        String artifactid = pattern.isSetArtifactId() ? pattern.getArtifactId().trim() : null;
        String version = pattern.isSetVersion() ? pattern.getVersion().trim() : null;
        String module = pattern.isSetModule() ? pattern.getModule().trim() : null;
        String name = pattern.getName().trim();
        Artifact artifact = artifactid != null ? new Artifact(groupId, artifactid, version, artifactType) : null;
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("name", name);
        if (type != null) {
            nameMap.put("j2eeType", type);
        }
        if (module != null && moduleType != null) {
            nameMap.put(moduleType, module);
        }
        if (interfaceTypes != null) {
            HashSet<String> trimmed = new HashSet<String>();
            for (String intf : interfaceTypes) {
                trimmed.add(intf == null ? null : intf.trim());
            }
            interfaceTypes = trimmed;
        }
        return new AbstractNameQuery(artifact, nameMap, (Set)interfaceTypes);
    }

    public static AbstractNameQuery buildAbstractNameQuery(Artifact configId, String module, String name, String type, String moduleType) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("name", name);
        if (type != null) {
            nameMap.put("j2eeType", type);
        }
        if (module != null && moduleType != null) {
            nameMap.put(moduleType, module);
        }
        return new AbstractNameQuery(configId, nameMap);
    }
}

