/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerAbstractNamingEntryDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public abstract class AbstractNamingBuilder
implements NamingBuilder {
    protected static final String J2EE_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    protected static final String JEE_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    protected static final NamespaceElementConverter J2EE_CONVERTER = new NamespaceElementConverter("http://java.sun.com/xml/ns/j2ee");
    protected static final NamespaceElementConverter NAMING_CONVERTER = new NamespaceElementConverter(GerAbstractNamingEntryDocument.type.getDocumentElementName().getNamespaceURI());
    private final Environment defaultEnvironment;

    protected AbstractNamingBuilder() {
        this.defaultEnvironment = null;
    }

    protected AbstractNamingBuilder(Environment defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    public void buildEnvironment(XmlObject specDD, XmlObject plan, Environment environment) throws DeploymentException {
        if (this.willMergeEnvironment(specDD, plan)) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
        }
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) throws DeploymentException {
        return false;
    }

    protected boolean matchesDefaultEnvironment(Environment environment) {
        Iterator iterator = this.defaultEnvironment.getDependencies().iterator();
        while (iterator.hasNext()) {
            Dependency defaultDependency = (Dependency)iterator.next();
            boolean matches = false;
            Iterator iterator1 = environment.getDependencies().iterator();
            while (iterator1.hasNext()) {
                Dependency actualDependency = (Dependency)iterator1.next();
                if (!this.matches(defaultDependency, actualDependency)) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    private boolean matches(Dependency defaultDependency, Dependency actualDependency) {
        if (defaultDependency.getArtifact().matches(actualDependency.getArtifact()) || actualDependency.getArtifact().matches(defaultDependency.getArtifact())) {
            return defaultDependency.getImportType() == actualDependency.getImportType() || actualDependency.getImportType() == ImportType.ALL;
        }
        return false;
    }

    public void initContext(XmlObject specDD, XmlObject plan, Configuration localConfiguration, Configuration remoteConfiguration, Module module) throws DeploymentException {
    }

    protected Map getJndiContextMap(Map sharedContext) {
        return (Map)sharedContext.get("JNDI_COMPONENT_CONTEXT");
    }

    protected AbstractName getGBeanName(Map sharedContext) {
        return (AbstractName)sharedContext.get("GBEAN_NAME");
    }

    protected static QNameSet buildQNameSet(String[] eeNamespaces, String localPart) {
        HashSet<QName> qnames = new HashSet<QName>(eeNamespaces.length);
        for (int i = 0; i < eeNamespaces.length; ++i) {
            String namespace = eeNamespaces[i];
            qnames.add(new QName(namespace, localPart));
        }
        return QNameSet.forSets(null, (Set)Collections.EMPTY_SET, (Set)Collections.EMPTY_SET, qnames);
    }

    protected static XmlObject[] convert(XmlObject[] xmlObjects, NamespaceElementConverter converter, SchemaType type) throws DeploymentException {
        XmlObject[] converted = new XmlObject[xmlObjects.length];
        for (int i = 0; i < xmlObjects.length; ++i) {
            XmlObject xmlObject = xmlObjects[i];
            if (xmlObject.schemaType() != type) {
                xmlObject = xmlObject.copy();
                converter.convertElement(xmlObject);
                converted[i] = xmlObject.changeType(type);
            } else {
                converted[i] = xmlObject;
            }
            try {
                XmlBeansUtil.validateDD((XmlObject)converted[i]);
                continue;
            }
            catch (XmlException e) {
                throw new DeploymentException("Could not validate xmlObject of type " + type, (Throwable)e);
            }
        }
        return converted;
    }

    protected static String getStringValue(org.apache.geronimo.xbeans.j2ee.String string) {
        if (string == null) {
            return null;
        }
        String s = string.getStringValue();
        return s == null ? null : s.trim();
    }

    public static AbstractNameQuery buildAbstractNameQuery(GerPatternType pattern, String type, String moduleType, Set interfaceTypes) {
        String groupId = pattern.isSetGroupId() ? pattern.getGroupId().trim() : null;
        String artifactid = pattern.isSetArtifactId() ? pattern.getArtifactId().trim() : null;
        String version = pattern.isSetVersion() ? pattern.getVersion().trim() : null;
        String module = pattern.isSetModule() ? pattern.getModule().trim() : null;
        String name = pattern.getName().trim();
        Artifact artifact = artifactid != null ? new Artifact(groupId, artifactid, version, null) : null;
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("name", name);
        if (type != null) {
            nameMap.put("j2eeType", type);
        }
        if (module != null && moduleType != null) {
            nameMap.put(moduleType, module);
        }
        if (interfaceTypes != null) {
            HashSet<String> trimmed = new HashSet<String>();
            Iterator it = interfaceTypes.iterator();
            while (it.hasNext()) {
                String intf = (String)it.next();
                trimmed.add(intf == null ? null : intf.trim());
            }
            interfaceTypes = trimmed;
        }
        return new AbstractNameQuery(artifact, nameMap, (Set)interfaceTypes);
    }

    public static AbstractNameQuery buildAbstractNameQuery(Artifact configId, String module, String name, String type, String moduleType) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("name", name);
        if (type != null) {
            nameMap.put("j2eeType", type);
        }
        if (module != null) {
            nameMap.put(moduleType, module);
        }
        return new AbstractNameQuery(configId, nameMap);
    }

    public static Class assureInterface(String interfaceName, String superInterfaceName, String interfaceType, ClassLoader cl) throws DeploymentException {
        Class<?> superInterface;
        Class<?> clazz;
        if (interfaceName == null || interfaceName.equals("")) {
            throw new DeploymentException("interface name cannot be blank");
        }
        try {
            clazz = cl.loadClass(interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(interfaceType + " interface class not found: " + interfaceName);
        }
        if (!clazz.isInterface()) {
            throw new DeploymentException(interfaceType + " interface is not an interface: " + interfaceName);
        }
        try {
            superInterface = cl.loadClass(superInterfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Class " + superInterfaceName + " could not be loaded");
        }
        if (!superInterface.isAssignableFrom(clazz)) {
            throw new DeploymentException(interfaceType + " interface does not extend " + superInterfaceName + ": " + interfaceName);
        }
        return clazz;
    }
}

