/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.myfaces.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.config.element.Behavior;
import org.apache.myfaces.config.element.ClientBehaviorRenderer;
import org.apache.myfaces.config.element.Converter;
import org.apache.myfaces.config.element.FacesConfigData;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NamedEvent;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.element.ResourceBundle;
import org.apache.myfaces.config.element.SystemEventListener;
import org.apache.myfaces.config.impl.digester.elements.LocaleConfig;
import org.apache.myfaces.config.impl.digester.elements.RenderKit;

public class GeronimoFacesConfigData
extends FacesConfigData {
    private List<String> applicationFactories = new ArrayList<String>();
    private List<String> exceptionHandlerFactories = new ArrayList<String>();
    private List<String> externalContextFactories = new ArrayList<String>();
    private List<String> facesContextFactories = new ArrayList<String>();
    private List<String> lifecycleFactories = new ArrayList<String>();
    private List<String> viewDeclarationLanguageFactories = new ArrayList<String>();
    private List<String> partialViewContextFactories = new ArrayList<String>();
    private List<String> renderKitFactories = new ArrayList<String>();
    private List<String> tagHandlerDelegateFactories = new ArrayList<String>();
    private List<String> visitContextFactories = new ArrayList<String>();
    private String defaultRenderKitId;
    private String messageBundle;
    private String partialTraversal;
    private String facesVersion;
    private org.apache.myfaces.config.element.LocaleConfig localeConfig;
    private Map<String, String> components = new HashMap<String, String>();
    private Map<String, String> converterByClass = new HashMap<String, String>();
    private Map<String, String> converterById = new HashMap<String, String>();
    private Map<String, String> validators = new HashMap<String, String>();
    private List<Behavior> behaviors = new ArrayList<Behavior>();
    private Map<String, Converter> converterConfigurationByClassName = new HashMap<String, Converter>();
    private Map<String, RenderKit> renderKits = new LinkedHashMap<String, RenderKit>();
    private List<String> actionListeners = new ArrayList<String>();
    private List<String> elResolvers = new ArrayList<String>();
    private List<String> lifecyclePhaseListeners = new ArrayList<String>();
    private List<String> navigationHandlers = new ArrayList<String>();
    private List<String> propertyResolver = new ArrayList<String>();
    private List<String> resourceHandlers = new ArrayList<String>();
    private List<String> stateManagers = new ArrayList<String>();
    private List<String> variableResolver = new ArrayList<String>();
    private List<String> viewHandlers = new ArrayList<String>();
    private List<String> defaultValidatorIds = new ArrayList<String>();
    private List<ManagedBean> managedBeans = new ArrayList<ManagedBean>();
    private List<NavigationRule> navigationRules = new ArrayList<NavigationRule>();
    private List<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
    private List<SystemEventListener> systemEventListeners = new ArrayList<SystemEventListener>();
    private List<NamedEvent> namedEvents = new ArrayList<NamedEvent>();

    public GeronimoFacesConfigData(FacesConfigData facesConfigData) {
        this.applicationFactories.addAll(facesConfigData.getApplicationFactoryIterator());
        this.exceptionHandlerFactories.addAll(facesConfigData.getExceptionHandlerFactoryIterator());
        this.externalContextFactories.addAll(facesConfigData.getExternalContextFactoryIterator());
        this.facesContextFactories.addAll(facesConfigData.getFacesContextFactoryIterator());
        this.lifecycleFactories.addAll(facesConfigData.getLifecycleFactoryIterator());
        this.viewDeclarationLanguageFactories.addAll(facesConfigData.getViewDeclarationLanguageFactoryIterator());
        this.partialViewContextFactories.addAll(facesConfigData.getPartialViewContextFactoryIterator());
        this.renderKitFactories.addAll(facesConfigData.getRenderKitFactoryIterator());
        this.tagHandlerDelegateFactories.addAll(facesConfigData.getTagHandlerDelegateFactoryIterator());
        this.visitContextFactories.addAll(facesConfigData.getVisitContextFactoryIterator());
        this.defaultRenderKitId = facesConfigData.getDefaultRenderKitId();
        this.messageBundle = facesConfigData.getMessageBundle();
        this.partialTraversal = facesConfigData.getPartialTraversal();
        this.facesVersion = facesConfigData.getFacesVersion();
        if (facesConfigData.getDefaultLocale() != null || facesConfigData.getSupportedLocalesIterator().size() > 0) {
            LocaleConfig destLocaleConfig = new LocaleConfig();
            destLocaleConfig.setDefaultLocale(facesConfigData.getDefaultLocale());
            destLocaleConfig.getSupportedLocales().addAll(facesConfigData.getSupportedLocalesIterator());
            this.localeConfig = destLocaleConfig;
        }
        for (String componentType : facesConfigData.getComponentTypes()) {
            this.components.put(componentType, facesConfigData.getComponentClass(componentType));
        }
        for (String converterClass : facesConfigData.getConverterClasses()) {
            this.converterByClass.put(converterClass, facesConfigData.getConverterClassByClass(converterClass));
        }
        for (String converterId : facesConfigData.getConverterIds()) {
            this.converterById.put(converterId, facesConfigData.getConverterClassById(converterId));
        }
        for (String validatorId : facesConfigData.getValidatorIds()) {
            this.validators.put(validatorId, facesConfigData.getValidatorClass(validatorId));
        }
        this.behaviors.addAll(facesConfigData.getBehaviors());
        for (String converterClassName : facesConfigData.getConverterConfigurationByClassName()) {
            this.converterConfigurationByClassName.put(converterClassName, facesConfigData.getConverterConfiguration(converterClassName));
        }
        for (String renderKitId : facesConfigData.getRenderKitIds()) {
            RenderKit renderKit = new RenderKit();
            renderKit.setId(renderKitId);
            renderKit.getClientBehaviorRenderers().addAll(facesConfigData.getClientBehaviorRenderers(renderKitId));
            renderKit.getRenderer().addAll(facesConfigData.getRenderers(renderKitId));
            renderKit.getRenderKitClasses().addAll(facesConfigData.getRenderKitClasses(renderKitId));
            this.renderKits.put(renderKitId, renderKit);
        }
        this.actionListeners.addAll(facesConfigData.getActionListenerIterator());
        this.elResolvers.addAll(facesConfigData.getElResolvers());
        this.lifecyclePhaseListeners.addAll(facesConfigData.getLifecyclePhaseListeners());
        this.navigationHandlers.addAll(facesConfigData.getNavigationHandlerIterator());
        this.propertyResolver.addAll(facesConfigData.getPropertyResolverIterator());
        this.resourceHandlers.addAll(facesConfigData.getResourceHandlerIterator());
        this.stateManagers.addAll(facesConfigData.getStateManagerIterator());
        this.variableResolver.addAll(facesConfigData.getVariableResolverIterator());
        this.viewHandlers.addAll(facesConfigData.getViewHandlerIterator());
        this.defaultValidatorIds.addAll(facesConfigData.getDefaultValidatorIds());
        this.managedBeans.addAll(facesConfigData.getManagedBeans());
        this.navigationRules.addAll(facesConfigData.getNavigationRules());
        this.resourceBundles.addAll(facesConfigData.getResourceBundles());
        this.systemEventListeners.addAll(facesConfigData.getSystemEventListeners());
        this.namedEvents.addAll(facesConfigData.getNamedEvents());
    }

    public Collection<String> getActionListenerIterator() {
        return new ArrayList<String>(this.actionListeners);
    }

    public String getDefaultRenderKitId() {
        return this.defaultRenderKitId;
    }

    public String getMessageBundle() {
        return this.messageBundle;
    }

    public Collection<String> getNavigationHandlerIterator() {
        return new ArrayList<String>(this.navigationHandlers);
    }

    public String getPartialTraversal() {
        return this.partialTraversal;
    }

    public Collection<String> getResourceHandlerIterator() {
        return new ArrayList<String>(this.resourceHandlers);
    }

    public Collection<String> getViewHandlerIterator() {
        return new ArrayList<String>(this.viewHandlers);
    }

    public Collection<String> getStateManagerIterator() {
        return new ArrayList<String>(this.stateManagers);
    }

    public Collection<String> getPropertyResolverIterator() {
        return new ArrayList<String>(this.propertyResolver);
    }

    public Collection<String> getVariableResolverIterator() {
        return new ArrayList<String>(this.variableResolver);
    }

    public String getDefaultLocale() {
        if (this.localeConfig != null) {
            return this.localeConfig.getDefaultLocale();
        }
        return null;
    }

    public Collection<String> getSupportedLocalesIterator() {
        List locale = this.localeConfig != null ? this.localeConfig.getSupportedLocales() : Collections.emptyList();
        return locale;
    }

    public Collection<String> getComponentTypes() {
        return this.components.keySet();
    }

    public String getComponentClass(String componentType) {
        return this.components.get(componentType);
    }

    public Collection<String> getConverterIds() {
        return this.converterById.keySet();
    }

    public Collection<String> getConverterClasses() {
        return this.converterByClass.keySet();
    }

    public Collection<String> getConverterConfigurationByClassName() {
        return this.converterConfigurationByClassName.keySet();
    }

    public Converter getConverterConfiguration(String converterClassName) {
        return this.converterConfigurationByClassName.get(converterClassName);
    }

    public String getConverterClassById(String converterId) {
        return this.converterById.get(converterId);
    }

    public String getConverterClassByClass(String className) {
        return this.converterByClass.get(className);
    }

    public Collection<String> getDefaultValidatorIds() {
        return this.defaultValidatorIds;
    }

    public Collection<String> getValidatorIds() {
        return this.validators.keySet();
    }

    public String getValidatorClass(String validatorId) {
        return this.validators.get(validatorId);
    }

    public Collection<ManagedBean> getManagedBeans() {
        return this.managedBeans;
    }

    public Collection<NavigationRule> getNavigationRules() {
        return this.navigationRules;
    }

    public Collection<String> getRenderKitIds() {
        return this.renderKits.keySet();
    }

    public Collection<String> getRenderKitClasses(String renderKitId) {
        return this.renderKits.get(renderKitId).getRenderKitClasses();
    }

    public Collection<ClientBehaviorRenderer> getClientBehaviorRenderers(String renderKitId) {
        return this.renderKits.get(renderKitId).getClientBehaviorRenderers();
    }

    public Collection<Renderer> getRenderers(String renderKitId) {
        return this.renderKits.get(renderKitId).getRenderer();
    }

    public Collection<String> getLifecyclePhaseListeners() {
        return this.lifecyclePhaseListeners;
    }

    public Collection<ResourceBundle> getResourceBundles() {
        return this.resourceBundles;
    }

    public Collection<String> getElResolvers() {
        return this.elResolvers;
    }

    public Collection<SystemEventListener> getSystemEventListeners() {
        return this.systemEventListeners;
    }

    public Collection<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public String getFacesVersion() {
        return this.facesVersion;
    }

    public Collection<NamedEvent> getNamedEvents() {
        return this.namedEvents;
    }

    public Collection<String> getApplicationFactoryIterator() {
        return this.applicationFactories;
    }

    public Collection<String> getExceptionHandlerFactoryIterator() {
        return this.exceptionHandlerFactories;
    }

    public Collection<String> getExternalContextFactoryIterator() {
        return this.externalContextFactories;
    }

    public Collection<String> getFacesContextFactoryIterator() {
        return this.facesContextFactories;
    }

    public Collection<String> getLifecycleFactoryIterator() {
        return this.lifecycleFactories;
    }

    public Collection<String> getViewDeclarationLanguageFactoryIterator() {
        return this.viewDeclarationLanguageFactories;
    }

    public Collection<String> getPartialViewContextFactoryIterator() {
        return this.partialViewContextFactories;
    }

    public Collection<String> getRenderKitFactoryIterator() {
        return this.renderKitFactories;
    }

    public Collection<String> getTagHandlerDelegateFactoryIterator() {
        return this.tagHandlerDelegateFactories;
    }

    public Collection<String> getVisitContextFactoryIterator() {
        return this.visitContextFactories;
    }
}

