/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail;

import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.mail.NNTPGBeanConstants;
import org.apache.geronimo.mail.ProtocolGBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NNTPTransportGBean
extends ProtocolGBean
implements NNTPGBeanConstants {
    private static final Logger log = LoggerFactory.getLogger(NNTPTransportGBean.class);
    private Integer port;
    private Integer connectionTimeout;
    private Integer timeout;
    private String from;
    private Boolean auth;
    private String saslRealm;
    private Boolean quitWait;
    private String socketFactoryClass;
    private Boolean socketFactoryFallback;
    private Integer socketFactoryPort;
    public static final GBeanInfo GBEAN_INFO;

    public NNTPTransportGBean(String objectName, Properties properties, String host, String user, Integer port, Integer connectionTimeout, Integer timeout, String from, Boolean auth, String saslRealm, Boolean quitWait, String socketFactoryClass, Boolean socketFactoryFallback, Integer socketFactoryPort) {
        super(objectName, "nntp-post", properties, host, user);
        this.setPort(port);
        this.setConnectionTimeout(connectionTimeout);
        this.setTimeout(timeout);
        this.setFrom(from);
        this.setAuth(auth);
        this.setSaslRealm(saslRealm);
        this.setQuitWait(quitWait);
        this.setSocketFactoryClass(socketFactoryClass);
        this.setSocketFactoryFallback(socketFactoryFallback);
        this.setSocketFactoryPort(socketFactoryPort);
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Boolean getAuth() {
        return this.auth;
    }

    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    public String getSaslRealm() {
        return this.saslRealm;
    }

    public void setSaslRealm(String saslRealm) {
        this.saslRealm = saslRealm;
    }

    public Boolean getQuitWait() {
        return this.quitWait;
    }

    public void setQuitWait(Boolean quitWait) {
        this.quitWait = quitWait;
    }

    public String getSocketFactoryClass() {
        return this.socketFactoryClass;
    }

    public void setSocketFactoryClass(String socketFactoryClass) {
        this.socketFactoryClass = socketFactoryClass;
    }

    public Boolean getSocketFactoryFallback() {
        return this.socketFactoryFallback;
    }

    public void setSocketFactoryFallback(Boolean socketFactoryFallback) {
        this.socketFactoryFallback = socketFactoryFallback;
    }

    public Integer getSocketFactoryPort() {
        return this.socketFactoryPort;
    }

    public void setSocketFactoryPort(Integer socketFactoryPort) {
        this.socketFactoryPort = socketFactoryPort;
    }

    public void addOverrides(Properties props) {
        super.addOverrides(props);
        if (this.port != null) {
            props.setProperty("mail.nntp.port", this.port.toString());
        }
        if (this.connectionTimeout != null) {
            props.setProperty("mail.nntp.connectiontimeout", this.connectionTimeout.toString());
        }
        if (this.timeout != null) {
            props.setProperty("mail.nntp.timeout", this.timeout.toString());
        }
        if (this.from != null) {
            props.setProperty("mail.nntp.from", this.from);
        }
        if (this.auth != null) {
            props.setProperty("mail.nntp.auth", this.auth.toString());
        }
        if (this.saslRealm != null) {
            props.setProperty("mail.nntp.sasl.realm", this.saslRealm);
        }
        if (this.quitWait != null) {
            props.setProperty("mail.nntp.quitwait", this.quitWait.toString());
        }
        if (this.socketFactoryClass != null) {
            props.setProperty("mail.nntp.socketFactory.class", this.socketFactoryClass);
        }
        if (this.socketFactoryFallback != null) {
            props.setProperty("mail.nntp.socketFactory.fallback", this.socketFactoryFallback.toString());
        }
        if (this.socketFactoryPort != null) {
            props.setProperty("mail.nntp.socketFactory.port", this.socketFactoryPort.toString());
        }
    }

    public void doStart() throws Exception {
        log.debug("Started " + this.getObjectName());
    }

    public void doStop() throws Exception {
        log.debug("Stopped " + this.getObjectName());
    }

    public void doFail() {
        log.warn("Failed " + this.getObjectName());
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(NNTPTransportGBean.class);
        infoFactory.addAttribute("port", Integer.class, true);
        infoFactory.addAttribute("connectionTimeout", Integer.class, true);
        infoFactory.addAttribute("timeout", Integer.class, true);
        infoFactory.addAttribute("auth", Boolean.class, true);
        infoFactory.addAttribute("from", String.class, true);
        infoFactory.addAttribute("saslRealm", String.class, true);
        infoFactory.addAttribute("quitWait", Boolean.class, true);
        infoFactory.addAttribute("socketFactoryClass", String.class, true);
        infoFactory.addAttribute("socketFactoryFallback", Boolean.class, true);
        infoFactory.addAttribute("socketFactoryPort", Integer.class, true);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("protocol", String.class, true);
        infoFactory.addAttribute("properties", Properties.class, true);
        infoFactory.addAttribute("host", String.class, true);
        infoFactory.addAttribute("user", String.class, true);
        infoFactory.addOperation("addOverrides", new Class[]{Properties.class});
        infoFactory.setConstructor(new String[]{"objectName", "properties", "host", "user", "port", "connectionTimeout", "timeout", "from", "auth", "saslRealm", "quitWait", "socketFactoryClass", "socketFactoryFallback", "socketFactoryPort"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

