/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config.xstream;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.Collection;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationMarshaler;
import org.apache.geronimo.kernel.config.GBeanState;
import org.apache.geronimo.kernel.config.SerializedConfigurationMarshaler;
import org.apache.geronimo.kernel.config.xstream.XStreamGBeanState;
import org.apache.geronimo.kernel.config.xstream.XStreamUtil;

public class XStreamConfigurationMarshaler
implements ConfigurationMarshaler {
    private static byte[] SERIALIZED_MAGIC = new byte[]{-84, -19};

    public XStreamConfigurationMarshaler() {
        XStreamUtil.createXStream();
    }

    public ConfigurationData readConfigurationData(InputStream in) throws IOException, ClassNotFoundException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(in, 2);
        byte[] streamHeader = new byte[2];
        if (pushbackInputStream.read(streamHeader) != 2) {
            throw new AssertionError((Object)"Cound not read stream header");
        }
        pushbackInputStream.unread(streamHeader);
        if (SERIALIZED_MAGIC[0] == streamHeader[0] && SERIALIZED_MAGIC[1] == streamHeader[1]) {
            return new SerializedConfigurationMarshaler().readConfigurationData(pushbackInputStream);
        }
        XStream xstream = XStreamUtil.createXStream();
        InputStreamReader reader = new InputStreamReader(pushbackInputStream);
        ConfigurationData configurationData = (ConfigurationData)xstream.fromXML((Reader)reader);
        return configurationData;
    }

    public void writeConfigurationData(ConfigurationData configurationData, OutputStream out) throws IOException {
        XStream xstream = XStreamUtil.createXStream();
        String xml = xstream.toXML((Object)configurationData);
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<!-- ======================================================== -->\n<!-- Warning - Modification of this file may cause server     -->\n<!-- instability.  Also, the format of this XML file is       -->\n<!-- undocumented and subject to change without notice.       -->\n<!-- ======================================================== -->\n\n".getBytes());
        out.write(xml.getBytes());
        out.flush();
    }

    public GBeanState newGBeanState(Collection gbeans) {
        return new XStreamGBeanState(gbeans);
    }
}

