/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config.xstream;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.DomWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return Document.class.isAssignableFrom(clazz) || Element.class.isAssignableFrom(clazz);
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext marshallingContext) {
        DomReader reader;
        if (object instanceof Document) {
            Document doc = (Document)object;
            reader = new DomReader(doc);
        } else {
            Element element = (Element)object;
            reader = new DomReader(element);
        }
        DomConverter.copy((HierarchicalStreamReader)reader, writer);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext unmarshallingContext) {
        DocumentBuilderFactory documentBuilderFactory = XmlUtil.newDocumentBuilderFactory();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ConversionException("Cannot instantiate " + Document.class.getName(), (Exception)e);
        }
        Document document = documentBuilder.newDocument();
        DomWriter writer = new DomWriter(document);
        DomConverter.copy(reader, (HierarchicalStreamWriter)writer);
        if (Document.class.isAssignableFrom(unmarshallingContext.getRequiredType())) {
            return document;
        }
        return document.getDocumentElement();
    }

    public static void copy(HierarchicalStreamReader reader, HierarchicalStreamWriter writer) {
        writer.startNode(reader.getNodeName());
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeName = reader.getAttributeName(i);
            String attributeValue = reader.getAttribute(i);
            writer.addAttribute(attributeName, attributeValue);
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            DomConverter.copy(reader, writer);
            reader.moveUp();
        }
        String value = reader.getValue();
        if (value != null && value.trim().length() > 0) {
            writer.setValue(value);
        }
        writer.endNode();
    }
}

