/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.beans.Introspector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.kernel.classloader.UnionEnumeration;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.ClassLoaderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiParentClassLoader
extends URLClassLoader {
    private static final Log log = LogFactory.getLog(MultiParentClassLoader.class);
    private final Artifact id;
    private final ClassLoader[] parents;
    private final boolean inverseClassLoading;
    private final String[] hiddenClasses;
    private final String[] nonOverridableClasses;
    private final String[] hiddenResources;
    private final String[] nonOverridableResources;
    private boolean destroyed = false;
    private static final int classLoaderSearchMode;
    private static final int ORIGINAL_SEARCH = 1;
    private static final int OPTIMIZED_SEARCH = 2;
    private static final Object lock;
    private static boolean clearSoftCacheFailed;

    public MultiParentClassLoader(Artifact id, URL[] urls) {
        super(urls);
        this.id = id;
        this.parents = new ClassLoader[]{ClassLoader.getSystemClassLoader()};
        this.inverseClassLoading = false;
        this.hiddenClasses = new String[0];
        this.nonOverridableClasses = new String[0];
        this.hiddenResources = new String[0];
        this.nonOverridableResources = new String[0];
        ClassLoaderRegistry.add(this);
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader parent) {
        this(id, urls, new ClassLoader[]{parent});
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader parent, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        this(id, urls, new ClassLoader[]{parent}, inverseClassLoading, hiddenClasses, nonOverridableClasses);
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(id, urls, new ClassLoader[]{parent}, factory);
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader[] parents) {
        super(urls);
        this.id = id;
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = false;
        this.hiddenClasses = new String[0];
        this.nonOverridableClasses = new String[0];
        this.hiddenResources = new String[0];
        this.nonOverridableResources = new String[0];
        ClassLoaderRegistry.add(this);
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, Collection hiddenClasses, Collection nonOverridableClasses) {
        this(id, urls, parents, inverseClassLoading, hiddenClasses.toArray(new String[hiddenClasses.size()]), nonOverridableClasses.toArray(new String[nonOverridableClasses.size()]));
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        super(urls);
        this.id = id;
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = inverseClassLoading;
        this.hiddenClasses = hiddenClasses;
        this.nonOverridableClasses = nonOverridableClasses;
        this.hiddenResources = this.toResources(hiddenClasses);
        this.nonOverridableResources = this.toResources(nonOverridableClasses);
        ClassLoaderRegistry.add(this);
    }

    public MultiParentClassLoader(MultiParentClassLoader source) {
        this(source.id, source.getURLs(), MultiParentClassLoader.deepCopyParents(source.parents), source.inverseClassLoading, source.hiddenClasses, source.nonOverridableClasses);
    }

    static ClassLoader copy(ClassLoader source) {
        if (source instanceof MultiParentClassLoader) {
            return new MultiParentClassLoader((MultiParentClassLoader)source);
        }
        if (source instanceof URLClassLoader) {
            return new URLClassLoader(((URLClassLoader)source).getURLs(), source.getParent());
        }
        return new URLClassLoader(new URL[0], source);
    }

    ClassLoader copy() {
        return MultiParentClassLoader.copy(this);
    }

    private String[] toResources(String[] classes) {
        String[] resources = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            String className = classes[i];
            resources[i] = className.replace('.', '/');
        }
        return resources;
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader[] parents, URLStreamHandlerFactory factory) {
        super(urls, null, factory);
        this.id = id;
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = false;
        this.hiddenClasses = new String[0];
        this.nonOverridableClasses = new String[0];
        this.hiddenResources = new String[0];
        this.nonOverridableResources = new String[0];
        ClassLoaderRegistry.add(this);
    }

    private static ClassLoader[] copyParents(ClassLoader[] parents) {
        ClassLoader[] newParentsArray = new ClassLoader[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            ClassLoader parent = parents[i];
            if (parent == null) {
                throw new NullPointerException("parent[" + i + "] is null");
            }
            newParentsArray[i] = parent;
        }
        return newParentsArray;
    }

    private static ClassLoader[] deepCopyParents(ClassLoader[] parents) {
        ClassLoader[] newParentsArray = new ClassLoader[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            ClassLoader parent = parents[i];
            if (parent == null) {
                throw new NullPointerException("parent[" + i + "] is null");
            }
            if (parent instanceof MultiParentClassLoader) {
                parent = ((MultiParentClassLoader)parent).copy();
            }
            newParentsArray[i] = parent;
        }
        return newParentsArray;
    }

    public Artifact getId() {
        return this.id;
    }

    public ClassLoader[] getParents() {
        return this.parents;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (classLoaderSearchMode == 1) {
            return this.loadSafeClass(name, resolve);
        }
        return this.loadOptimizedClass(name, resolve);
    }

    protected synchronized Class<?> loadSafeClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cachedClass = this.findLoadedClass(name);
        if (cachedClass != null) {
            return this.resolveClass(cachedClass, resolve);
        }
        if (name.startsWith("java.") || name.equals("boolean") || name.equals("int") || name.equals("double") || name.equals("long")) {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(name);
            return this.resolveClass(clazz, resolve);
        }
        if (this.inverseClassLoading && !this.isDestroyed() && !this.isNonOverridableClass(name)) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        if (!this.isHiddenClass(name)) {
            for (ClassLoader parent : this.parents) {
                try {
                    Class<?> clazz = parent.loadClass(name);
                    return this.resolveClass(clazz, resolve);
                }
                catch (ClassNotFoundException ignored) {
                }
            }
        }
        if (!this.isDestroyed()) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name + " in classloader " + this.id);
    }

    protected synchronized Class<?> loadOptimizedClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cachedClass = this.findLoadedClass(name);
        if (cachedClass != null) {
            return this.resolveClass(cachedClass, resolve);
        }
        try {
            return this.resolveClass(this.findSystemClass(name), resolve);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.inverseClassLoading && !this.isDestroyed() && !this.isNonOverridableClass(name)) {
                try {
                    Class<?> clazz = this.findClass(name);
                    return this.resolveClass(clazz, resolve);
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
            if (!this.isHiddenClass(name)) {
                try {
                    LinkedList<ClassLoader> visitedClassLoaders = new LinkedList<ClassLoader>();
                    Class<?> clazz = this.checkParents(name, resolve, visitedClassLoaders);
                    if (clazz != null) {
                        return this.resolveClass(clazz, resolve);
                    }
                }
                catch (ClassNotFoundException cnfe2) {
                    // empty catch block
                }
            }
            if (!this.isDestroyed()) {
                try {
                    Class<?> clazz = this.findClass(name);
                    return this.resolveClass(clazz, resolve);
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException(name + " in classloader " + this.id);
        }
    }

    protected synchronized Class<?> loadClassInternal(String name, boolean resolve, LinkedList<ClassLoader> visitedClassLoaders) throws ClassNotFoundException {
        Class<?> clazz;
        Class<?> cachedClass = this.findLoadedClass(name);
        if (cachedClass != null) {
            return this.resolveClass(cachedClass, resolve);
        }
        if (!this.isHiddenClass(name)) {
            try {
                clazz = this.checkParents(name, resolve, visitedClassLoaders);
                if (clazz != null) {
                    return this.resolveClass(clazz, resolve);
                }
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (!this.isDestroyed()) {
            clazz = this.findClass(name);
            return this.resolveClass(clazz, resolve);
        }
        return null;
    }

    private synchronized Class<?> checkParents(String name, boolean resolve, LinkedList<ClassLoader> visitedClassLoaders) throws ClassNotFoundException {
        for (ClassLoader parent : this.parents) {
            if (parent == ClassLoader.getSystemClassLoader()) {
                return null;
            }
            if (visitedClassLoaders.contains(parent)) continue;
            visitedClassLoaders.add(parent);
            try {
                if (parent instanceof MultiParentClassLoader) {
                    Class<?> clazz = ((MultiParentClassLoader)parent).loadClassInternal(name, resolve, visitedClassLoaders);
                    if (clazz == null) continue;
                    return this.resolveClass(clazz, resolve);
                }
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isNonOverridableClass(String name) {
        for (String nonOverridableClass : this.nonOverridableClasses) {
            if (!name.startsWith(nonOverridableClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isHiddenClass(String name) {
        for (String hiddenClass : this.hiddenClasses) {
            if (!name.startsWith(hiddenClass)) continue;
            return true;
        }
        return false;
    }

    private Class resolveClass(Class clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL url;
        if (this.isDestroyed()) {
            return null;
        }
        if (this.inverseClassLoading && !this.isDestroyed() && !this.isNonOverridableResource(name) && (url = this.findResource(name)) != null) {
            return url;
        }
        if (!this.isHiddenResource(name)) {
            for (ClassLoader parent : this.parents) {
                URL url2 = parent.getResource(name);
                if (url2 == null) continue;
                return url2;
            }
        }
        if (!this.isDestroyed()) {
            return this.findResource(name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.isDestroyed()) {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
        HashSet<ClassLoader> knownClassloaders = new HashSet<ClassLoader>();
        ArrayList enumerations = new ArrayList();
        this.recursiveFind(knownClassloaders, enumerations, name);
        return new UnionEnumeration<URL>(enumerations);
    }

    protected void recursiveFind(Set<ClassLoader> knownClassloaders, List<Enumeration<URL>> enumerations, String name) throws IOException {
        if (this.isDestroyed() || knownClassloaders.contains(this)) {
            return;
        }
        knownClassloaders.add(this);
        if (this.inverseClassLoading && !this.isNonOverridableResource(name)) {
            enumerations.add(this.internalfindResources(name));
        }
        if (!this.isHiddenResource(name)) {
            for (ClassLoader parent : this.parents) {
                if (parent instanceof MultiParentClassLoader) {
                    ((MultiParentClassLoader)parent).recursiveFind(knownClassloaders, enumerations, name);
                    continue;
                }
                if (knownClassloaders.contains(parent)) continue;
                enumerations.add(parent.getResources(name));
                knownClassloaders.add(parent);
            }
        }
        if (!this.inverseClassLoading) {
            enumerations.add(this.internalfindResources(name));
        }
    }

    protected Enumeration<URL> internalfindResources(String name) throws IOException {
        return super.findResources(name);
    }

    private boolean isNonOverridableResource(String name) {
        for (String nonOverridableResource : this.nonOverridableResources) {
            if (!name.startsWith(nonOverridableResource)) continue;
            return true;
        }
        return false;
    }

    private boolean isHiddenResource(String name) {
        for (String hiddenResource : this.hiddenResources) {
            if (!name.startsWith(hiddenResource)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[" + this.getClass().getName() + " id=" + this.id + "]";
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        MultiParentClassLoader multiParentClassLoader = this;
        synchronized (multiParentClassLoader) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        LogFactory.release((ClassLoader)this);
        MultiParentClassLoader.clearSoftCache(ObjectInputStream.class, "subclassAudits");
        MultiParentClassLoader.clearSoftCache(ObjectOutputStream.class, "subclassAudits");
        MultiParentClassLoader.clearSoftCache(ObjectStreamClass.class, "localDescs");
        MultiParentClassLoader.clearSoftCache(ObjectStreamClass.class, "reflectors");
        Introspector.flushCaches();
        ClassLoaderRegistry.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearSoftCache(Class clazz, String fieldName) {
        Map cache = null;
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            cache = (Map)f.get(null);
        }
        catch (Throwable e) {
            Object object = lock;
            synchronized (object) {
                if (!clearSoftCacheFailed) {
                    clearSoftCacheFailed = true;
                    LogFactory.getLog(MultiParentClassLoader.class).debug((Object)("Unable to clear SoftCache field " + fieldName + " in class " + clazz));
                }
            }
        }
        if (cache != null) {
            Map map = cache;
            synchronized (map) {
                cache.clear();
            }
        }
    }

    protected void finalize() throws Throwable {
        ClassLoaderRegistry.remove(this);
        super.finalize();
    }

    static {
        String mode = System.getProperty("Xorg.apache.geronimo.kernel.config.MPCLSearchOption");
        int runtimeMode = 2;
        String runtimeModeMessage = "Original Classloading";
        if (mode != null) {
            if (mode.equals("safe")) {
                runtimeMode = 1;
                runtimeModeMessage = "Safe ClassLoading";
            } else if (mode.equals("optimized")) {
                runtimeMode = 2;
            }
        }
        classLoaderSearchMode = runtimeMode;
        log.info((Object)("ClassLoading behaviour has changed.  The " + runtimeModeMessage + " mode is in effect.  If you are experiencing a problem\n" + "you can change the behaviour by specifying -DXorg.apache.geronimo.kernel.config.MPCLSearchOption= property.  Specify \n" + "=\"safe\" to revert to the original behaviour.  This is a temporary change until we decide whether or not to make it\n" + "permanent for the 2.0 release"));
        lock = new Object();
        clearSoftCacheFailed = false;
    }
}

