/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IOUtil {
    private static final Log log = LogFactory.getLog(IOUtil.class);

    public static void recursiveCopy(File srcDir, File destDir) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("sourceDir is null");
        }
        if (destDir == null) {
            throw new NullPointerException("destDir is null");
        }
        if (!srcDir.isDirectory() || !srcDir.canRead()) {
            throw new IllegalArgumentException("Source directory must be a readable directory " + srcDir);
        }
        if (destDir.exists()) {
            throw new IllegalArgumentException("Destination directory already exists " + destDir);
        }
        if (srcDir.equals(destDir)) {
            throw new IllegalArgumentException("Source and destination directory are the same " + srcDir);
        }
        destDir.mkdirs();
        if (!destDir.exists()) {
            throw new IOException("Could not create destination directory " + destDir);
        }
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles != null) {
            for (int i = 0; i < srcFiles.length; ++i) {
                File srcFile = srcFiles[i];
                File destFile = new File(destDir, srcFile.getName());
                if (srcFile.isDirectory()) {
                    IOUtil.recursiveCopy(srcFile, destFile);
                    continue;
                }
                IOUtil.copyFile(srcFile, destFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File destination) throws IOException {
        File destinationDir = destination.getParentFile();
        if (!destinationDir.exists() && !destinationDir.mkdirs()) {
            throw new IOException("Cannot create directory : " + destinationDir);
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            IOUtil.writeAll(in, out);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close(in);
        IOUtil.close(out);
    }

    public static void writeAll(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] buffer = new byte[4096];
        while ((count = in.read(buffer)) > 0) {
            out.write(buffer, 0, count);
        }
        out.flush();
    }

    private static void listFiles(File directory) {
        if (!log.isDebugEnabled() || !directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        log.debug((Object)(directory.getPath() + " has " + files.length + " files:"));
        for (File file : files) {
            log.debug((Object)file.getPath());
        }
    }

    private static boolean deleteFile(File file) {
        int retries;
        boolean fileDeleted = file.delete();
        if (fileDeleted) {
            return true;
        }
        int retryLimit = 5;
        int interruptions = 0;
        for (retries = 1; !fileDeleted && retries <= retryLimit; ++retries) {
            if (log.isDebugEnabled()) {
                IOUtil.listFiles(file);
            }
            System.runFinalization();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                ++interruptions;
            }
            System.gc();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                ++interruptions;
            }
            fileDeleted = file.delete();
        }
        if (fileDeleted) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(file.getPath() + " deleted after " + retries + " retries, with " + interruptions + " interruptions."));
            }
        } else {
            log.warn((Object)(file.getPath() + " not deleted after " + retryLimit + " retries, with " + interruptions + " interruptions."));
        }
        return fileDeleted;
    }

    public static boolean recursiveDelete(File root) {
        File[] files;
        if (root == null) {
            return true;
        }
        if (root.isDirectory() && (files = root.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    IOUtil.recursiveDelete(file);
                    continue;
                }
                IOUtil.deleteFile(file);
            }
        }
        return IOUtil.deleteFile(root);
    }

    public static void flush(OutputStream thing) {
        if (thing != null) {
            try {
                thing.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void flush(Writer thing) {
        if (thing != null) {
            try {
                thing.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(JarFile thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Reader thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Writer thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static Set search(File root, String pattern) throws MalformedURLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map listAllFileNames(File base) {
        return IOUtil.listAllFileNames(base, "");
    }

    private static Map listAllFileNames(File base, String prefix) {
        if (!base.canRead() || !base.isDirectory()) {
            throw new IllegalArgumentException(base.getAbsolutePath());
        }
        LinkedHashMap<String, File> map = new LinkedHashMap<String, File>();
        File[] hits = base.listFiles();
        for (int i = 0; i < hits.length; ++i) {
            File hit = hits[i];
            if (!hit.canRead()) continue;
            if (hit.isDirectory()) {
                map.putAll(IOUtil.listAllFileNames(hit, prefix.equals("") ? hit.getName() : prefix + "/" + hit.getName()));
                continue;
            }
            map.put(prefix.equals("") ? hit.getName() : prefix + "/" + hit.getName(), hit);
        }
        map.put(prefix, base);
        return map;
    }
}

