/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.kernel.util.ClassLoaderRegistry;

public class ConfigurationClassLoader
extends URLClassLoader {
    private final URI id;
    private static Object lock = new Object();
    private static boolean clearSoftCacheFailed = false;

    public ConfigurationClassLoader(URI id, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        ClassLoaderRegistry.add(this);
        this.id = id;
    }

    public URI getID() {
        return this.id;
    }

    public void destroy() {
        LogFactory.release((ClassLoader)this);
        ConfigurationClassLoader.clearSoftCache(ObjectInputStream.class, "subclassAudits");
        ConfigurationClassLoader.clearSoftCache(ObjectOutputStream.class, "subclassAudits");
        ConfigurationClassLoader.clearSoftCache(ObjectStreamClass.class, "localDescs");
        ConfigurationClassLoader.clearSoftCache(ObjectStreamClass.class, "reflectors");
        ClassLoaderRegistry.remove(this);
    }

    public String toString() {
        return "[Configuration ClassLoader id=" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearSoftCache(Class clazz, String fieldName) {
        Map cache = null;
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            cache = (Map)f.get(null);
        }
        catch (Throwable e) {
            Object object = lock;
            synchronized (object) {
                if (!clearSoftCacheFailed) {
                    clearSoftCacheFailed = true;
                    LogFactory.getLog(ConfigurationClassLoader.class).debug((Object)("Unable to clear SoftCache field " + fieldName + " in class " + clazz));
                }
            }
        }
        if (cache != null) {
            Map map = cache;
            synchronized (map) {
                cache.clear();
            }
        }
    }

    protected void finalize() {
        ClassLoaderRegistry.remove(this);
    }
}

