/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.classloader.JarFileClassLoader;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationParent;
import org.apache.geronimo.kernel.config.ConfigurationResolver;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.MultiParentClassLoader;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.kernel.repository.MissingDependencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements GBeanLifecycle,
ConfigurationParent {
    private static final Log log = LogFactory.getLog(Configuration.class);
    private final Artifact id;
    private final AbstractName abstractName;
    private final Environment environment;
    private final ConfigurationResolver configurationResolver;
    private final List<Configuration> classParents = new ArrayList<Configuration>();
    private final List<Configuration> serviceParents = new ArrayList<Configuration>();
    private final List<Configuration> allServiceParents = new ArrayList<Configuration>();
    private final LinkedHashSet<Artifact> dependencies = new LinkedHashSet();
    private final Map<AbstractName, GBeanData> gbeans = new LinkedHashMap<AbstractName, GBeanData>();
    private final MultiParentClassLoader configurationClassLoader;
    private final LinkedHashSet<String> classPath;
    private final Naming naming;
    private ConfigurationData configurationData;
    List<Configuration> children = new ArrayList<Configuration>();
    private Configuration parent = null;
    public static final GBeanInfo GBEAN_INFO;

    public static AbstractName getConfigurationAbstractName(Artifact configId) throws InvalidConfigException {
        return new AbstractName(configId, Collections.singletonMap("configurationName", configId.toString()), Configuration.getConfigurationObjectName(configId));
    }

    public static boolean isConfigurationObjectName(ObjectName name) {
        return name.getDomain().equals("geronimo.config") && name.getKeyPropertyList().size() == 1 && name.getKeyProperty("name") != null;
    }

    public static Artifact getConfigurationID(ObjectName objectName) {
        if (Configuration.isConfigurationObjectName(objectName)) {
            String name = ObjectName.unquote(objectName.getKeyProperty("name"));
            return Artifact.create(name);
        }
        throw new IllegalArgumentException("ObjectName " + objectName + " is not a Configuration name");
    }

    private static ObjectName getConfigurationObjectName(Artifact configId) throws InvalidConfigException {
        try {
            return new ObjectName("geronimo.config:name=" + ObjectName.quote(configId.toString()));
        }
        catch (MalformedObjectNameException e) {
            throw new InvalidConfigException("Could not construct object name for configuration", e);
        }
    }

    public Configuration() {
        this.id = null;
        this.abstractName = null;
        this.environment = null;
        this.classPath = null;
        this.configurationResolver = null;
        this.configurationClassLoader = null;
        this.naming = null;
    }

    public Configuration(Collection<Configuration> parents, ConfigurationData configurationData, ConfigurationResolver configurationResolver, ManageableAttributeStore attributeStore) throws MissingDependencyException, MalformedURLException, NoSuchConfigException, InvalidConfigException {
        if (parents == null) {
            parents = Collections.EMPTY_SET;
        }
        if (configurationData == null) {
            throw new NullPointerException("configurationData is null");
        }
        if (configurationResolver == null) {
            throw new NullPointerException("configurationResolver is null");
        }
        this.configurationData = configurationData;
        this.environment = configurationData.getEnvironment();
        this.configurationResolver = configurationResolver;
        this.classPath = new LinkedHashSet(configurationData.getClassPath());
        this.naming = configurationData.getNaming();
        this.id = this.environment.getConfigId();
        this.abstractName = Configuration.getConfigurationAbstractName(this.id);
        List transitiveDependencies = configurationResolver.resolveTransitiveDependencies(parents, this.environment.getDependencies());
        HashMap<Artifact, Configuration> parentsById = new HashMap<Artifact, Configuration>();
        for (Configuration configuration : parents) {
            Artifact id = configuration.getId();
            parentsById.put(id, configuration);
        }
        for (Dependency dependency : transitiveDependencies) {
            Artifact artifact = dependency.getArtifact();
            if (parentsById.containsKey(artifact)) {
                Configuration parent = (Configuration)parentsById.get(artifact);
                if (dependency.getImportType() == ImportType.CLASSES || dependency.getImportType() == ImportType.ALL) {
                    this.classParents.add(parent);
                }
                if (dependency.getImportType() != ImportType.SERVICES && dependency.getImportType() != ImportType.ALL) continue;
                this.serviceParents.add(parent);
                continue;
            }
            if (dependency.getImportType() == ImportType.SERVICES) {
                throw new IllegalStateException("Could not find parent " + artifact + " in the parents collection");
            }
            this.dependencies.add(artifact);
        }
        try {
            this.configurationClassLoader = this.createConfigurationClasssLoader(parents, this.environment, this.classPath);
            this.addDepthFirstServiceParents(this, this.allServiceParents, new HashSet<Artifact>());
            Collection gbeans = configurationData.getGBeans(this.configurationClassLoader);
            if (attributeStore != null) {
                gbeans = attributeStore.applyOverrides(this.id, gbeans, this.configurationClassLoader);
            }
            for (GBeanData gbeanData : gbeans) {
                this.gbeans.put(gbeanData.getAbstractName(), gbeanData);
            }
            LinkedHashSet<Configuration> childParents = new LinkedHashSet<Configuration>(parents);
            childParents.add(this);
            for (Map.Entry entry : configurationData.getChildConfigurations().entrySet()) {
                String moduleName = (String)entry.getKey();
                ConfigurationData childConfigurationData = (ConfigurationData)entry.getValue();
                Configuration childConfiguration = new Configuration(childParents, childConfigurationData, configurationResolver.createChildResolver(moduleName), attributeStore);
                childConfiguration.parent = this;
                this.children.add(childConfiguration);
            }
        }
        catch (RuntimeException e) {
            this.shutdown();
            throw e;
        }
        catch (Error e) {
            this.shutdown();
            throw e;
        }
        catch (MissingDependencyException e) {
            this.shutdown();
            throw e;
        }
        catch (MalformedURLException e) {
            this.shutdown();
            throw e;
        }
        catch (NoSuchConfigException e) {
            this.shutdown();
            throw e;
        }
        catch (InvalidConfigException e) {
            this.shutdown();
            throw e;
        }
    }

    private MultiParentClassLoader createConfigurationClasssLoader(Collection<Configuration> parents, Environment environment, LinkedHashSet<String> classPath) throws MalformedURLException, MissingDependencyException, NoSuchConfigException {
        ClassLoader[] parentClassLoaders;
        URL[] urls = this.buildClassPath(classPath);
        if (parents.size() == 0 && this.classParents.size() == 0) {
            parentClassLoaders = new ClassLoader[]{this.getClass().getClassLoader()};
        } else {
            parentClassLoaders = new ClassLoader[this.classParents.size()];
            ListIterator<Configuration> iterator = this.classParents.listIterator();
            while (iterator.hasNext()) {
                Configuration configuration = iterator.next();
                parentClassLoaders[iterator.previousIndex()] = configuration.getConfigurationClassLoader();
            }
        }
        Set hiddenClassesSet = environment.getHiddenClasses();
        String[] hiddenClasses = hiddenClassesSet.toArray(new String[hiddenClassesSet.size()]);
        LinkedHashSet nonOverridableSet = new LinkedHashSet();
        for (Configuration parent : this.classParents) {
            Environment parentEnvironment = parent.getEnvironment();
            nonOverridableSet.addAll(parentEnvironment.getNonOverrideableClasses());
        }
        String[] nonOverridableClasses = nonOverridableSet.toArray(new String[nonOverridableSet.size()]);
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer("ClassLoader structure for configuration ").append(this.id).append("\n");
            buf.append("Parent configurations:\n");
            for (Configuration configuration : this.classParents) {
                buf.append("     ").append(configuration.getId()).append("\n");
            }
            buf.append("ClassPath:\n");
            for (URL url : urls) {
                buf.append("     ").append(url).append("\n");
            }
            log.debug((Object)buf.toString());
        }
        boolean useJarFileClassLoader = false;
        useJarFileClassLoader = System.getProperty("Xorg.apache.geronimo.JarFileClassLoader") == null ? System.getProperty("os.name").startsWith("Windows") : Boolean.getBoolean("Xorg.apache.geronimo.JarFileClassLoader");
        if (useJarFileClassLoader) {
            return new JarFileClassLoader(environment.getConfigId(), urls, parentClassLoaders, environment.isInverseClassLoading(), hiddenClasses, nonOverridableClasses);
        }
        return new MultiParentClassLoader(environment.getConfigId(), urls, parentClassLoaders, environment.isInverseClassLoading(), hiddenClasses, nonOverridableClasses);
    }

    private void addDepthFirstServiceParents(Configuration configuration, List<Configuration> ancestors, Set<Artifact> ids) {
        if (!ids.contains(configuration.getId())) {
            ancestors.add(configuration);
            ids.add(configuration.getId());
            for (Configuration parent : configuration.getServiceParents()) {
                this.addDepthFirstServiceParents(parent, ancestors, ids);
            }
        }
    }

    private URL[] buildClassPath(LinkedHashSet<String> classPath) throws MalformedURLException, MissingDependencyException, NoSuchConfigException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : this.dependencies) {
            File file = this.configurationResolver.resolve(artifact);
            urls.add(file.toURL());
        }
        if (classPath != null) {
            for (String pattern : classPath) {
                Set matches = this.configurationResolver.resolve(pattern);
                for (URL url : matches) {
                    urls.add(url);
                }
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public Artifact getId() {
        return this.id;
    }

    public String getObjectName() {
        try {
            return Configuration.getConfigurationObjectName(this.id).getCanonicalName();
        }
        catch (InvalidConfigException e) {
            throw new AssertionError((Object)e);
        }
    }

    public AbstractName getAbstractName() {
        return this.abstractName;
    }

    public List<Configuration> getClassParents() {
        return this.classParents;
    }

    public List<Configuration> getServiceParents() {
        return this.serviceParents;
    }

    public LinkedHashSet<Artifact> getDependencies() {
        return this.dependencies;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    ConfigurationData getConfigurationData() {
        return this.configurationData;
    }

    public File getConfigurationDir() {
        return this.configurationData.getConfigurationDir();
    }

    public ConfigurationResolver getConfigurationResolver() {
        return this.configurationResolver;
    }

    public List<String> getClassPath() {
        return new ArrayList<String>(this.classPath);
    }

    public void addToClassPath(String pattern) throws IOException {
        if (!this.classPath.contains(pattern)) {
            try {
                Set matches = this.configurationResolver.resolve(pattern);
                for (URL url : matches) {
                    this.configurationClassLoader.addURL(url);
                }
                this.classPath.add(pattern);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to extend classpath with " + pattern).initCause(e);
            }
        }
    }

    public ConfigurationModuleType getModuleType() {
        return this.configurationData.getModuleType();
    }

    public long getCreated() {
        return this.configurationData.getCreated();
    }

    @Override
    public ClassLoader getConfigurationClassLoader() {
        return this.configurationClassLoader;
    }

    public List<Configuration> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Set<Configuration> getOwnedConfigurations() {
        return this.configurationData.getOwnedConfigurations();
    }

    public Map<AbstractName, GBeanData> getGBeans() {
        return Collections.unmodifiableMap(this.gbeans);
    }

    public synchronized boolean containsGBean(AbstractName gbean) {
        return this.gbeans.containsKey(gbean);
    }

    public Configuration getEnclosingConfiguration() {
        return this.parent;
    }

    public synchronized AbstractName addGBean(String name, GBeanData gbean) throws GBeanAlreadyExistsException {
        AbstractName abstractName = gbean.getAbstractName();
        if (abstractName != null) {
            throw new IllegalArgumentException("gbean already has an abstract name: " + abstractName);
        }
        String j2eeType = gbean.getGBeanInfo().getJ2eeType();
        if (j2eeType == null) {
            j2eeType = "GBean";
        }
        abstractName = this.naming.createRootName(this.id, name, j2eeType);
        gbean.setAbstractName(abstractName);
        if (this.gbeans.containsKey(abstractName)) {
            throw new GBeanAlreadyExistsException(gbean.getAbstractName().toString());
        }
        this.gbeans.put(abstractName, gbean);
        return abstractName;
    }

    public synchronized void addGBean(GBeanData gbean) throws GBeanAlreadyExistsException {
        if (this.gbeans.containsKey(gbean.getAbstractName())) {
            throw new GBeanAlreadyExistsException(gbean.getAbstractName().toString());
        }
        this.gbeans.put(gbean.getAbstractName(), gbean);
    }

    public synchronized void removeGBean(AbstractName name) throws GBeanNotFoundException {
        if (!this.gbeans.containsKey(name)) {
            throw new GBeanNotFoundException(name);
        }
        this.gbeans.remove(name);
    }

    public AbstractName findGBean(AbstractNameQuery pattern) throws GBeanNotFoundException {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        return this.findGBean(Collections.singleton(pattern));
    }

    public GBeanData findGBeanData(AbstractNameQuery pattern) throws GBeanNotFoundException {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        return this.findGBeanData(Collections.singleton(pattern));
    }

    public AbstractName findGBean(ReferencePatterns referencePatterns) throws GBeanNotFoundException {
        if (referencePatterns == null) {
            throw new NullPointerException("referencePatterns is null");
        }
        if (referencePatterns.isResolved()) {
            return referencePatterns.getAbstractName();
        }
        Set<AbstractNameQuery> patterns = referencePatterns.getPatterns();
        return this.findGBean(patterns);
    }

    public AbstractName findGBean(Set<AbstractNameQuery> patterns) throws GBeanNotFoundException {
        if (patterns == null) {
            throw new NullPointerException("patterns is null");
        }
        return this.findGBeanData(patterns).getAbstractName();
    }

    public GBeanData findGBeanData(Set<AbstractNameQuery> patterns) throws GBeanNotFoundException {
        if (patterns == null) {
            throw new NullPointerException("patterns is null");
        }
        LinkedHashSet<GBeanData> result = this.findGBeanDatas(this, patterns);
        if (result.size() > 1) {
            throw new GBeanNotFoundException("More than one match to referencePatterns in local configuration", patterns, this.mapToNames(result));
        }
        if (result.size() == 1) {
            return (GBeanData)result.iterator().next();
        }
        for (Configuration configuration : this.allServiceParents) {
            result.addAll(this.findGBeanDatas(configuration, patterns));
        }
        if (result.size() > 1) {
            ArrayList<AbstractName> names = new ArrayList<AbstractName>(result.size());
            for (GBeanData gBeanData : result) {
                names.add(gBeanData.getAbstractName());
            }
            throw new GBeanNotFoundException("More than one match to referencePatterns in parent configurations: " + ((Object)names).toString(), patterns, this.mapToNames(result));
        }
        if (result.isEmpty()) {
            throw new GBeanNotFoundException("No matches for referencePatterns", patterns, null);
        }
        return (GBeanData)result.iterator().next();
    }

    private Set<AbstractName> mapToNames(Set<GBeanData> datas) {
        HashSet<AbstractName> names = new HashSet<AbstractName>(datas.size());
        for (GBeanData gBeanData : datas) {
            names.add(gBeanData.getAbstractName());
        }
        return names;
    }

    public LinkedHashSet<AbstractName> findGBeans(AbstractNameQuery pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        return this.findGBeans(Collections.singleton(pattern));
    }

    public LinkedHashSet<AbstractName> findGBeans(ReferencePatterns referencePatterns) {
        if (referencePatterns == null) {
            throw new NullPointerException("referencePatterns is null");
        }
        if (referencePatterns.getAbstractName() != null) {
            LinkedHashSet<AbstractName> result = new LinkedHashSet<AbstractName>();
            result.add(referencePatterns.getAbstractName());
            return result;
        }
        Set<AbstractNameQuery> patterns = referencePatterns.getPatterns();
        return this.findGBeans(patterns);
    }

    public LinkedHashSet<AbstractName> findGBeans(Set<AbstractNameQuery> patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns is null");
        }
        LinkedHashSet<GBeanData> datas = this.findGBeanDatas(patterns);
        LinkedHashSet<AbstractName> result = new LinkedHashSet<AbstractName>(datas.size());
        for (GBeanData gBeanData : datas) {
            result.add(gBeanData.getAbstractName());
        }
        return result;
    }

    public LinkedHashSet<GBeanData> findGBeanDatas(Set<AbstractNameQuery> patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns is null");
        }
        LinkedHashSet<GBeanData> datas = this.findGBeanDatas(this, patterns);
        for (Configuration configuration : this.allServiceParents) {
            LinkedHashSet<GBeanData> match = this.findGBeanDatas(configuration, patterns);
            datas.addAll(match);
        }
        return datas;
    }

    public LinkedHashSet<GBeanData> findGBeanDatas(Configuration configuration, Set<AbstractNameQuery> patterns) {
        LinkedHashSet<GBeanData> result = new LinkedHashSet<GBeanData>();
        Set<Map.Entry<AbstractName, GBeanData>> gbeanNames = configuration.getGBeans().entrySet();
        for (AbstractNameQuery abstractNameQuery : patterns) {
            Artifact queryArtifact = abstractNameQuery.getArtifact();
            if (queryArtifact != null && !queryArtifact.matches(configuration.getId())) continue;
            for (Map.Entry<AbstractName, GBeanData> entry : gbeanNames) {
                GBeanData gbeanData;
                AbstractName abstractName = entry.getKey();
                if (!abstractNameQuery.matches(abstractName, (gbeanData = entry.getValue()).getGBeanInfo().getInterfaces())) continue;
                result.add(gbeanData);
            }
        }
        return result;
    }

    @Override
    public void doStart() throws Exception {
        log.debug((Object)("Started configuration " + this.id));
    }

    @Override
    public synchronized void doStop() throws Exception {
        log.debug((Object)("Stopping configuration " + this.id));
        this.shutdown();
    }

    @Override
    public void doFail() {
        log.debug((Object)("Failed configuration " + this.id));
        this.shutdown();
    }

    private void shutdown() {
        for (Configuration configuration : this.children) {
            configuration.shutdown();
        }
        this.gbeans.clear();
        if (this.configurationClassLoader != null) {
            this.configurationClassLoader.destroy();
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(Configuration.class);
        infoFactory.addReference("Parents", Configuration.class);
        infoFactory.addAttribute("configurationData", ConfigurationData.class, true, false);
        infoFactory.addAttribute("configurationResolver", ConfigurationResolver.class, true);
        infoFactory.addAttribute("managedAttributeStore", ManageableAttributeStore.class, true);
        infoFactory.addInterface(Configuration.class);
        infoFactory.setConstructor(new String[]{"Parents", "configurationData", "configurationResolver", "managedAttributeStore"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

