/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.LifecycleBroadcaster;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Jsr77Naming;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelGBean;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.basic.BasicDependencyManager;
import org.apache.geronimo.kernel.basic.BasicLifecycleMonitor;
import org.apache.geronimo.kernel.basic.BasicProxyManager;
import org.apache.geronimo.kernel.basic.BasicRegistry;
import org.apache.geronimo.kernel.basic.LifecycleMonitorFlyweight;
import org.apache.geronimo.kernel.lifecycle.LifecycleMonitor;
import org.apache.geronimo.kernel.proxy.ProxyManager;

public class BasicKernel
implements Kernel {
    private static final String[] NO_TYPES = new String[0];
    private static final Object[] NO_ARGS = new Object[0];
    private final String kernelName;
    private Log log;
    private boolean running;
    private Date bootTime;
    private final BasicRegistry registry;
    private final LinkedList shutdownHooks = new LinkedList();
    private DependencyManager dependencyManager;
    private BasicLifecycleMonitor lifecycleMonitor;
    private LifecycleMonitor publicLifecycleMonitor;
    private ProxyManager proxyManager;
    private static final Naming INSTANCE = new Jsr77Naming();

    public BasicKernel(String kernelName) {
        if (kernelName.indexOf(58) >= 0 || kernelName.indexOf(42) >= 0 || kernelName.indexOf(63) >= 0) {
            throw new IllegalArgumentException("Kernel name may not contain a ':', '*' or '?' character");
        }
        this.kernelName = kernelName;
        this.registry = new BasicRegistry();
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public Naming getNaming() {
        return INSTANCE;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public LifecycleMonitor getLifecycleMonitor() {
        return this.publicLifecycleMonitor;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public Object getAttribute(ObjectName objectName, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(objectName);
        return gbeanInstance.getAttribute(attributeName);
    }

    public Object getAttribute(AbstractName abstractName, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(abstractName);
        return gbeanInstance.getAttribute(attributeName);
    }

    public Object getAttribute(String shortName, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        return this.getAttribute(shortName, null, attributeName);
    }

    public Object getAttribute(Class type, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        return this.getAttribute(null, type, attributeName);
    }

    public Object getAttribute(String shortName, Class type, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getAttribute(attributeName);
    }

    public void setAttribute(AbstractName abstractName, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(abstractName);
        gbeanInstance.setAttribute(attributeName, attributeValue);
    }

    public void setAttribute(String shortName, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        this.setAttribute(shortName, null, attributeName, attributeValue);
    }

    public void setAttribute(Class type, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        this.setAttribute(null, type, attributeName, attributeValue);
    }

    public void setAttribute(String shortName, Class type, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        gbeanInstance.setAttribute(attributeName, attributeValue);
    }

    public Object invoke(ObjectName objectName, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(objectName, methodName, NO_ARGS, NO_TYPES);
    }

    public Object invoke(AbstractName abstractName, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(abstractName, methodName, NO_ARGS, NO_TYPES);
    }

    public Object invoke(String shortName, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(shortName, null, methodName, NO_ARGS, NO_TYPES);
    }

    public Object invoke(Class type, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(null, type, methodName, NO_ARGS, NO_TYPES);
    }

    public Object invoke(String shortName, Class type, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(shortName, type, methodName, NO_ARGS, NO_TYPES);
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(objectName);
        return gbeanInstance.invoke(methodName, args, types);
    }

    public Object invoke(AbstractName abstractName, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(abstractName);
        return gbeanInstance.invoke(methodName, args, types);
    }

    public Object invoke(String shortName, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(shortName, null, methodName, args, types);
    }

    public Object invoke(Class type, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(null, type, methodName, args, types);
    }

    public Object invoke(String shortName, Class type, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.invoke(methodName, args, types);
    }

    public boolean isLoaded(AbstractName name) {
        return this.registry.isRegistered(name);
    }

    public boolean isLoaded(String shortName) {
        return this.isLoaded(shortName, null);
    }

    public boolean isLoaded(Class type) {
        return this.isLoaded(null, type);
    }

    public boolean isLoaded(String shortName, Class type) {
        try {
            this.registry.getGBeanInstance(shortName, type);
            return true;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
    }

    public Object getGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        return this.getGBean(shortName, null);
    }

    public Object getGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        return this.getGBean(null, type);
    }

    public Object getGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        if (gbeanInstance.getState() != 1) {
            throw new IllegalStateException("GBean is not running: " + gbeanInstance.getAbstractName());
        }
        return gbeanInstance.getTarget();
    }

    public Object getGBean(ObjectName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        if (gbeanInstance.getState() != 1) {
            throw new IllegalStateException("GBean is not running: " + name);
        }
        return gbeanInstance.getTarget();
    }

    public Object getGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        if (gbeanInstance.getState() != 1) {
            throw new IllegalStateException("GBean is not running: " + name);
        }
        return gbeanInstance.getTarget();
    }

    public GBeanInfo getGBeanInfo(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getGBeanInfo();
    }

    public GBeanInfo getGBeanInfo(AbstractName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getGBeanInfo();
    }

    public GBeanInfo getGBeanInfo(String shortName) throws GBeanNotFoundException {
        return this.getGBeanInfo(shortName, null);
    }

    public GBeanInfo getGBeanInfo(Class type) throws GBeanNotFoundException {
        return this.getGBeanInfo(null, type);
    }

    public GBeanInfo getGBeanInfo(String shortName, Class type) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getGBeanInfo();
    }

    public GBeanData getGBeanData(AbstractName name) throws GBeanNotFoundException, InternalKernelException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getGBeanData();
    }

    public GBeanData getGBeanData(String shortName) throws GBeanNotFoundException, InternalKernelException {
        return this.getGBeanData(shortName, null);
    }

    public GBeanData getGBeanData(Class type) throws GBeanNotFoundException, InternalKernelException {
        return this.getGBeanData(null, type);
    }

    public GBeanData getGBeanData(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getGBeanData();
    }

    public void loadGBean(GBeanData gbeanData, ClassLoader classLoader) throws GBeanAlreadyExistsException, InternalKernelException {
        AbstractName abstractName = gbeanData.getAbstractName();
        Set interfaces = gbeanData.getGBeanInfo().getInterfaces();
        LifecycleBroadcaster lifecycleBroadcaster = this.lifecycleMonitor.createLifecycleBroadcaster(abstractName, interfaces);
        GBeanInstance gbeanInstance = new GBeanInstance(gbeanData, this, this.dependencyManager, lifecycleBroadcaster, classLoader);
        this.registry.register(gbeanInstance);
        lifecycleBroadcaster.fireLoadedEvent();
    }

    public void startGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.start();
    }

    public void startGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.startGBean(shortName, null);
    }

    public void startGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.startGBean(null, type);
    }

    public void startGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        gbeanInstance.start();
    }

    public void startRecursiveGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.startRecursive();
    }

    public void startRecursiveGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.startRecursiveGBean(shortName, null);
    }

    public void startRecursiveGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.startRecursiveGBean(null, type);
    }

    public void startRecursiveGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        gbeanInstance.startRecursive();
    }

    public boolean isRunning(AbstractName name) {
        try {
            GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
            return gbeanInstance.getState() == 1;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
    }

    public boolean isRunning(String shortName) {
        return this.isRunning(shortName, null);
    }

    public boolean isRunning(Class type) {
        return this.isRunning(null, type);
    }

    public boolean isRunning(String shortName, Class type) {
        try {
            GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
            return gbeanInstance.getState() == 1;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
    }

    public void stopGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.stop();
    }

    public void stopGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.stopGBean(shortName, null);
    }

    public void stopGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.stopGBean(null, type);
    }

    public void stopGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        gbeanInstance.stop();
    }

    public void unloadGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.die();
        this.registry.unregister(name);
    }

    public void unloadGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.unloadGBean(shortName, null);
    }

    public void unloadGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.unloadGBean(null, type);
    }

    public void unloadGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        AbstractName name = gbeanInstance.getAbstractName();
        gbeanInstance.die();
        this.registry.unregister(name);
    }

    public int getGBeanState(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getState();
    }

    public int getGBeanState(AbstractName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getState();
    }

    public int getGBeanState(String shortName) throws GBeanNotFoundException {
        return this.getGBeanState(shortName, null);
    }

    public int getGBeanState(Class type) throws GBeanNotFoundException {
        return this.getGBeanState(null, type);
    }

    public int getGBeanState(String shortName, Class type) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getState();
    }

    public long getGBeanStartTime(AbstractName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getStartTime();
    }

    public long getGBeanStartTime(String shortName) throws GBeanNotFoundException {
        return this.getGBeanStartTime(shortName, null);
    }

    public long getGBeanStartTime(Class type) throws GBeanNotFoundException {
        return this.getGBeanStartTime(null, type);
    }

    public long getGBeanStartTime(String shortName, Class type) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getStartTime();
    }

    public Set listGBeans(ObjectName pattern) {
        Set gbeans = this.registry.listGBeans(pattern);
        HashSet<ObjectName> result = new HashSet<ObjectName>(gbeans.size());
        for (GBeanInstance instance : gbeans) {
            result.add(instance.getObjectNameObject());
        }
        return result;
    }

    public Set listGBeans(Set patterns) {
        HashSet gbeans = new HashSet();
        for (Object pattern : patterns) {
            if (pattern instanceof ObjectName) {
                gbeans.addAll(this.listGBeans((ObjectName)pattern));
                continue;
            }
            if (!(pattern instanceof AbstractNameQuery)) continue;
            gbeans.addAll(this.listGBeans((AbstractNameQuery)pattern));
        }
        return gbeans;
    }

    public Set listGBeans(AbstractNameQuery query) {
        Set gbeans = this.registry.listGBeans(query);
        HashSet<AbstractName> result = new HashSet<AbstractName>(gbeans.size());
        for (GBeanInstance instance : gbeans) {
            result.add(instance.getAbstractName());
        }
        return result;
    }

    public Set listGBeansByInterface(String[] interfaces) {
        HashSet<AbstractName> gbeans = new HashSet<AbstractName>();
        Set all = this.listGBeans((AbstractNameQuery)null);
        block2: for (AbstractName name : all) {
            try {
                GBeanInfo info = this.getGBeanInfo(name);
                Set intfs = info.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    String candidate = interfaces[i];
                    if (!intfs.contains(candidate)) continue;
                    gbeans.add(name);
                    continue block2;
                }
            }
            catch (GBeanNotFoundException e) {
            }
        }
        return gbeans;
    }

    public AbstractName getAbstractNameFor(Object service) {
        if (!this.running) {
            return null;
        }
        AbstractName name = this.proxyManager.getProxyTarget(service);
        if (name != null) {
            return name;
        }
        GBeanInstance gbeanInstance = this.registry.getGBeanInstanceByInstance(service);
        if (gbeanInstance != null) {
            return gbeanInstance.getAbstractName();
        }
        return null;
    }

    public String getShortNameFor(Object service) {
        AbstractName name = this.getAbstractNameFor(service);
        if (name != null) {
            return (String)name.getName().get("name");
        }
        return null;
    }

    public void boot() throws Exception {
        if (this.running) {
            return;
        }
        this.bootTime = new Date();
        this.log = LogFactory.getLog((String)BasicKernel.class.getName());
        this.log.debug((Object)"Starting boot");
        KernelRegistry.registerKernel(this);
        this.registry.start(this);
        this.lifecycleMonitor = new BasicLifecycleMonitor(this);
        this.publicLifecycleMonitor = new LifecycleMonitorFlyweight(this.lifecycleMonitor);
        this.dependencyManager = new BasicDependencyManager(this.publicLifecycleMonitor);
        this.proxyManager = new BasicProxyManager(this);
        GBeanData kernelGBeanData = new GBeanData(KERNEL_NAME, KernelGBean.GBEAN_INFO);
        this.loadGBean(kernelGBeanData, this.getClass().getClassLoader());
        this.startGBean(KERNEL_NAME);
        this.running = true;
        this.log.debug((Object)"Booted");
    }

    public Date getBootTime() {
        return this.bootTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShutdownHook(Runnable hook) {
        assert (hook != null) : "Shutdown hook was null";
        LinkedList linkedList = this.shutdownHooks;
        synchronized (linkedList) {
            this.shutdownHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterShutdownHook(Runnable hook) {
        LinkedList linkedList = this.shutdownHooks;
        synchronized (linkedList) {
            this.shutdownHooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.log.debug((Object)"Starting kernel shutdown");
        this.notifyShutdownHooks();
        this.registry.stop();
        this.dependencyManager.close();
        this.dependencyManager = null;
        BasicKernel basicKernel = this;
        synchronized (basicKernel) {
            this.notify();
        }
        KernelRegistry.unregisterKernel(this);
        this.log.debug((Object)"Kernel shutdown complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShutdownHooks() {
        while (!this.shutdownHooks.isEmpty()) {
            Runnable hook;
            LinkedList linkedList = this.shutdownHooks;
            synchronized (linkedList) {
                hook = (Runnable)this.shutdownHooks.removeFirst();
            }
            try {
                hook.run();
            }
            catch (Throwable e) {
                this.log.warn((Object)"Error from kernel shutdown hook", e);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public ClassLoader getClassLoaderFor(AbstractName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getClassLoader();
    }

    public ClassLoader getClassLoaderFor(String shortName) throws GBeanNotFoundException {
        return this.getClassLoaderFor(shortName, null);
    }

    public ClassLoader getClassLoaderFor(Class type) throws GBeanNotFoundException {
        return this.getClassLoaderFor(null, type);
    }

    public ClassLoader getClassLoaderFor(String shortName, Class type) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getClassLoader();
    }

    public String getStateReason(AbstractName abstractName) {
        try {
            GBeanInstance gbeanInstance = this.registry.getGBeanInstance(abstractName);
            return gbeanInstance.getStateReason();
        }
        catch (GBeanNotFoundException e) {
            return null;
        }
    }
}

