/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.IOUtil;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationResolver {
    private final Artifact configurationId;
    private final ArtifactResolver artifactResolver;
    private final Collection repositories;
    private final File baseDir;
    private final ConfigurationStore configurationStore;
    private final String moduleName;

    public ConfigurationResolver(Artifact configurationId, File baseDir) {
        if (configurationId == null) {
            throw new NullPointerException("configurationId is null");
        }
        this.configurationId = configurationId;
        this.baseDir = baseDir;
        this.artifactResolver = null;
        this.repositories = Collections.EMPTY_SET;
        this.configurationStore = null;
        this.moduleName = null;
    }

    public ConfigurationResolver(ConfigurationData configurationData, Collection repositories, ArtifactResolver artifactResolver) {
        if (configurationData == null) {
            throw new NullPointerException("configurationData is null");
        }
        if (repositories == null) {
            repositories = Collections.EMPTY_SET;
        }
        this.configurationId = configurationData.getId();
        this.artifactResolver = artifactResolver;
        this.repositories = repositories;
        this.configurationStore = configurationData.getConfigurationStore();
        this.baseDir = null != configurationData.getInPlaceConfigurationDir() ? configurationData.getInPlaceConfigurationDir() : configurationData.getConfigurationDir();
        this.moduleName = null;
    }

    private ConfigurationResolver(Artifact configurationId, ArtifactResolver artifactResolver, Collection repositories, File baseDir, ConfigurationStore configurationStore, String moduleName) {
        this.configurationId = configurationId;
        this.artifactResolver = artifactResolver;
        this.repositories = repositories;
        this.baseDir = baseDir;
        this.configurationStore = configurationStore;
        this.moduleName = moduleName;
    }

    public ConfigurationResolver createChildResolver(String moduleName) {
        if (moduleName == null) {
            throw new NullPointerException("moduleName is null");
        }
        if (this.moduleName != null) {
            moduleName = this.moduleName + '/' + moduleName;
        }
        File childBaseDir = null;
        if (this.baseDir != null) {
            childBaseDir = new File(this.baseDir, moduleName);
        }
        return new ConfigurationResolver(this.configurationId, this.artifactResolver, this.repositories, childBaseDir, this.configurationStore, moduleName);
    }

    public File resolve(Artifact artifact) throws MissingDependencyException {
        for (Repository repository : this.repositories) {
            if (!repository.contains(artifact)) continue;
            File file = repository.getLocation(artifact);
            return file;
        }
        throw new MissingDependencyException("Unable to resolve dependency " + artifact);
    }

    public Set resolve(String pattern) throws MalformedURLException, NoSuchConfigException {
        if (this.configurationStore != null) {
            Set matches = this.configurationStore.resolve(this.configurationId, this.moduleName, pattern);
            return matches;
        }
        if (this.baseDir != null) {
            Set matches = IOUtil.search(this.baseDir, pattern);
            return matches;
        }
        throw new IllegalStateException("No configurationStore or baseDir supplied so paths can not be resolved");
    }

    public List resolveTransitiveDependencies(Collection parents, List dependencies) throws MissingDependencyException {
        Stack parentStack = new Stack();
        return this.internalResolveTransitiveDependencies(parents, dependencies, parentStack);
    }

    private List internalResolveTransitiveDependencies(Collection parents, List dependencies, Stack parentStack) throws MissingDependencyException {
        ArrayList<Dependency> resolvedDependencies = new ArrayList<Dependency>();
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = this.resolveDependency(parents, (Dependency)iterator.next(), parentStack);
            if (resolvedDependencies.contains(dependency)) continue;
            resolvedDependencies.add(dependency);
            List childDependencies = this.getChildDependencies(dependency);
            if (childDependencies.isEmpty()) continue;
            parentStack.push(dependency);
            childDependencies = this.internalResolveTransitiveDependencies(parents, childDependencies, parentStack);
            parentStack.pop();
            resolvedDependencies.addAll(childDependencies);
        }
        return resolvedDependencies;
    }

    private Dependency resolveDependency(Collection parents, Dependency dependency, Stack<Dependency> parentStack) throws MissingDependencyException {
        Artifact artifact = dependency.getArtifact();
        if (artifact.isResolved()) {
            return dependency;
        }
        if (this.artifactResolver == null) {
            throw new MissingDependencyException("Artifact is not resolved and there no artifact resolver available: " + artifact);
        }
        try {
            artifact = this.artifactResolver.resolveInClassLoader(artifact, parents);
        }
        catch (MissingDependencyException e) {
            StringBuffer sb = new StringBuffer();
            sb.append(e.getMessage().trim() + "\n" + "  Parent stack:\n");
            boolean first = true;
            for (Dependency d : parentStack) {
                sb.append("         " + d.getArtifact().toString().trim() + (first ? " (top)" : "") + "\n");
                first = false;
            }
            throw new MissingDependencyException(sb.toString());
        }
        Dependency resolvedDependency = new Dependency(artifact, dependency.getImportType());
        return resolvedDependency;
    }

    private ArrayList getChildDependencies(Dependency dependency) {
        ArrayList<Dependency> childDependencies = new ArrayList<Dependency>();
        for (Repository repository : this.repositories) {
            if (!repository.contains(dependency.getArtifact())) continue;
            LinkedHashSet childArtifacts = repository.getDependencies(dependency.getArtifact());
            for (Artifact artifact : childArtifacts) {
                childDependencies.add(new Dependency(artifact, ImportType.CLASSES));
            }
        }
        return childDependencies;
    }
}

