/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.classloader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.geronimo.kernel.classloader.AbstractUrlResourceLocation;
import org.apache.geronimo.kernel.classloader.DirectoryResourceLocation;
import org.apache.geronimo.kernel.classloader.JarResourceLocation;
import org.apache.geronimo.kernel.classloader.ResourceEnumeration;
import org.apache.geronimo.kernel.classloader.ResourceFinder;
import org.apache.geronimo.kernel.classloader.ResourceHandle;
import org.apache.geronimo.kernel.classloader.ResourceLocation;

public class UrlResourceFinder
implements ResourceFinder {
    private final Object lock = new Object();
    private final LinkedHashSet urls = new LinkedHashSet();
    private final LinkedHashMap classPath = new LinkedHashMap();
    private final LinkedHashSet watchedFiles = new LinkedHashSet();
    private boolean destroyed = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UrlResourceFinder() {
    }

    public UrlResourceFinder(URL[] urls) {
        this.addUrls(urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            this.urls.clear();
            Iterator iterator = this.classPath.values().iterator();
            while (iterator.hasNext()) {
                ResourceLocation resourceLocation = (ResourceLocation)iterator.next();
                resourceLocation.close();
            }
            this.classPath.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle getResource(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return null;
            }
            Iterator iterator = this.getClassPath().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ResourceLocation resourceLocation = (ResourceLocation)entry.getValue();
                ResourceHandle resourceHandle = resourceLocation.getResourceHandle(resourceName);
                if (resourceHandle == null || resourceHandle.isDirectory()) continue;
                return resourceHandle;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL findResource(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return null;
            }
            Iterator iterator = this.getClassPath().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ResourceLocation resourceLocation = (ResourceLocation)entry.getValue();
                ResourceHandle resourceHandle = resourceLocation.getResourceHandle(resourceName);
                if (resourceHandle == null) continue;
                return resourceHandle.getUrl();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration findResources(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            return new ResourceEnumeration(new ArrayList(this.getClassPath().values()), resourceName);
        }
    }

    public void addUrl(URL url) {
        this.addUrls(Collections.singletonList(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getUrls() {
        Object object = this.lock;
        synchronized (object) {
            return this.urls.toArray(new URL[this.urls.size()]);
        }
    }

    protected void addUrls(URL[] urls) {
        this.addUrls(Arrays.asList(urls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUrls(List urls) {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                throw new IllegalStateException("UrlResourceFinder has been destroyed");
            }
            boolean shouldRebuild = this.urls.addAll(urls);
            if (shouldRebuild) {
                this.rebuildClassPath();
            }
        }
    }

    private LinkedHashMap getClassPath() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError((Object)"This method can only be called while holding the lock");
        }
        Iterator iterator = this.watchedFiles.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.canRead()) continue;
            this.rebuildClassPath();
            break;
        }
        return this.classPath;
    }

    private void rebuildClassPath() {
        ResourceLocation resourceLocation;
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError((Object)"This method can only be called while holding the lock");
        }
        LinkedHashMap existingJarFiles = new LinkedHashMap(this.classPath);
        this.classPath.clear();
        LinkedList locationStack = new LinkedList(this.urls);
        try {
            while (!locationStack.isEmpty()) {
                URL url = (URL)locationStack.removeFirst();
                if (this.classPath.containsKey(url)) continue;
                resourceLocation = (ResourceLocation)existingJarFiles.remove(url);
                if (resourceLocation == null) {
                    try {
                        File file = this.cacheUrl(url);
                        resourceLocation = this.createResourceLocation(url, file);
                    }
                    catch (FileNotFoundException e) {
                        if ("file".equals(url.getProtocol())) {
                            File file = new File(url.getPath());
                            this.watchedFiles.add(file);
                            continue;
                        }
                    }
                    catch (IOException ignored) {
                        continue;
                    }
                }
                this.classPath.put(resourceLocation.getCodeSource(), resourceLocation);
                List manifestClassPath = this.getManifestClassPath(resourceLocation);
                locationStack.addAll(0, manifestClassPath);
            }
        }
        catch (Error e) {
            this.destroy();
            throw e;
        }
        Iterator iterator = existingJarFiles.values().iterator();
        while (iterator.hasNext()) {
            resourceLocation = (ResourceLocation)iterator.next();
            resourceLocation.close();
        }
    }

    protected File cacheUrl(URL url) throws IOException {
        if (!"file".equals(url.getProtocol())) {
            throw new Error("Only local file jars are supported " + url);
        }
        File file = new File(url.getPath());
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("File is not readable: " + file.getAbsolutePath());
        }
        return file;
    }

    protected ResourceLocation createResourceLocation(URL codeSource, File cacheFile) throws IOException {
        if (!cacheFile.exists()) {
            throw new FileNotFoundException(cacheFile.getAbsolutePath());
        }
        if (!cacheFile.canRead()) {
            throw new IOException("File is not readable: " + cacheFile.getAbsolutePath());
        }
        AbstractUrlResourceLocation resourceLocation = null;
        resourceLocation = cacheFile.isDirectory() ? new DirectoryResourceLocation(cacheFile) : new JarResourceLocation(codeSource, new JarFile(cacheFile));
        return resourceLocation;
    }

    private List getManifestClassPath(ResourceLocation resourceLocation) {
        try {
            Manifest manifest = resourceLocation.getManifest();
            if (manifest == null) {
                return Collections.EMPTY_LIST;
            }
            String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (manifestClassPath == null) {
                return Collections.EMPTY_LIST;
            }
            URL codeSource = resourceLocation.getCodeSource();
            LinkedList<URL> classPathUrls = new LinkedList<URL>();
            StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
            while (tokenizer.hasMoreTokens()) {
                String entry = tokenizer.nextToken();
                try {
                    URL entryUrl = new URL(codeSource, entry);
                    classPathUrls.addLast(entryUrl);
                }
                catch (MalformedURLException ignored) {}
            }
            return classPathUrls;
        }
        catch (IOException ignored) {
            return Collections.EMPTY_LIST;
        }
    }

    static {
        $assertionsDisabled = !UrlResourceFinder.class.desiredAssertionStatus();
    }
}

