/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.kernel.Kernel;

public final class KernelRegistry {
    private static final Map kernels = new HashMap();
    private static final ReferenceQueue queue = new ReferenceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getKernelNames() {
        Map map = kernels;
        synchronized (map) {
            return Collections.unmodifiableSet(kernels.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Kernel getKernel(String name) {
        if (name == null) {
            return KernelRegistry.getSingleKernel();
        }
        Map map = kernels;
        synchronized (map) {
            KernelRegistry.processQueue();
            KernelReference ref = (KernelReference)kernels.get(name);
            if (ref != null) {
                return (Kernel)ref.get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Kernel getSingleKernel() {
        Map map = kernels;
        synchronized (map) {
            KernelRegistry.processQueue();
            int size = kernels.size();
            if (size > 1) {
                throw new IllegalStateException("More than one kernel has been registered.");
            }
            if (size < 1) {
                return null;
            }
            Kernel result = (Kernel)((KernelReference)kernels.values().iterator().next()).get();
            if (result == null) {
                kernels.clear();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerKernel(Kernel kernel) {
        Map map = kernels;
        synchronized (map) {
            String kernelName = kernel.getKernelName();
            if (kernels.containsKey(kernelName)) {
                throw new IllegalStateException("A kernel is already running this kernel name: " + kernelName);
            }
            kernels.put(kernelName, new KernelReference(kernelName, kernel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterKernel(Kernel kernel) {
        Map map = kernels;
        synchronized (map) {
            kernels.remove(kernel.getKernelName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() {
        KernelReference kernelRef;
        while ((kernelRef = (KernelReference)queue.poll()) != null) {
            Map map = kernels;
            synchronized (map) {
                kernels.remove(kernelRef.key);
            }
        }
    }

    private static class KernelReference
    extends WeakReference {
        private final Object key;

        public KernelReference(Object key, Object kernel) {
            super(kernel, queue);
            this.key = key;
        }
    }
}

