/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8.handler;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContextException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.SharedConnectorInstanceContext;
import org.apache.geronimo.jetty8.handler.BundlePathResource;
import org.apache.geronimo.jetty8.handler.IntegrationContext;
import org.apache.geronimo.osgi.web.WebApplicationUtils;
import org.apache.geronimo.security.jacc.ApplicationPolicyConfigurationManager;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.web.WebApplicationName;
import org.apache.geronimo.web.WebModuleListener;
import org.apache.geronimo.web.assembler.Assembler;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.geronimo.web.security.SpecSecurityBuilder;
import org.apache.geronimo.web.security.WebSecurityConstraintStore;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoWebAppContext
extends WebAppContext {
    private static final Logger logger = LoggerFactory.getLogger(GeronimoWebAppContext.class);
    private final IntegrationContext integrationContext;
    private final String modulePath;
    private final ClassLoader classLoader;
    private final WebAppInfo webAppInfo;
    private final WebSecurityConstraintStore webSecurityConstraintStore;
    private final String policyContextId;
    private final ApplicationPolicyConfigurationManager applicationPolicyConfigurationManager;
    private ServiceRegistration serviceRegistration;
    boolean fullyStarted = false;
    private String webModuleName;
    private final List webModuleListeners;

    public GeronimoWebAppContext(SecurityHandler securityHandler, SessionHandler sessionHandler, ServletHandler servletHandler, ErrorHandler errorHandler, IntegrationContext integrationContext, ClassLoader classLoader, String modulePath, WebAppInfo webAppInfo, String policyContextId, ApplicationPolicyConfigurationManager applicationPolicyConfigurationManager, List<String> webModuleListenerClassNames) {
        super(sessionHandler, securityHandler, servletHandler, errorHandler);
        this._scontext = new Context();
        this.integrationContext = integrationContext;
        this.setClassLoader(classLoader);
        this.classLoader = classLoader;
        Bundle bundle = BundleUtils.unwrapBundle((Bundle)integrationContext.getBundle());
        this.setAttribute("osgi-bundlecontext", bundle.getBundleContext());
        this.setAttribute("WEB_APP_INFO", webAppInfo);
        this.setAttribute("org.springframework.osgi.web." + BundleContext.class.getName(), bundle.getBundleContext());
        this.setAttribute("WEB_APP_NAME", this.webModuleName);
        try {
            javax.naming.Context ctx = integrationContext.getComponentContext();
            Object validatorFactory = ctx.lookup("comp/ValidatorFactory");
            this.setAttribute("javax.faces.validator.beanValidator.ValidatorFactory", validatorFactory);
        }
        catch (NamingException e) {
            // empty catch block
        }
        this.modulePath = modulePath;
        this.webAppInfo = webAppInfo;
        this.policyContextId = policyContextId;
        this.applicationPolicyConfigurationManager = applicationPolicyConfigurationManager;
        boolean annotationScanRequired = true;
        this.webSecurityConstraintStore = new WebSecurityConstraintStore(webAppInfo, integrationContext.getBundle(), annotationScanRequired, (ServletContext)this._scontext);
        if (webModuleListenerClassNames != null && webModuleListenerClassNames.size() > 0) {
            this.webModuleListeners = new ArrayList(webModuleListenerClassNames.size());
            for (String webModuleListenerClassName : webModuleListenerClassNames) {
                try {
                    Class<?> cls = classLoader.loadClass(webModuleListenerClassName);
                    Object webModuleListener = cls.newInstance();
                    this.webModuleListeners.add(webModuleListener);
                }
                catch (ClassNotFoundException e) {
                    logger.warn("Unable to load the listener class" + webModuleListenerClassName, (Throwable)e);
                }
                catch (InstantiationException e) {
                    logger.warn("Unable to create the listener instance " + webModuleListenerClassName, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.warn("Unable to create the listener instance " + webModuleListenerClassName, (Throwable)e);
                }
            }
        } else {
            this.webModuleListeners = Collections.emptyList();
        }
    }

    public void setWebModuleName(String webModuleName) {
        this.webModuleName = webModuleName;
    }

    public void registerServletContext() {
        Bundle bundle = this.integrationContext.getBundle();
        if (WebApplicationUtils.isWebApplicationBundle((Bundle)bundle)) {
            this.serviceRegistration = WebApplicationUtils.registerServletContext((Bundle)bundle, (ServletContext)this.getServletContext());
        }
    }

    public void unregisterServletContext() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        javax.naming.Context context = this.integrationContext.setContext();
        boolean txActive = this.integrationContext.isTxActive();
        SharedConnectorInstanceContext newContext = this.integrationContext.newConnectorInstanceContext(null);
        ConnectorInstanceContext connectorContext = this.integrationContext.setConnectorInstance(null, newContext);
        String oldApplicationName = WebApplicationName.getName();
        WebApplicationName.setName((String)this.integrationContext.getWebApplicationIdentity());
        try {
            this.setRestrictListeners(false);
            for (Object webModuleListener : this.webModuleListeners) {
                if (webModuleListener instanceof WebModuleListener) {
                    ((WebModuleListener)webModuleListener).moduleInitialized((ServletContext)this.getServletContext());
                    continue;
                }
                logger.warn("Invalid WebModuleListener " + webModuleListener.getClass().getName());
            }
            try {
                Assembler assembler = new Assembler();
                assembler.assemble((ServletContext)this.getServletContext(), this.webAppInfo);
                this.webSecurityConstraintStore.setAnnotationScanRequired(true);
                ((Context)this._scontext).webXmlProcessed = true;
                for (Map.Entry<ServletContainerInitializer, Set<Class<?>>> entry : this.integrationContext.getServletContainerInitializerMap().entrySet()) {
                    entry.getKey().onStartup(entry.getValue(), (ServletContext)this.getServletContext());
                }
                super.doStart();
                if (!this.isAvailable()) {
                    Throwable e = this.getUnavailableException();
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    if (e instanceof Throwable) {
                        throw new Exception("Could not start web app", e);
                    }
                    throw new Exception("Could not start web app for unknown reason");
                }
                if (this.applicationPolicyConfigurationManager != null) {
                    SpecSecurityBuilder specSecurityBuilder = new SpecSecurityBuilder(this.webSecurityConstraintStore.exportMergedWebAppInfo());
                    HashMap<String, ComponentPermissions> contextIdPermissionsMap = new HashMap<String, ComponentPermissions>();
                    contextIdPermissionsMap.put(this.policyContextId, specSecurityBuilder.buildSpecSecurityConfig());
                    try {
                        this.applicationPolicyConfigurationManager.updateApplicationPolicyConfiguration(contextIdPermissionsMap);
                    }
                    catch (LoginException e) {
                        throw new RuntimeException("Fail to set application policy configurations", e);
                    }
                    catch (PolicyContextException e) {
                        throw new RuntimeException("Fail to set application policy configurations", e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Fail to set application policy configurations", e);
                    }
                    finally {
                        specSecurityBuilder.clear();
                    }
                }
                this.fullyStarted = true;
            }
            finally {
                this.setRestrictListeners(true);
                this.integrationContext.restoreConnectorContext(connectorContext, null, newContext);
            }
        }
        finally {
            this.integrationContext.restoreContext(context);
            this.integrationContext.completeTx(txActive, null);
            WebApplicationName.setName((String)oldApplicationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        javax.naming.Context context = this.integrationContext.setContext();
        boolean txActive = this.integrationContext.isTxActive();
        SharedConnectorInstanceContext newContext = this.integrationContext.newConnectorInstanceContext(null);
        ConnectorInstanceContext connectorContext = this.integrationContext.setConnectorInstance(null, newContext);
        String oldApplicationName = WebApplicationName.getName();
        WebApplicationName.setName((String)this.integrationContext.getWebApplicationIdentity());
        try {
            try {
                super.doStop();
            }
            finally {
                this.integrationContext.restoreConnectorContext(connectorContext, null, newContext);
            }
            for (Object webModuleListener : this.webModuleListeners) {
                if (webModuleListener instanceof WebModuleListener) {
                    ((WebModuleListener)webModuleListener).moduleDestoryed((ServletContext)this.getServletContext());
                    continue;
                }
                logger.warn("Invalid WebModuleListener " + webModuleListener.getClass().getName());
            }
        }
        finally {
            this.integrationContext.restoreContext(context);
            this.integrationContext.completeTx(txActive, null);
            WebApplicationName.setName((String)oldApplicationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        javax.naming.Context context = this.integrationContext.setContext();
        boolean txActive = this.integrationContext.isTxActive();
        SharedConnectorInstanceContext newContext = this.integrationContext.newConnectorInstanceContext(baseRequest);
        ConnectorInstanceContext connectorContext = this.integrationContext.setConnectorInstance(baseRequest, newContext);
        String oldApplicationName = WebApplicationName.getName();
        WebApplicationName.setName((String)this.integrationContext.getWebApplicationIdentity());
        try {
            try {
                super.doScope(target, baseRequest, request, response);
            }
            finally {
                this.integrationContext.restoreConnectorContext(connectorContext, baseRequest, newContext);
            }
        }
        finally {
            this.integrationContext.restoreContext(context);
            this.integrationContext.completeTx(txActive, baseRequest);
            WebApplicationName.setName((String)oldApplicationName);
        }
    }

    protected boolean isProtectedTarget(String target) {
        while (target.startsWith("//")) {
            target = URIUtil.compactPath((String)target);
        }
        return StringUtil.startsWithIgnoreCase((String)target, (String)"/web-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/meta-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/osgi-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/osgi-opt");
    }

    public Resource newResource(String url) throws IOException {
        if (url == null) {
            return null;
        }
        return this.newResource(new URL(url));
    }

    public Resource newResource(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        if ("bundle".equals(protocol) || "bundleentry".equals(protocol)) {
            return this.lookupResource(url.getPath());
        }
        return super.newResource(url);
    }

    public Resource getResource(String uriInContext) throws MalformedURLException {
        if (uriInContext == null || !uriInContext.startsWith("/")) {
            throw new MalformedURLException("Path must not be null and must start with '/': " + uriInContext);
        }
        if (this.modulePath != null) {
            uriInContext = this.modulePath + uriInContext;
        }
        return this.lookupResource(uriInContext);
    }

    public Set<String> getResourcePaths(String uriInContext) {
        if (uriInContext == null || !uriInContext.startsWith("/")) {
            return Collections.emptySet();
        }
        if (this.modulePath != null) {
            uriInContext = this.modulePath + uriInContext;
        }
        HashSet<String> paths = new HashSet<String>();
        Bundle bundle = this.integrationContext.getBundle();
        Enumeration e = bundle.getEntryPaths(uriInContext);
        if (e != null) {
            while (e.hasMoreElements()) {
                paths.add("/" + (String)e.nextElement());
            }
        }
        return paths;
    }

    protected ServletRegistration.Dynamic dynamicHolderAdded(ServletHolder holder) {
        ServletRegistration.Dynamic registration = holder.getRegistration();
        String servletClassName = holder.getClassName();
        Servlet servlet = holder.getServletInstance();
        if (servlet == null || this.webSecurityConstraintStore.isContainerCreatedDynamicServlet(servlet)) {
            this.webSecurityConstraintStore.addContainerCreatedDynamicServletEntry(registration, servletClassName);
        }
        return registration;
    }

    public Set<String> setServletSecurity(ServletRegistration.Dynamic registration, ServletSecurityElement servletSecurityElement) {
        return this.webSecurityConstraintStore.setDynamicServletSecurity(registration, servletSecurityElement);
    }

    protected void addRoles(String ... roles) {
        this.webSecurityConstraintStore.declareRoles(roles);
    }

    private Resource lookupResource(String uriInContext) {
        URL url;
        Bundle bundle = this.integrationContext.getBundle();
        try {
            url = BundleUtils.getEntry((Bundle)bundle, (String)uriInContext);
        }
        catch (MalformedURLException e) {
            logger.warn("MalformedURLException when getting entry:" + uriInContext + " from bundle " + bundle.getSymbolicName(), (Throwable)e);
            url = null;
        }
        if (url == null && (url = bundle.getResource("META-INF/resources" + uriInContext)) == null) {
            return null;
        }
        if (uriInContext.endsWith("/")) {
            Enumeration paths = BundleUtils.getEntryPaths((Bundle)bundle, (String)uriInContext);
            return new BundlePathResource(url, paths);
        }
        return new BundleFileResource(url);
    }

    public class Context
    extends WebAppContext.Context {
        protected boolean webXmlProcessed;

        public Context() {
            super((WebAppContext)GeronimoWebAppContext.this);
            this.webXmlProcessed = false;
        }

        public <T extends Filter> T createFilter(Class<T> c) throws ServletException {
            try {
                return (T)((Filter)GeronimoWebAppContext.this.integrationContext.getHolder().newInstance(c.getName(), GeronimoWebAppContext.this.classLoader, GeronimoWebAppContext.this.integrationContext.getComponentContext()));
            }
            catch (IllegalAccessException e) {
                throw new ServletException("Could not create filter " + c.getName(), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ServletException("Could not create filter " + c.getName(), (Throwable)e);
            }
        }

        public <T extends EventListener> T createListener(Class<T> c) throws ServletException {
            try {
                return (T)((EventListener)GeronimoWebAppContext.this.integrationContext.getHolder().newInstance(c.getName(), GeronimoWebAppContext.this.classLoader, GeronimoWebAppContext.this.integrationContext.getComponentContext()));
            }
            catch (IllegalAccessException e) {
                throw new ServletException("Could not create listener " + c.getName(), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ServletException("Could not create listener " + c.getName(), (Throwable)e);
            }
        }

        public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
            try {
                Servlet servlet = (Servlet)GeronimoWebAppContext.this.integrationContext.getHolder().newInstance(c.getName(), GeronimoWebAppContext.this.classLoader, GeronimoWebAppContext.this.integrationContext.getComponentContext());
                GeronimoWebAppContext.this.webSecurityConstraintStore.addContainerCreatedDynamicServlet(servlet);
                return (T)servlet;
            }
            catch (IllegalAccessException e) {
                throw new ServletException("Could not create servlet " + c.getName(), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ServletException("Could not create servlet " + c.getName(), (Throwable)e);
            }
        }
    }

    private static class BundleFileResource
    extends URLResource {
        protected BundleFileResource(URL url) {
            super(url, null);
        }

        public boolean exists() {
            return true;
        }
    }
}

