/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8.handler;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.naming.Context;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.SharedConnectorInstanceContext;
import org.apache.geronimo.jetty8.handler.BundlePathResource;
import org.apache.geronimo.jetty8.handler.IntegrationContext;
import org.apache.geronimo.osgi.web.WebApplicationUtils;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class GeronimoWebAppContext
extends WebAppContext {
    private final IntegrationContext integrationContext;
    private final String modulePath;
    private ServiceRegistration serviceRegistration;

    public GeronimoWebAppContext(SecurityHandler securityHandler, SessionHandler sessionHandler, ServletHandler servletHandler, ErrorHandler errorHandler, IntegrationContext integrationContext, ClassLoader classLoader, String modulePath) {
        super(sessionHandler, securityHandler, servletHandler, errorHandler);
        this.integrationContext = integrationContext;
        this.setClassLoader(classLoader);
        this.setAttribute("osgi-bundlecontext", integrationContext.getBundle().getBundleContext());
        this.modulePath = modulePath;
    }

    public void registerServletContext() {
        Bundle bundle = this.integrationContext.getBundle();
        if (WebApplicationUtils.isWebApplicationBundle((Bundle)bundle)) {
            this.serviceRegistration = WebApplicationUtils.registerServletContext((Bundle)bundle, (ServletContext)this.getServletContext());
        }
    }

    public void unregisterServletContext() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        Context context = this.integrationContext.setContext();
        boolean txActive = this.integrationContext.isTxActive();
        SharedConnectorInstanceContext newContext = this.integrationContext.newConnectorInstanceContext(null);
        ConnectorInstanceContext connectorContext = this.integrationContext.setConnectorInstance(null, newContext);
        try {
            try {
                super.doStart();
            }
            finally {
                this.integrationContext.restoreConnectorContext(connectorContext, null, newContext);
            }
        }
        finally {
            this.integrationContext.restoreContext(context);
            this.integrationContext.completeTx(txActive, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        Context context = this.integrationContext.setContext();
        boolean txActive = this.integrationContext.isTxActive();
        SharedConnectorInstanceContext newContext = this.integrationContext.newConnectorInstanceContext(null);
        ConnectorInstanceContext connectorContext = this.integrationContext.setConnectorInstance(null, newContext);
        try {
            try {
                super.doStop();
            }
            finally {
                this.integrationContext.restoreConnectorContext(connectorContext, null, newContext);
            }
        }
        finally {
            this.integrationContext.restoreContext(context);
            this.integrationContext.completeTx(txActive, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Context context = this.integrationContext.setContext();
        boolean txActive = this.integrationContext.isTxActive();
        SharedConnectorInstanceContext newContext = this.integrationContext.newConnectorInstanceContext(baseRequest);
        ConnectorInstanceContext connectorContext = this.integrationContext.setConnectorInstance(baseRequest, newContext);
        try {
            try {
                super.doScope(target, baseRequest, request, response);
            }
            finally {
                this.integrationContext.restoreConnectorContext(connectorContext, baseRequest, newContext);
            }
        }
        finally {
            this.integrationContext.restoreContext(context);
            this.integrationContext.completeTx(txActive, baseRequest);
        }
    }

    protected boolean isProtectedTarget(String target) {
        while (target.startsWith("//")) {
            target = URIUtil.compactPath((String)target);
        }
        return StringUtil.startsWithIgnoreCase((String)target, (String)"/web-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/meta-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/osgi-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/osgi-opt");
    }

    public Resource newResource(String url) throws IOException {
        if (url == null) {
            return null;
        }
        return this.newResource(new URL(url));
    }

    public Resource newResource(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        if ("bundle".equals(protocol) || "bundleentry".equals(protocol)) {
            return this.lookupResource(url.getPath());
        }
        return super.newResource(url);
    }

    public Resource getResource(String uriInContext) throws MalformedURLException {
        if (this.modulePath != null) {
            uriInContext = this.modulePath + uriInContext;
        }
        return this.lookupResource(uriInContext);
    }

    private Resource lookupResource(String uriInContext) {
        Bundle bundle = this.integrationContext.getBundle();
        URL url = BundleUtils.getEntry((Bundle)bundle, (String)uriInContext);
        if (url == null) {
            return null;
        }
        if (uriInContext.endsWith("/")) {
            Enumeration paths = BundleUtils.getEntryPaths((Bundle)bundle, (String)uriInContext);
            return new BundlePathResource(url, paths);
        }
        return new BundleFileResource(url);
    }

    private static class BundleFileResource
    extends URLResource {
        protected BundleFileResource(URL url) {
            super(url, null);
        }

        public boolean exists() {
            return true;
        }
    }
}

