/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8.handler;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.jacc.WebRoleRefPermission;
import org.apache.geronimo.security.ContextManager;
import org.eclipse.jetty.security.RunAsToken;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoUserIdentity
implements UserIdentity {
    private final Logger log = LoggerFactory.getLogger(GeronimoUserIdentity.class);
    private final Subject subject;
    private final Principal userPrincipal;
    private final AccessControlContext acc;
    private RunAsToken runAsToken;
    private ServletHolder servletHolder;

    public GeronimoUserIdentity(Subject subject, Principal userPrincipal, AccessControlContext acc) {
        if (acc == null) {
            throw new NullPointerException("AccessControlContext acc required");
        }
        this.subject = subject;
        this.userPrincipal = userPrincipal;
        this.acc = acc;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String[] getRoles() {
        RuntimeException e = new RuntimeException("Not implemented");
        this.log.info("getRoles called on identity " + this, (Throwable)e);
        throw e;
    }

    public boolean isUserInRole(String role, UserIdentity.Scope scope) {
        String servletName = scope.getName();
        if (servletName == null || servletName.equals("jsp")) {
            servletName = "";
        }
        try {
            AccessControlContext acc = ContextManager.getCurrentContext();
            acc.checkPermission((Permission)new WebRoleRefPermission(servletName, role));
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public void logout(Principal user) {
    }

    public AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    public String toString() {
        return "GeronimoUserIdentity[Subject: " + this.subject + ", Principal: " + this.userPrincipal + ", acc: " + this.acc + "]";
    }
}

