/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.RuntimeCustomizer;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.jndi.ContextSource;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.jetty8.Host;
import org.apache.geronimo.jetty8.JettyContainer;
import org.apache.geronimo.jetty8.JettyServletRegistration;
import org.apache.geronimo.jetty8.PreHandler;
import org.apache.geronimo.jetty8.PreHandlerFactory;
import org.apache.geronimo.jetty8.SessionHandlerFactory;
import org.apache.geronimo.jetty8.handler.GeronimoWebAppContext;
import org.apache.geronimo.jetty8.handler.IntegrationContext;
import org.apache.geronimo.jetty8.security.SecurityHandlerFactory;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebModule;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(name="Jetty WebApplication Context", j2eeType="WebModule")
public class WebAppContextWrapper
implements GBeanLifecycle,
JettyServletRegistration,
WebModule {
    private static final Logger log = LoggerFactory.getLogger(WebAppContextWrapper.class);
    public static final String GBEAN_ATTR_SESSION_TIMEOUT = "sessionTimeoutSeconds";
    public static final String GBEAN_REF_SESSION_HANDLER_FACTORY = "SessionHandlerFactory";
    public static final String GBEAN_REF_PRE_HANDLER_FACTORY = "PreHandlerFactory";
    private final String originalSpecDD;
    private final J2EEServer server;
    private final J2EEApplication application;
    private final ClassLoader webClassLoader;
    private final JettyContainer jettyContainer;
    private String displayName;
    private final String objectName;
    private final GeronimoWebAppContext webAppContext;
    private final Context componentContext;
    private final Holder holder;
    private final Set<String> servletNames = new HashSet<String>();
    private final IntegrationContext integrationContext;

    public WebAppContextWrapper(@ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamAttribute(name="contextPath") String contextPath, @ParamAttribute(name="deploymentDescriptor") String originalSpecDD, @ParamAttribute(name="modulePath") String modulePath, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamAttribute(name="workDir") String workDir, @ParamAttribute(name="unshareableResources") Set<String> unshareableResources, @ParamAttribute(name="applicationManagedSecurityResources") Set<String> applicationManagedSecurityResources, @ParamAttribute(name="displayName") String displayName, @ParamAttribute(name="contextParamMap") Map<String, String> contextParamMap, @ParamAttribute(name="listenerClassNames") Collection<String> listenerClassNames, @ParamAttribute(name="distributable") boolean distributable, @ParamAttribute(name="mimeMap") Map mimeMap, @ParamAttribute(name="welcomeFiles") String[] welcomeFiles, @ParamAttribute(name="localeEncodingMapping") Map<String, String> localeEncodingMapping, @ParamAttribute(name="errorPages") Map errorPages, @ParamAttribute(name="tagLibMap") Map<String, String> tagLibMap, @ParamAttribute(name="compactPath") boolean compactPath, @ParamAttribute(name="sessionTimeoutSeconds") int sessionTimeoutSeconds, @ParamReference(name="SessionHandlerFactory") SessionHandlerFactory handlerFactory, @ParamReference(name="PreHandlerFactory") PreHandlerFactory preHandlerFactory, @ParamAttribute(name="policyContextID") String policyContextID, @ParamReference(name="SecurityHandlerFactory") SecurityHandlerFactory securityHandlerFactory, @ParamReference(name="RunAsSource") RunAsSource runAsSource, @ParamAttribute(name="holder") Holder holder, @ParamReference(name="Host") Host host, @ParamReference(name="TrackedConnectionAssociator") TrackedConnectionAssociator trackedConnectionAssociator, @ParamReference(name="JettyContainer") JettyContainer jettyContainer, @ParamReference(name="ContextCustomizer") RuntimeCustomizer contextCustomizer, @ParamReference(name="J2EEServer") J2EEServer server, @ParamReference(name="J2EEApplication") J2EEApplication application, @ParamReference(name="ContextSource") ContextSource contextSource, @ParamReference(name="TransactionManager") TransactionManager transactionManager, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel) throws Exception {
        SessionHandler sessionHandler;
        RunAsSource runAsSource1;
        assert (contextSource != null);
        assert (classLoader != null);
        assert (trackedConnectionAssociator != null);
        assert (jettyContainer != null);
        if (contextPath == null || !contextPath.startsWith("/")) {
            throw new IllegalArgumentException("context contextPath must be non-null and start with '/', not " + contextPath);
        }
        this.holder = holder == null ? Holder.EMPTY : holder;
        RunAsSource runAsSource2 = runAsSource1 = runAsSource == null ? RunAsSource.NULL : runAsSource;
        if (null != handlerFactory) {
            if (null == preHandlerFactory) {
                throw new IllegalStateException("A preHandlerFactory must be set if an handler factory is set.");
            }
            PreHandler preHandler = preHandlerFactory.createHandler();
            sessionHandler = handlerFactory.createHandler(preHandler);
        } else {
            sessionHandler = new SessionHandler();
        }
        SecurityHandler securityHandler = null;
        if (securityHandlerFactory != null) {
            Subject defaultSubject = runAsSource1.getDefaultSubject();
            securityHandler = securityHandlerFactory.buildSecurityHandler(policyContextID, defaultSubject, runAsSource, true);
        }
        ServletHandler servletHandler = new ServletHandler();
        this.componentContext = contextSource.getContext();
        GeronimoUserTransaction userTransaction = new GeronimoUserTransaction(transactionManager);
        this.integrationContext = new IntegrationContext(this.componentContext, unshareableResources, applicationManagedSecurityResources, trackedConnectionAssociator, (UserTransaction)userTransaction, bundle);
        this.webAppContext = new GeronimoWebAppContext(securityHandler, sessionHandler, servletHandler, null, this.integrationContext, classLoader, modulePath);
        this.webAppContext.setContextPath(contextPath);
        this.webAppContext.setCompactPath(compactPath);
        if (workDir == null) {
            workDir = contextPath.replace('/', '_');
        }
        this.webAppContext.setTempDirectory(jettyContainer.resolveToJettyHome(workDir));
        if (contextCustomizer != null) {
            HashMap servletContext = new HashMap();
            HashMap<Class, Object> customizerContext = new HashMap<Class, Object>();
            customizerContext.put(Map.class, servletContext);
            customizerContext.put(Context.class, this.componentContext);
            contextCustomizer.customize(customizerContext);
            for (Map.Entry entry : servletContext.entrySet()) {
                this.webAppContext.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.setMimeMap(mimeMap);
        this.webAppContext.setMimeTypes(mimeTypes);
        this.server = server;
        this.application = application;
        this.objectName = objectName;
        if (objectName != null) {
            ObjectName myObjectName = ObjectNameUtil.getObjectName((String)objectName);
            this.verifyObjectName(myObjectName);
        }
        this.jettyContainer = jettyContainer;
        this.originalSpecDD = originalSpecDD;
        this.webAppContext.setConfigurationClasses(new String[0]);
        this.webClassLoader = classLoader;
        this.webAppContext.setClassLoader(this.webClassLoader);
        if (host != null) {
            this.webAppContext.setConnectorNames(host.getHosts());
            this.webAppContext.setVirtualHosts(host.getVirtualHosts());
        }
        this.setDisplayName(displayName);
        this.webAppContext.setInitParams(contextParamMap);
        this.setListenerClassNames(listenerClassNames);
        this.webAppContext.setDistributable(distributable);
        this.webAppContext.setWelcomeFiles(welcomeFiles);
        this.setLocaleEncodingMapping(localeEncodingMapping);
        this.setErrorPages(errorPages);
        this.setTagLibMap(tagLibMap);
        if (!distributable) {
            this.setSessionTimeoutSeconds(sessionTimeoutSeconds);
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public URL getWARDirectory() {
        throw new RuntimeException("don't call this");
    }

    public String getWARName() {
        try {
            return ObjectName.getInstance(this.objectName).getKeyProperty("name");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public WebContainer getContainer() {
        return this.jettyContainer;
    }

    public String getContextPath() {
        return this.webAppContext.getContextPath();
    }

    @Override
    public <T> Class<? extends T> loadClass(String className, Class<T> clazz) throws ClassNotFoundException {
        return this.integrationContext.getBundle().loadClass(className).asSubclass(clazz);
    }

    @Override
    public IntegrationContext getIntegrationContext() {
        return this.integrationContext;
    }

    @Override
    public Object newInstance(String className) throws InstantiationException, IllegalAccessException {
        if (className == null) {
            throw new InstantiationException("no class loaded");
        }
        return this.holder.newInstance(className, this.webClassLoader, this.componentContext);
    }

    @Override
    public void destroyInstance(Object o) throws Exception {
        Map preDestroy;
        Class<?> clazz = o.getClass();
        if (this.holder != null && (preDestroy = this.holder.getPreDestroy()) != null) {
            Holder.apply((Object)o, clazz, (Map)preDestroy);
        }
    }

    public void fullyStarted() {
        this.webAppContext.registerServletContext();
    }

    public void doStart() throws Exception {
        this.webAppContext.setClassLoader(this.webClassLoader);
        this.jettyContainer.addContext((Handler)this.webAppContext);
        this.webAppContext.start();
    }

    public void doStop() throws Exception {
        this.webAppContext.unregisterServletContext();
        this.webAppContext.stop();
        this.jettyContainer.removeContext((Handler)this.webAppContext);
        log.debug("WebAppContextWrapper stopped");
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.warn("WebAppContextWrapper failed");
    }

    public void setLocaleEncodingMapping(@ParamAttribute(name="localeEncodingMapping") Map<String, String> localeEncodingMap) {
        if (localeEncodingMap != null) {
            for (Map.Entry<String, String> entry : localeEncodingMap.entrySet()) {
                this.webAppContext.addLocaleEncoding(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setListenerClassNames(@ParamAttribute(name="listenerClassNames") Collection<String> eventListeners) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (eventListeners != null) {
            ArrayList<EventListener> listeners = new ArrayList<EventListener>();
            for (String listenerClassName : eventListeners) {
                EventListener listener = (EventListener)this.newInstance(listenerClassName);
                listeners.add(listener);
            }
            this.webAppContext.setEventListeners(listeners.toArray(new EventListener[listeners.size()]));
        }
    }

    public void setErrorPages(@ParamAttribute(name="errorPages") Map errorPageMap) {
        if (errorPageMap != null) {
            ((ErrorPageErrorHandler)this.webAppContext.getErrorHandler()).setErrorPages(errorPageMap);
        }
    }

    public void setTagLibMap(@ParamAttribute(name="tagLibMap") Map<String, String> tagLibMap) {
        if (tagLibMap != null) {
            for (Map.Entry<String, String> entry : tagLibMap.entrySet()) {
                this.webAppContext.setResourceAlias(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setSessionTimeoutSeconds(@ParamAttribute(name="sessionTimeoutSeconds") int seconds) {
        this.webAppContext.getSessionHandler().getSessionManager().setMaxInactiveInterval(seconds);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.webAppContext.setDisplayName(displayName);
    }

    public String getDeploymentDescriptor() {
        return this.originalSpecDD;
    }

    public String getServer() {
        return this.server.getObjectName();
    }

    public String getApplication() {
        if (this.application == null) {
            return null;
        }
        return this.application.getObjectName();
    }

    public String[] getJavaVMs() {
        return this.server.getJavaVMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getServlets() {
        Set<String> set = this.servletNames;
        synchronized (set) {
            return this.servletNames.toArray(new String[this.servletNames.size()]);
        }
    }

    @Override
    public ServletHandler getServletHandler() {
        return this.webAppContext.getServletHandler();
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"WebModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("WebModule object name j2eeType property must be 'WebModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("WebModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("WebModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServletHolder(ServletHolder servletHolder, String servletName, Set<String> servletMappings, String objectName) throws Exception {
        this.webAppContext.getServletHandler().addServlet(servletHolder);
        if (servletMappings != null) {
            for (String urlPattern : servletMappings) {
                ServletMapping servletMapping = new ServletMapping();
                servletMapping.setPathSpec(urlPattern);
                servletMapping.setServletName(servletName);
                this.webAppContext.getServletHandler().addServletMapping(servletMapping);
            }
        }
        if (objectName != null) {
            Set<String> set = this.servletNames;
            synchronized (set) {
                this.servletNames.add(objectName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterServletHolder(ServletHolder servletHolder, String servletName, Set<String> servletMappings, String objectName) throws Exception {
        if (objectName != null) {
            Set<String> set = this.servletNames;
            synchronized (set) {
                this.servletNames.remove(objectName);
            }
        }
    }
}

