/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.requestlog;

import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty7.JettyContainer;
import org.apache.geronimo.jetty7.requestlog.JettyRequestLog;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.eclipse.jetty.server.RequestLog;

public class NCSARequestLog
implements GBeanLifecycle,
JettyRequestLog {
    private final JettyContainer container;
    private final ServerInfo serverInfo;
    private final org.eclipse.jetty.server.NCSARequestLog requestLog;
    private boolean preferProxiedForAddress;
    private String filename;
    public static final GBeanInfo GBEAN_INFO;

    public NCSARequestLog(JettyContainer container, ServerInfo serverInfo) {
        this.container = container;
        this.serverInfo = serverInfo;
        this.requestLog = new org.eclipse.jetty.server.NCSARequestLog();
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setLogDateFormat(String format) {
        this.requestLog.setLogDateFormat(format);
    }

    public String getLogDateFormat() {
        return this.requestLog.getLogDateFormat();
    }

    public void setLogTimeZone(String tz) {
        this.requestLog.setLogTimeZone(tz);
    }

    public String getLogTimeZone() {
        return this.requestLog.getLogTimeZone();
    }

    public int getRetainDays() {
        return this.requestLog.getRetainDays();
    }

    public void setRetainDays(int retainDays) {
        this.requestLog.setRetainDays(retainDays);
    }

    public boolean isExtended() {
        return this.requestLog.isExtended();
    }

    public void setExtended(boolean e) {
        this.requestLog.setExtended(e);
    }

    public boolean isAppend() {
        return this.requestLog.isAppend();
    }

    public void setAppend(boolean a) {
        this.requestLog.setAppend(a);
    }

    public void setIgnorePaths(String[] ignorePaths) {
        this.requestLog.setIgnorePaths(ignorePaths);
    }

    public String[] getIgnorePaths() {
        return this.requestLog.getIgnorePaths();
    }

    public void setPreferProxiedForAddress(boolean value) {
        this.preferProxiedForAddress = value;
        this.requestLog.setPreferProxiedForAddress(value);
    }

    public boolean isPreferProxiedForAddress() {
        return this.preferProxiedForAddress;
    }

    public String getAbsoluteFilePath() {
        return this.requestLog == null ? null : this.requestLog.getDatedFilename();
    }

    public void doStart() throws Exception {
        this.requestLog.setFilename(this.serverInfo.resolveServerPath(this.filename));
        this.container.setRequestLog((RequestLog)this.requestLog);
        this.requestLog.start();
    }

    public void doStop() throws Exception {
        this.container.setRequestLog(null);
    }

    public void doFail() {
        this.container.setRequestLog(null);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"NCSA Request Log", NCSARequestLog.class);
        infoFactory.addReference("JettyContainer", JettyContainer.class, "GBean");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addInterface(JettyRequestLog.class, new String[]{"filename", "logDateFormat", "logTimeZone", "retainDays", "extended", "append", "ignorePaths", "preferProxiedForAddress"});
        infoFactory.setConstructor(new String[]{"JettyContainer", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

