/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.cluster;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.jetty7.AbstractPreHandler;
import org.apache.geronimo.jetty7.PreHandler;
import org.apache.geronimo.jetty7.cluster.ClusteredSessionManager;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.session.SessionHandler;

public class ClusteredSessionHandler
extends SessionHandler {
    private final PreHandler chainedHandler;

    public ClusteredSessionHandler(ClusteredSessionManager sessionManager, PreHandler chainedHandler) {
        if (null == chainedHandler) {
            throw new IllegalArgumentException("chainedHandler is required");
        }
        this.chainedHandler = chainedHandler;
        chainedHandler.setNextHandler((Handler)new ActualHandler());
        this.setSessionManager((SessionManager)sessionManager);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.setRequestedId(baseRequest, request);
        try {
            this.chainedHandler.handle(target, baseRequest, request, response);
        }
        catch (ServletException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    protected void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        super.handle(target, baseRequest, request, response);
    }

    private class ActualHandler
    extends AbstractPreHandler {
        private ActualHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ClusteredSessionHandler.this.doHandle(target, baseRequest, request, response);
        }
    }
}

