/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedWebApp;
import org.apache.geronimo.jetty7.DefaultServletHolderWrapper;
import org.apache.geronimo.jetty7.FilterHolderWrapper;
import org.apache.geronimo.jetty7.Host;
import org.apache.geronimo.jetty7.JettyFilterMapping;
import org.apache.geronimo.jetty7.JspServletHolderWrapper;
import org.apache.geronimo.jetty7.ServletHolderWrapper;
import org.apache.geronimo.jetty7.WebAppContextWrapper;
import org.apache.geronimo.jetty7.security.AuthConfigProviderHandlerFactory;
import org.apache.geronimo.jetty7.security.BuiltInAuthMethod;
import org.apache.geronimo.jetty7.security.JettySecurityHandlerFactory;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.naming.deployment.GBeanResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.schema.ElementConverter;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.web.deployment.GenericToSpecificPlanConverter;
import org.apache.geronimo.web25.deployment.AbstractWebModuleBuilder;
import org.apache.geronimo.web25.deployment.security.AuthenticationWrapper;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiAuthModuleType;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiConfigProviderType;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiServerAuthConfigType;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiServerAuthContextType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.geronimo.web.jetty.JettyAuthenticationType;
import org.apache.geronimo.xbeans.geronimo.web.jetty.JettyWebAppDocument;
import org.apache.geronimo.xbeans.geronimo.web.jetty.JettyWebAppType;
import org.apache.geronimo.xbeans.geronimo.web.jetty.config.GerJettyDocument;
import org.apache.geronimo.xbeans.javaee.DispatcherType;
import org.apache.geronimo.xbeans.javaee.ErrorPageType;
import org.apache.geronimo.xbeans.javaee.FilterMappingType;
import org.apache.geronimo.xbeans.javaee.FilterType;
import org.apache.geronimo.xbeans.javaee.FormLoginConfigType;
import org.apache.geronimo.xbeans.javaee.JspConfigType;
import org.apache.geronimo.xbeans.javaee.ListenerType;
import org.apache.geronimo.xbeans.javaee.LocaleEncodingMappingListType;
import org.apache.geronimo.xbeans.javaee.LocaleEncodingMappingType;
import org.apache.geronimo.xbeans.javaee.LoginConfigType;
import org.apache.geronimo.xbeans.javaee.MimeMappingType;
import org.apache.geronimo.xbeans.javaee.ParamValueType;
import org.apache.geronimo.xbeans.javaee.ServletMappingType;
import org.apache.geronimo.xbeans.javaee.ServletType;
import org.apache.geronimo.xbeans.javaee.TaglibType;
import org.apache.geronimo.xbeans.javaee.UrlPatternType;
import org.apache.geronimo.xbeans.javaee.WebAppDocument;
import org.apache.geronimo.xbeans.javaee.WebAppType;
import org.apache.geronimo.xbeans.javaee.WelcomeFileListType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyModuleBuilder
extends AbstractWebModuleBuilder
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(JettyModuleBuilder.class);
    static final String ROLE_MAPPER_DATA_NAME = "roleMapperDataName";
    private static final Map<String, String> NAMESPACE_UPDATES = new HashMap<String, String>();
    private static final Map<String, ElementConverter> GERONIMO_SCHEMA_CONVERSIONS = new HashMap<String, ElementConverter>();
    private static final String JASPI_NAMESPACE = "http://geronimo.apache.org/xml/ns/geronimo-jaspi";
    private final Environment defaultEnvironment;
    private final AbstractNameQuery jettyContainerObjectName;
    private final JspServletHolderWrapper jspServlet;
    private final Collection defaultServlets;
    private final Collection defaultFilters;
    private final Collection defaultFilterMappings;
    private final GBeanData pojoWebServiceTemplate;
    protected final NamespaceDrivenBuilderCollection clusteringBuilders;
    private final List<String> defaultWelcomeFiles;
    private final Integer defaultSessionTimeoutSeconds;
    private final Map<String, String> defaultLocaleEncodingMappings;
    private final Map<String, String> defaultMimeTypeMappings;
    private static final String JETTY_NAMESPACE;
    public static final GBeanInfo GBEAN_INFO;

    public JettyModuleBuilder(Environment defaultEnvironment, Integer defaultSessionTimeoutSeconds, List<String> defaultWelcomeFiles, AbstractNameQuery jettyContainerName, JspServletHolderWrapper jspServlet, Collection defaultServlets, Collection defaultFilters, Collection defaultFilterMappings, Map<String, String> defaultLocaleEncodingMappings, Map<String, String> defaultMimeTypeMappings, Object pojoWebServiceTemplate, Collection<WebServiceBuilder> webServiceBuilder, Collection clusteringBuilders, Collection serviceBuilders, NamingBuilder namingBuilders, Collection<ModuleBuilderExtension> moduleBuilderExtensions, ResourceEnvironmentSetter resourceEnvironmentSetter, Kernel kernel) throws GBeanNotFoundException {
        super(kernel, serviceBuilders, namingBuilders, resourceEnvironmentSetter, webServiceBuilder, moduleBuilderExtensions);
        this.defaultEnvironment = defaultEnvironment;
        this.defaultSessionTimeoutSeconds = defaultSessionTimeoutSeconds == null ? 1800 : defaultSessionTimeoutSeconds;
        this.jettyContainerObjectName = jettyContainerName;
        this.jspServlet = jspServlet;
        this.defaultServlets = defaultServlets;
        this.defaultFilters = defaultFilters;
        this.defaultFilterMappings = defaultFilterMappings;
        this.pojoWebServiceTemplate = JettyModuleBuilder.getGBeanData(kernel, pojoWebServiceTemplate);
        this.clusteringBuilders = new NamespaceDrivenBuilderCollection(clusteringBuilders);
        this.defaultWelcomeFiles = defaultWelcomeFiles == null ? new ArrayList() : defaultWelcomeFiles;
        this.defaultLocaleEncodingMappings = defaultLocaleEncodingMappings == null ? new HashMap() : defaultLocaleEncodingMappings;
        this.defaultMimeTypeMappings = defaultMimeTypeMappings == null ? new HashMap() : defaultMimeTypeMappings;
    }

    public void doStart() throws Exception {
        XmlBeansUtil.registerNamespaceUpdates(NAMESPACE_UPDATES);
        SchemaConversionUtils.registerNamespaceConversions(GERONIMO_SCHEMA_CONVERSIONS);
    }

    public void doStop() {
        XmlBeansUtil.unregisterNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doFail() {
        this.doStop();
    }

    private static GBeanData getGBeanData(Kernel kernel, Object template) throws GBeanNotFoundException {
        if (template == null) {
            return null;
        }
        AbstractName templateName = kernel.getAbstractNameFor(template);
        return kernel.getGBeanData(templateName);
    }

    protected Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, boolean standAlone, String contextRoot, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        AbstractName moduleName;
        String warName;
        Boolean distributable;
        WebAppType webApp;
        String specDD;
        block14: {
            assert (moduleFile != null) : "moduleFile is null";
            assert (targetPath != null) : "targetPath is null";
            assert (!targetPath.endsWith("/")) : "targetPath must not end with a '/'";
            specDD = null;
            webApp = null;
            try {
                if (specDDUrl == null) {
                    specDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/web.xml");
                }
                specDD = DeploymentUtil.readAll((URL)specDDUrl);
                XmlObject parsed = XmlBeansUtil.parse((String)specDD);
                WebAppDocument webAppDoc = this.convertToServletSchema(parsed);
                webApp = webAppDoc.getWebApp();
                JettyModuleBuilder.check((WebAppType)webApp);
            }
            catch (XmlException e) {
                throw new DeploymentException("Error parsing web.xml for " + targetPath, (Throwable)e);
            }
            catch (Exception e) {
                if (!moduleFile.getName().endsWith(".war")) {
                    return null;
                }
                if (!(e instanceof FileNotFoundException)) break block14;
                log.warn("Web application " + targetPath + " does not contain a WEB-INF/web.xml. This may indicate a mis-assembled web app.");
            }
        }
        if (webApp == null) {
            webApp = WebAppType.Factory.newInstance();
        }
        JettyWebAppType jettyWebApp = this.getJettyWebApp(plan, moduleFile, standAlone, targetPath, webApp);
        contextRoot = this.getContextRoot(jettyWebApp, contextRoot, webApp, standAlone, moduleFile, targetPath);
        EnvironmentType environmentType = jettyWebApp.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        Boolean bl = distributable = webApp.getDistributableArray().length == 1 ? Boolean.TRUE : Boolean.FALSE;
        if (Boolean.TRUE == distributable) {
            this.clusteringBuilders.buildEnvironment((XmlObject)jettyWebApp, environment);
        }
        if ((warName = new File(moduleFile.getName()).getName()).lastIndexOf(46) > -1) {
            warName = warName.substring(0, warName.lastIndexOf(46));
        }
        idBuilder.resolve(environment, warName, "war");
        if (earName == null) {
            earName = naming.createRootName(environment.getConfigId(), "null", "J2EEApplication");
            moduleName = naming.createChildName(earName, environment.getConfigId().toString(), "WebModule");
        } else {
            moduleName = naming.createChildName(earName, targetPath, "WebModule");
        }
        AnnotatedWebApp annotatedWebApp = new AnnotatedWebApp(webApp);
        WebModule module = new WebModule(standAlone, moduleName, environment, moduleFile, targetPath, (XmlObject)webApp, (XmlObject)jettyWebApp, specDD, contextRoot, JETTY_NAMESPACE, annotatedWebApp);
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.createModule((Module)module, plan, moduleFile, targetPath, specDDUrl, environment, (Object)contextRoot, earName, naming, idBuilder);
        }
        return module;
    }

    String getContextRoot(JettyWebAppType jettyWebApp, String contextRoot, WebAppType webApp, boolean standAlone, JarFile moduleFile, String targetPath) {
        if (jettyWebApp.isSetContextRoot()) {
            contextRoot = jettyWebApp.getContextRoot();
        } else if (contextRoot == null || contextRoot.trim().equals("")) {
            contextRoot = this.determineDefaultContextRoot(webApp, standAlone, moduleFile, targetPath);
        }
        contextRoot = contextRoot.trim();
        return contextRoot;
    }

    JettyWebAppType getJettyWebApp(Object plan, JarFile moduleFile, boolean standAlone, String targetPath, WebAppType webApp) throws DeploymentException {
        XmlObject rawPlan = null;
        try {
            JettyWebAppType jettyWebApp;
            block12: {
                try {
                    if (plan instanceof XmlObject) {
                        rawPlan = (XmlObject)plan;
                        break block12;
                    }
                    if (plan != null) {
                        rawPlan = XmlBeansUtil.parse((URL)((File)plan).toURL(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                        break block12;
                    }
                    URL path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/geronimo-web.xml");
                    try {
                        rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                    }
                    catch (FileNotFoundException e) {
                        path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/geronimo-jetty.xml");
                        try {
                            rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                        }
                        catch (FileNotFoundException e1) {
                            log.warn("Web application " + targetPath + " does not contain a WEB-INF/geronimo-web.xml deployment plan.  This may or may not be a problem, depending on whether you have things like resource references that need to be resolved.  You can also give the deployer a separate deployment plan file on the command line.");
                        }
                    }
                }
                catch (IOException e) {
                    log.warn("Failed to load geronimo-web.xml", (Throwable)e);
                }
            }
            if (rawPlan != null) {
                XmlObject webPlan = new GenericToSpecificPlanConverter(GerJettyDocument.type.getDocumentElementName().getNamespaceURI(), JettyWebAppDocument.type.getDocumentElementName().getNamespaceURI(), "jetty").convertToSpecificPlan(rawPlan);
                jettyWebApp = (JettyWebAppType)webPlan.changeType(JettyWebAppType.type);
                XmlBeansUtil.validateDD((XmlObject)jettyWebApp);
            } else {
                jettyWebApp = this.createDefaultPlan();
            }
            return jettyWebApp;
        }
        catch (XmlException e) {
            throw new DeploymentException("xml problem for web app " + targetPath, (Throwable)e);
        }
    }

    private JettyWebAppType createDefaultPlan() {
        return JettyWebAppType.Factory.newInstance();
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        JettyWebAppType gerWebApp = (JettyWebAppType)module.getVendorDD();
        boolean hasSecurityRealmName = gerWebApp.isSetSecurityRealmName();
        this.basicInitContext(earContext, module, gerWebApp, hasSecurityRealmName);
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.initContext(earContext, module, cl);
        }
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl, Collection repository) throws DeploymentException {
        EARContext moduleContext = module.getEarContext();
        AbstractName moduleName = moduleContext.getModuleName();
        WebModule webModule = (WebModule)module;
        WebAppType webApp = (WebAppType)webModule.getSpecDD();
        JettyWebAppType jettyWebApp = (JettyWebAppType)webModule.getVendorDD();
        GBeanData webModuleData = new GBeanData(moduleName, WebAppContextWrapper.class);
        this.configureBasicWebModuleAttributes(webApp, jettyWebApp, moduleContext, earContext, webModule, webModuleData);
        GBeanResourceEnvironmentBuilder rebuilder = new GBeanResourceEnvironmentBuilder(webModuleData);
        this.resourceEnvironmentSetter.setResourceEnvironment((ResourceEnvironmentBuilder)rebuilder, (XmlObject[])webApp.getResourceRefArray(), jettyWebApp.getResourceRefArray());
        try {
            GBeanData jspServletData;
            moduleContext.addGBean(webModuleData);
            this.configureHosts(earContext, jettyWebApp, webModuleData);
            String contextPath = webModule.getContextRoot();
            if (contextPath == null) {
                throw new DeploymentException("null contextPath");
            }
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            webModuleData.setAttribute("contextPath", (Object)contextPath);
            if (jettyWebApp.isSetWorkDir()) {
                String workDir = jettyWebApp.getWorkDir();
                webModuleData.setAttribute("workDir", (Object)workDir);
            }
            if (jettyWebApp.isSetWebContainer()) {
                AbstractNameQuery webContainerName = ENCConfigBuilder.getGBeanQuery((String)"GBean", (GerGbeanLocatorType)jettyWebApp.getWebContainer());
                webModuleData.setReferencePattern("JettyContainer", webContainerName);
            } else {
                webModuleData.setReferencePattern("JettyContainer", this.jettyContainerObjectName);
            }
            if (webApp.getDisplayNameArray().length > 0) {
                webModuleData.setAttribute("displayName", (Object)webApp.getDisplayNameArray()[0].getStringValue());
            }
            this.configureContextParams(webApp, webModuleData);
            this.configureListeners(webApp, webModuleData);
            webModuleData.setAttribute("sessionTimeoutSeconds", (Object)(webApp.getSessionConfigArray().length == 1 && webApp.getSessionConfigArray(0).getSessionTimeout() != null ? webApp.getSessionConfigArray(0).getSessionTimeout().getBigIntegerValue().intValue() * 60 : this.defaultSessionTimeoutSeconds));
            Boolean distributable = webApp.getDistributableArray().length == 1 ? Boolean.TRUE : Boolean.FALSE;
            webModuleData.setAttribute("distributable", (Object)distributable);
            if (Boolean.TRUE == distributable) {
                this.clusteringBuilders.build((XmlObject)jettyWebApp, (DeploymentContext)earContext, (DeploymentContext)moduleContext);
                if (webModuleData.getReferencePatterns("SessionHandlerFactory") == null) {
                    log.warn("No clustering builders configured: app will not be clustered");
                    this.configureNoClustering(moduleContext, webModuleData);
                }
            } else {
                this.configureNoClustering(moduleContext, webModuleData);
            }
            this.configureMimeMappings(webApp, webModuleData);
            this.configureWelcomeFileLists(webApp, webModuleData);
            this.configureLocaleEncodingMappingLists(webApp, webModuleData);
            this.configureErrorPages(webApp, webModuleData);
            HashSet<String> knownServletMappings = new HashSet<String>();
            HashSet<String> knownJspMappings = new HashSet<String>();
            HashMap<String, Set<String>> servletMappings = new HashMap<String, Set<String>>();
            if (this.jspServlet != null) {
                this.configureTagLibs(module, webApp, webModuleData, servletMappings, knownJspMappings, this.jspServlet.getServletName());
                jspServletData = this.configureDefaultServlet(this.jspServlet, earContext, moduleName, knownJspMappings);
                knownServletMappings.addAll(knownJspMappings);
                module.getSharedContext().put(DEFAULT_JSP_SERVLET_KEY, jspServletData);
            }
            this.configureAuthentication(module, webApp, jettyWebApp, webModuleData);
            this.buildServletMappings(module, webApp, servletMappings, knownServletMappings);
            if (this.jspServlet != null) {
                jspServletData = (GBeanData)module.getSharedContext().get(DEFAULT_JSP_SERVLET_KEY);
                Set jspMappings = (Set)jspServletData.getAttribute("servletMappings");
                jspMappings.removeAll(knownServletMappings);
                jspMappings.addAll(knownJspMappings);
                jspServletData.setAttribute("servletMappings", (Object)jspMappings);
            }
            AbstractName previous = null;
            if (this.defaultFilters != null) {
                previous = this.addDefaultFiltersGBeans(earContext, moduleContext, moduleName, previous);
            }
            this.addFilterMappingsGBeans(earContext, moduleContext, moduleName, webApp, previous);
            this.addFiltersGBeans(earContext, moduleContext, moduleName, webApp);
            if (this.defaultServlets != null) {
                this.addDefaultServletsGBeans(earContext, moduleContext, moduleName, knownServletMappings);
            }
            ServletType[] servletTypes = webApp.getServletArray();
            this.addServlets(moduleName, (Module)webModule, servletTypes, servletMappings, moduleContext);
            if (jettyWebApp.isSetSecurityRealmName()) {
                this.configureSecurityRealm(earContext, webApp, jettyWebApp, webModuleData);
            }
            if (jettyWebApp.getCompactPath()) {
                webModuleData.setAttribute("compactPath", (Object)Boolean.TRUE);
            }
            for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
                mbe.addGBeans(earContext, module, cl, repository);
            }
            if (!webApp.getMetadataComplete()) {
                webApp.setMetadataComplete(true);
                module.setOriginalSpecDD(module.getSpecDD().toString());
            }
            webModuleData.setAttribute("deploymentDescriptor", (Object)module.getOriginalSpecDD());
            if (!module.isStandAlone()) {
                ConfigurationData moduleConfigurationData = moduleContext.getConfigurationData();
                earContext.addChildConfiguration(module.getTargetPath(), moduleConfigurationData);
            }
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize webapp GBean for " + module.getName(), (Throwable)e);
        }
    }

    private void configureNoClustering(EARContext moduleContext, GBeanData webModuleData) throws GBeanAlreadyExistsException {
    }

    private void configureSecurityRealm(EARContext earContext, WebAppType webApp, JettyWebAppType jettyWebApp, GBeanData webModuleData) throws DeploymentException {
        AbstractName moduleName = webModuleData.getAbstractName();
        if (earContext.getSecurityConfiguration() == null) {
            throw new DeploymentException("You have specified a <security-realm-name> for the webapp " + moduleName + " but no <security> configuration (role mapping) is supplied in the Geronimo plan for the web application (or the Geronimo plan for the EAR if the web app is in an EAR)");
        }
        String securityRealmName = jettyWebApp.getSecurityRealmName().trim();
        webModuleData.setAttribute("securityRealmName", (Object)securityRealmName);
        webModuleData.setReferencePattern("RunAsSource", (AbstractNameQuery)earContext.getGeneralData().get(ROLE_MAPPER_DATA_NAME));
        String policyContextID = moduleName.toString().replaceAll("[, :]", "_");
        webModuleData.setAttribute("policyContextID", (Object)policyContextID);
        ComponentPermissions componentPermissions = this.buildSpecSecurityConfig(webApp);
        earContext.addSecurityContext(policyContextID, (Object)componentPermissions);
    }

    private void addDefaultServletsGBeans(EARContext earContext, EARContext moduleContext, AbstractName moduleName, Set knownServletMappings) throws GBeanNotFoundException, GBeanAlreadyExistsException {
        for (Object defaultServlet : this.defaultServlets) {
            GBeanData servletGBeanData = this.configureDefaultServlet(defaultServlet, earContext, moduleName, knownServletMappings);
            moduleContext.addGBean(servletGBeanData);
        }
    }

    private GBeanData configureDefaultServlet(Object defaultServlet, EARContext earContext, AbstractName moduleName, Set knownServletMappings) throws GBeanNotFoundException, GBeanAlreadyExistsException {
        GBeanData servletGBeanData = JettyModuleBuilder.getGBeanData(this.kernel, defaultServlet);
        AbstractName defaultServletObjectName = earContext.getNaming().createChildName(moduleName, (String)servletGBeanData.getAttribute("servletName"), "Servlet");
        servletGBeanData.setAbstractName(defaultServletObjectName);
        servletGBeanData.setReferencePattern("JettyServletRegistration", moduleName);
        HashSet defaultServletMappings = new HashSet((Collection)servletGBeanData.getAttribute("servletMappings"));
        defaultServletMappings.removeAll(knownServletMappings);
        servletGBeanData.setAttribute("servletMappings", defaultServletMappings);
        return servletGBeanData;
    }

    private void addFiltersGBeans(EARContext earContext, EARContext moduleContext, AbstractName moduleName, WebAppType webApp) throws GBeanAlreadyExistsException {
        FilterType[] filterArray;
        for (FilterType filterType : filterArray = webApp.getFilterArray()) {
            ParamValueType[] initParamArray;
            String filterName = filterType.getFilterName().getStringValue().trim();
            AbstractName filterAbstractName = earContext.getNaming().createChildName(moduleName, filterName, "WebFilter");
            GBeanData filterData = new GBeanData(filterAbstractName, FilterHolderWrapper.GBEAN_INFO);
            filterData.setAttribute("filterName", (Object)filterName);
            filterData.setAttribute("filterClass", (Object)filterType.getFilterClass().getStringValue().trim());
            HashMap<String, String> initParams = new HashMap<String, String>();
            for (ParamValueType paramValueType : initParamArray = filterType.getInitParamArray()) {
                initParams.put(paramValueType.getParamName().getStringValue().trim(), paramValueType.getParamValue().getStringValue().trim());
            }
            filterData.setAttribute("initParams", initParams);
            filterData.setReferencePattern("JettyServletRegistration", moduleName);
            moduleContext.addGBean(filterData);
        }
    }

    private void addFilterMappingsGBeans(EARContext earContext, EARContext moduleContext, AbstractName moduleName, WebAppType webApp, AbstractName previous) throws GBeanAlreadyExistsException {
        FilterMappingType[] filterMappingArray;
        for (FilterMappingType filterMappingType : filterMappingArray = webApp.getFilterMappingArray()) {
            int j;
            String filterName = filterMappingType.getFilterName().getStringValue().trim();
            GBeanData filterMappingData = new GBeanData(JettyFilterMapping.class);
            if (previous != null) {
                filterMappingData.addDependency(previous);
            }
            filterMappingData.setReferencePattern("JettyServletRegistration", moduleName);
            AbstractName filterAbstractName = earContext.getNaming().createChildName(moduleName, filterName, "WebFilter");
            AbstractName filterMappingName = null;
            if (filterMappingType.sizeOfUrlPatternArray() > 0) {
                Object[] urlPatterns = new String[filterMappingType.sizeOfUrlPatternArray()];
                for (j = 0; j < urlPatterns.length; ++j) {
                    urlPatterns[j] = filterMappingType.getUrlPatternArray(j).getStringValue().trim();
                }
                filterMappingData.setAttribute("urlPatterns", (Object)urlPatterns);
                filterMappingName = earContext.getNaming().createChildName(filterAbstractName, ObjectName.quote(Arrays.deepToString(urlPatterns)), "URLWebFilterMapping");
            }
            if (filterMappingType.sizeOfServletNameArray() > 0) {
                HashSet<AbstractName> servletNameSet = new HashSet<AbstractName>();
                for (j = 0; j < filterMappingType.sizeOfServletNameArray(); ++j) {
                    String servletName = filterMappingType.getServletNameArray(j).getStringValue().trim();
                    AbstractName abstractServletName = earContext.getNaming().createChildName(moduleName, servletName, "Servlet");
                    servletNameSet.add(abstractServletName);
                    filterMappingData.addDependency(abstractServletName);
                }
                filterMappingData.setReferencePatterns("Servlets", servletNameSet);
                filterMappingName = earContext.getNaming().createChildName(filterAbstractName, ObjectName.quote(Arrays.deepToString(servletNameSet.toArray())), "ServletWebFilterMapping");
            }
            filterMappingData.setAbstractName(filterMappingName);
            previous = filterMappingName;
            boolean request = filterMappingType.getDispatcherArray().length == 0;
            boolean forward = false;
            boolean include = false;
            boolean error = false;
            for (int j2 = 0; j2 < filterMappingType.getDispatcherArray().length; ++j2) {
                DispatcherType dispatcherType = filterMappingType.getDispatcherArray()[j2];
                if (dispatcherType.getStringValue().equals("REQUEST")) {
                    request = true;
                    continue;
                }
                if (dispatcherType.getStringValue().equals("FORWARD")) {
                    forward = true;
                    continue;
                }
                if (dispatcherType.getStringValue().equals("INCLUDE")) {
                    include = true;
                    continue;
                }
                if (!dispatcherType.getStringValue().equals("ERROR")) continue;
                error = true;
            }
            filterMappingData.setAttribute("requestDispatch", (Object)request);
            filterMappingData.setAttribute("forwardDispatch", (Object)forward);
            filterMappingData.setAttribute("includeDispatch", (Object)include);
            filterMappingData.setAttribute("errorDispatch", (Object)error);
            filterMappingData.setReferencePattern("Filter", filterAbstractName);
            moduleContext.addGBean(filterMappingData);
        }
    }

    private AbstractName addDefaultFiltersGBeans(EARContext earContext, EARContext moduleContext, AbstractName moduleName, AbstractName previous) throws GBeanNotFoundException, GBeanAlreadyExistsException {
        for (Object defaultFilter : this.defaultFilters) {
            GBeanData filterGBeanData = JettyModuleBuilder.getGBeanData(this.kernel, defaultFilter);
            String filterName = (String)filterGBeanData.getAttribute("filterName");
            AbstractName defaultFilterAbstractName = earContext.getNaming().createChildName(moduleName, filterName, "WebFilter");
            filterGBeanData.setAbstractName(defaultFilterAbstractName);
            filterGBeanData.setReferencePattern("JettyServletRegistration", moduleName);
            moduleContext.addGBean(filterGBeanData);
            GBeanData filterMappingGBeanData = new GBeanData(JettyFilterMapping.class);
            if (previous != null) {
                filterMappingGBeanData.addDependency(previous);
            }
            filterMappingGBeanData.setReferencePattern("JettyServletRegistration", moduleName);
            String urlPattern = "/*";
            filterMappingGBeanData.setAttribute("urlPattern", (Object)urlPattern);
            AbstractName filterMappingName = earContext.getNaming().createChildName(defaultFilterAbstractName, urlPattern, "URLWebFilterMapping");
            filterMappingGBeanData.setAbstractName(filterMappingName);
            previous = filterMappingName;
            filterMappingGBeanData.setAttribute("requestDispatch", (Object)Boolean.TRUE);
            filterMappingGBeanData.setAttribute("forwardDispatch", (Object)Boolean.TRUE);
            filterMappingGBeanData.setAttribute("includeDispatch", (Object)Boolean.TRUE);
            filterMappingGBeanData.setAttribute("errorDispatch", (Object)Boolean.FALSE);
            filterMappingGBeanData.setReferencePattern("Filter", defaultFilterAbstractName);
            moduleContext.addGBean(filterMappingGBeanData);
        }
        return previous;
    }

    private void buildServletMappings(Module module, WebAppType webApp, Map<String, Set<String>> servletMappings, Set<String> knownServletMappings) throws DeploymentException {
        ServletMappingType[] servletMappingArray;
        ServletType[] servletTypes = webApp.getServletArray();
        HashSet<String> knownServlets = new HashSet<String>();
        for (ServletType type : servletTypes) {
            knownServlets.add(type.getServletName().getStringValue().trim());
        }
        for (ServletMappingType servletMappingType : servletMappingArray = webApp.getServletMappingArray()) {
            String servletName = servletMappingType.getServletName().getStringValue().trim();
            if (!knownServlets.contains(servletName)) {
                throw new DeploymentException("Web app " + module.getName() + " contains a servlet mapping that refers to servlet '" + servletName + "' but no such servlet was found!");
            }
            UrlPatternType[] urlPatterns = servletMappingType.getUrlPatternArray();
            this.addMappingsForServlet(servletName, urlPatterns, knownServletMappings, servletMappings);
        }
    }

    private void addMappingsForServlet(String servletName, UrlPatternType[] urlPatterns, Set<String> knownServletMappings, Map<String, Set<String>> servletMappings) throws DeploymentException {
        for (UrlPatternType patternType : urlPatterns) {
            String urlPattern = patternType.getStringValue().trim();
            if (!urlPattern.startsWith("*") && !urlPattern.startsWith("/")) {
                urlPattern = "/" + urlPattern;
            }
            if (knownServletMappings.contains(urlPattern)) continue;
            knownServletMappings.add(urlPattern);
            JettyModuleBuilder.checkString((String)urlPattern);
            Set<String> urlsForServlet = servletMappings.get(servletName);
            if (urlsForServlet == null) {
                urlsForServlet = new HashSet<String>();
                servletMappings.put(servletName, urlsForServlet);
            }
            urlsForServlet.add(urlPattern);
        }
    }

    private void configureAuthentication(Module module, WebAppType webApp, JettyWebAppType jettyWebApp, GBeanData webModuleData) throws DeploymentException, GBeanAlreadyExistsException {
        EARContext moduleContext = module.getEarContext();
        LoginConfigType[] loginConfigArray = webApp.getLoginConfigArray();
        if (loginConfigArray.length > 1) {
            throw new DeploymentException("Web app " + module.getName() + " cannot have more than one login-config element.  Currently has " + loginConfigArray.length + " login-config elements.");
        }
        JettyAuthenticationType authType = jettyWebApp.getAuthentication();
        if (loginConfigArray.length == 1 || authType != null || jettyWebApp.isSetSecurityRealmName()) {
            AbstractName factoryName = moduleContext.getNaming().createChildName(module.getModuleName(), "securityHandlerFactory", "GBean");
            webModuleData.setReferencePattern("SecurityHandlerFactory", factoryName);
            if (authType != null) {
                GBeanData securityFactoryData = new GBeanData(factoryName, AuthConfigProviderHandlerFactory.class);
                securityFactoryData.setAttribute("messageLayer", (Object)"HttpServlet");
                String contextPath = (String)webModuleData.getAttribute("contextPath");
                securityFactoryData.setAttribute("appContext", (Object)("server " + contextPath));
                this.configureConfigurationFactory(jettyWebApp, null, securityFactoryData);
                moduleContext.addGBean(securityFactoryData);
                this.configureLocalJaspicProvider(new JettyAuthenticationWrapper(authType), contextPath, module, securityFactoryData);
            } else {
                LoginConfigType loginConfig = loginConfigArray.length == 1 ? loginConfigArray[0] : null;
                GBeanData securityFactoryData = new GBeanData(factoryName, JettySecurityHandlerFactory.class);
                this.configureConfigurationFactory(jettyWebApp, loginConfig, securityFactoryData);
                BuiltInAuthMethod auth = BuiltInAuthMethod.NONE;
                if (loginConfig != null) {
                    if (loginConfig.isSetAuthMethod()) {
                        String authMethod = loginConfig.getAuthMethod().getStringValue().trim();
                        auth = BuiltInAuthMethod.getValueOf((String)authMethod);
                        if (auth == BuiltInAuthMethod.BASIC) {
                            securityFactoryData.setAttribute("realmName", (Object)loginConfig.getRealmName().getStringValue().trim());
                        } else if (auth == BuiltInAuthMethod.DIGEST) {
                            securityFactoryData.setAttribute("realmName", (Object)loginConfig.getRealmName().getStringValue().trim());
                        } else if (auth == BuiltInAuthMethod.FORM) {
                            if (loginConfig.isSetFormLoginConfig()) {
                                FormLoginConfigType formLoginConfig = loginConfig.getFormLoginConfig();
                                securityFactoryData.setAttribute("loginPage", (Object)formLoginConfig.getFormLoginPage().getStringValue());
                                securityFactoryData.setAttribute("errorPage", (Object)formLoginConfig.getFormErrorPage().getStringValue());
                            }
                        } else if (auth != BuiltInAuthMethod.CLIENTCERT) {
                            throw new DeploymentException("unrecognized auth method, use jaspi to configure: " + authMethod);
                        }
                    } else {
                        throw new DeploymentException("No auth method configured and no jaspi configured");
                    }
                    if (loginConfig.isSetRealmName()) {
                        webModuleData.setAttribute("realmName", (Object)loginConfig.getRealmName().getStringValue());
                    }
                }
                securityFactoryData.setAttribute("authMethod", (Object)auth);
                moduleContext.addGBean(securityFactoryData);
            }
        }
    }

    private void configureConfigurationFactory(JettyWebAppType jettyWebApp, LoginConfigType loginConfig, GBeanData securityFactoryData) {
        String securityRealmName;
        if (jettyWebApp.isSetSecurityRealmName()) {
            securityRealmName = jettyWebApp.getSecurityRealmName().trim();
        } else {
            if (loginConfig == null) {
                return;
            }
            securityRealmName = loginConfig.getRealmName().getStringValue().trim();
        }
        AbstractNameQuery configurationFactoryName = new AbstractNameQuery(null, Collections.singletonMap("name", securityRealmName), ConfigurationFactory.class.getName());
        securityFactoryData.setReferencePattern("ConfigurationFactory", configurationFactoryName);
    }

    private void configureTagLibs(Module module, WebAppType webApp, GBeanData webModuleData, Map<String, Set<String>> servletMappings, Set<String> knownServletMappings, String jspServletName) throws DeploymentException {
        JspConfigType[] jspConfigArray = webApp.getJspConfigArray();
        if (jspConfigArray.length > 1) {
            throw new DeploymentException("Web app " + module.getName() + " cannot have more than one jsp-config element.  Currently has " + jspConfigArray.length + " jsp-config elements.");
        }
        HashMap<String, String> tagLibMap = new HashMap<String, String>();
        for (JspConfigType aJspConfigArray : jspConfigArray) {
            TaglibType[] tagLibArray;
            for (TaglibType taglibType : tagLibArray = aJspConfigArray.getTaglibArray()) {
                tagLibMap.put(taglibType.getTaglibUri().getStringValue().trim(), taglibType.getTaglibLocation().getStringValue().trim());
            }
            for (TaglibType taglibType : aJspConfigArray.getJspPropertyGroupArray()) {
                UrlPatternType[] urlPatterns = taglibType.getUrlPatternArray();
                this.addMappingsForServlet(jspServletName, urlPatterns, knownServletMappings, servletMappings);
            }
        }
        webModuleData.setAttribute("tagLibMap", tagLibMap);
    }

    private void configureErrorPages(WebAppType webApp, GBeanData webModuleData) {
        ErrorPageType[] errorPageArray = webApp.getErrorPageArray();
        HashMap<String, String> errorPageMap = new HashMap<String, String>();
        for (ErrorPageType errorPageType : errorPageArray) {
            if (errorPageType.isSetErrorCode()) {
                errorPageMap.put(errorPageType.getErrorCode().getStringValue().trim(), errorPageType.getLocation().getStringValue().trim());
                continue;
            }
            errorPageMap.put(errorPageType.getExceptionType().getStringValue().trim(), errorPageType.getLocation().getStringValue().trim());
        }
        webModuleData.setAttribute("errorPages", errorPageMap);
    }

    private void configureLocaleEncodingMappingLists(WebAppType webApp, GBeanData webModuleData) {
        LocaleEncodingMappingListType[] localeEncodingMappingListArray = webApp.getLocaleEncodingMappingListArray();
        HashMap<String, String> localeEncodingMappingMap = new HashMap<String, String>(this.defaultLocaleEncodingMappings);
        for (LocaleEncodingMappingListType aLocaleEncodingMappingListArray : localeEncodingMappingListArray) {
            LocaleEncodingMappingType[] localeEncodingMappingArray;
            for (LocaleEncodingMappingType localeEncodingMapping : localeEncodingMappingArray = aLocaleEncodingMappingListArray.getLocaleEncodingMappingArray()) {
                localeEncodingMappingMap.put(localeEncodingMapping.getLocale().trim(), localeEncodingMapping.getEncoding().trim());
            }
        }
        webModuleData.setAttribute("localeEncodingMapping", localeEncodingMappingMap);
    }

    private void configureWelcomeFileLists(WebAppType webApp, GBeanData webModuleData) {
        ArrayList<Object> welcomeFiles;
        WelcomeFileListType[] welcomeFileArray = webApp.getWelcomeFileListArray();
        if (welcomeFileArray.length > 0) {
            welcomeFiles = new ArrayList();
            for (WelcomeFileListType aWelcomeFileArray : welcomeFileArray) {
                String[] welcomeFileListType;
                for (String welcomeFile : welcomeFileListType = aWelcomeFileArray.getWelcomeFileArray()) {
                    welcomeFiles.add(welcomeFile.trim());
                }
            }
        } else {
            welcomeFiles = new ArrayList<String>(this.defaultWelcomeFiles);
        }
        webModuleData.setAttribute("welcomeFiles", (Object)welcomeFiles.toArray(new String[welcomeFiles.size()]));
    }

    private void configureMimeMappings(WebAppType webApp, GBeanData webModuleData) {
        MimeMappingType[] mimeMappingArray = webApp.getMimeMappingArray();
        HashMap<String, String> mimeMappingMap = new HashMap<String, String>(this.defaultMimeTypeMappings);
        for (MimeMappingType mimeMappingType : mimeMappingArray) {
            mimeMappingMap.put(mimeMappingType.getExtension().getStringValue().trim(), mimeMappingType.getMimeType().getStringValue().trim());
        }
        webModuleData.setAttribute("mimeMap", mimeMappingMap);
    }

    private void configureListeners(WebAppType webApp, GBeanData webModuleData) {
        ListenerType[] listenerArray = webApp.getListenerArray();
        ArrayList<String> listeners = new ArrayList<String>();
        for (ListenerType listenerType : listenerArray) {
            listeners.add(listenerType.getListenerClass().getStringValue().trim());
        }
        webModuleData.setAttribute("listenerClassNames", listeners);
    }

    private void configureContextParams(WebAppType webApp, GBeanData webModuleData) {
        ParamValueType[] contextParamArray = webApp.getContextParamArray();
        HashMap<String, String> contextParams = new HashMap<String, String>();
        for (ParamValueType contextParam : contextParamArray) {
            contextParams.put(contextParam.getParamName().getStringValue().trim(), contextParam.getParamValue().getStringValue().trim());
        }
        webModuleData.setAttribute("contextParamMap", contextParams);
    }

    private void configureHosts(EARContext earContext, JettyWebAppType jettyWebApp, GBeanData webModuleData) throws GBeanAlreadyExistsException {
        String[] hosts = jettyWebApp.getHostArray();
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hosts[i].trim();
        }
        String[] virtualHosts = jettyWebApp.getVirtualHostArray();
        for (int i = 0; i < virtualHosts.length; ++i) {
            virtualHosts[i] = virtualHosts[i].trim();
        }
        if (hosts.length > 0 || virtualHosts.length > 0) {
            AbstractName hostName = earContext.getNaming().createChildName(webModuleData.getAbstractName(), "Host", "Host");
            GBeanData hostData = new GBeanData(hostName, Host.class);
            hostData.setAttribute("hosts", (Object)hosts);
            hostData.setAttribute("virtualHosts", (Object)virtualHosts);
            earContext.addGBean(hostData);
            webModuleData.setReferencePattern("Host", hostName);
        }
    }

    public String getSchemaNamespace() {
        return JETTY_NAMESPACE;
    }

    private void addServlets(AbstractName webModuleName, Module module, ServletType[] servletTypes, Map<String, Set<String>> servletMappings, EARContext moduleContext) throws DeploymentException {
        TreeSet<ServletType> loadOrder = new TreeSet<ServletType>(new StartupOrderComparator());
        loadOrder.addAll(Arrays.asList(servletTypes));
        AbstractName previousServlet = null;
        Iterator<ServletType> i$ = loadOrder.iterator();
        while (i$.hasNext()) {
            ServletType aLoadOrder;
            ServletType servletType = aLoadOrder = i$.next();
            previousServlet = this.addServlet(webModuleName, module, previousServlet, servletType, servletMappings, moduleContext);
        }
    }

    private AbstractName addServlet(AbstractName webModuleName, Module module, AbstractName previousServlet, ServletType servletType, Map<String, Set<String>> servletMappings, EARContext moduleContext) throws DeploymentException {
        Set<String> mappings;
        ParamValueType[] initParamArray;
        GBeanData servletData;
        String servletName = servletType.getServletName().getStringValue().trim();
        AbstractName servletAbstractName = moduleContext.getNaming().createChildName(webModuleName, servletName, "Servlet");
        HashMap<String, String> initParams = new HashMap<String, String>();
        if (servletType.isSetServletClass()) {
            Class<?> baseServletClass;
            Class<?> servletClass;
            ClassLoader webClassLoader = moduleContext.getClassLoader();
            String servletClassName = servletType.getServletClass().getStringValue().trim();
            try {
                servletClass = webClassLoader.loadClass(servletClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load servlet class " + servletClassName, (Throwable)e);
            }
            try {
                baseServletClass = webClassLoader.loadClass(Servlet.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load javax.servlet.Servlet in web classloader", (Throwable)e);
            }
            if (baseServletClass.isAssignableFrom(servletClass)) {
                servletData = new GBeanData(servletAbstractName, ServletHolderWrapper.class);
                servletData.setAttribute("servletClass", (Object)servletClassName);
            } else {
                servletData = new GBeanData(this.pojoWebServiceTemplate);
                servletData.setAbstractName(servletAbstractName);
                boolean configured = false;
                for (WebServiceBuilder aWebServiceBuilder : this.webServiceBuilder) {
                    WebServiceBuilder serviceBuilder = aWebServiceBuilder;
                    if (!serviceBuilder.configurePOJO(servletData, servletName, module, servletClassName, (DeploymentContext)moduleContext)) continue;
                    configured = true;
                    break;
                }
                if (!configured) {
                    throw new DeploymentException("POJO web service: " + servletName + " not configured by any web service builder");
                }
            }
        } else if (servletType.isSetJspFile()) {
            servletData = new GBeanData(servletAbstractName, ServletHolderWrapper.class);
            servletData.setAttribute("jspFile", (Object)servletType.getJspFile().getStringValue().trim());
            servletData.setAttribute("servletClass", (Object)this.jspServlet.getServletClassName());
            initParams.put("development", "false");
        } else {
            throw new DeploymentException("Neither servlet class nor jsp file is set for " + servletName);
        }
        if (null != previousServlet) {
            servletData.addDependency(previousServlet);
        }
        servletData.setReferencePattern("JettyServletRegistration", webModuleName);
        servletData.setAttribute("servletName", (Object)servletName);
        for (ParamValueType paramValueType : initParamArray = servletType.getInitParamArray()) {
            initParams.put(paramValueType.getParamName().getStringValue().trim(), paramValueType.getParamValue().getStringValue().trim());
        }
        servletData.setAttribute("initParams", initParams);
        if (servletType.isSetLoadOnStartup()) {
            Integer loadOnStartup = new Integer(servletType.xgetLoadOnStartup().getStringValue());
            servletData.setAttribute("loadOnStartup", (Object)loadOnStartup);
        }
        servletData.setAttribute("servletMappings", (mappings = servletMappings.get(servletName)) == null ? Collections.EMPTY_SET : mappings);
        if (servletType.isSetRunAs()) {
            String runAsRole = servletType.getRunAs().getRoleName().getStringValue().trim();
            servletData.setAttribute("runAsRole", (Object)runAsRole);
        }
        try {
            moduleContext.addGBean(servletData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add servlet gbean to context", (Throwable)e);
        }
        return servletAbstractName;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web-1.1", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web-1.2", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web-2.0", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/jetty", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/jetty-1.1", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/jetty-1.2", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.1", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/jetty/config", "http://geronimo.apache.org/xml/ns/web/jetty/config-1.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/jetty/config-1.0", "http://geronimo.apache.org/xml/ns/web/jetty/config-1.0.1");
        GERONIMO_SCHEMA_CONVERSIONS.put("configProvider", (ElementConverter)new NamespaceElementConverter(JASPI_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("serverAuthConfig", (ElementConverter)new NamespaceElementConverter(JASPI_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("serverAuthContext", (ElementConverter)new NamespaceElementConverter(JASPI_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("serverAuthModule", (ElementConverter)new NamespaceElementConverter(JASPI_NAMESPACE));
        JETTY_NAMESPACE = JettyWebAppDocument.type.getDocumentElementName().getNamespaceURI();
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(JettyModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("defaultSessionTimeoutSeconds", Integer.class, true, true);
        infoBuilder.addAttribute("defaultWelcomeFiles", List.class, true, true);
        infoBuilder.addAttribute("defaultLocaleEncodingMappings", Map.class, true, true);
        infoBuilder.addAttribute("defaultMimeTypeMappings", Map.class, true, true);
        infoBuilder.addAttribute("jettyContainerObjectName", AbstractNameQuery.class, true, true);
        infoBuilder.addReference("JspServlet", JspServletHolderWrapper.class, "ServletTemplate");
        infoBuilder.addReference("DefaultServlets", DefaultServletHolderWrapper.class, "ServletTemplate");
        infoBuilder.addReference("DefaultFilters", Object.class);
        infoBuilder.addReference("DefaultFilterMappings", Object.class);
        infoBuilder.addReference("PojoWebServiceTemplate", Object.class, "ServletWebServiceTemplate");
        infoBuilder.addReference("WebServiceBuilder", WebServiceBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ClusteringBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ServiceBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("NamingBuilders", NamingBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ModuleBuilderExtensions", ModuleBuilderExtension.class, "ModuleBuilder");
        infoBuilder.addReference("ResourceEnvironmentSetter", ResourceEnvironmentSetter.class, "ModuleBuilder");
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "defaultSessionTimeoutSeconds", "defaultWelcomeFiles", "jettyContainerObjectName", "JspServlet", "DefaultServlets", "DefaultFilters", "DefaultFilterMappings", "defaultLocaleEncodingMappings", "defaultMimeTypeMappings", "PojoWebServiceTemplate", "WebServiceBuilder", "ClusteringBuilders", "ServiceBuilders", "NamingBuilders", "ModuleBuilderExtensions", "ResourceEnvironmentSetter", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StartupOrderComparator
    implements Comparator<ServletType>,
    Serializable {
        StartupOrderComparator() {
        }

        @Override
        public int compare(ServletType s1, ServletType s2) {
            if (!s1.isSetLoadOnStartup() && !s2.isSetLoadOnStartup()) {
                return s1.equals(s2) ? 0 : s1.getServletName().getStringValue().trim().compareTo(s2.getServletName().getStringValue().trim());
            }
            if (s1.isSetLoadOnStartup() && !s2.isSetLoadOnStartup()) {
                return -1;
            }
            if (!s1.isSetLoadOnStartup() && s2.isSetLoadOnStartup()) {
                return 1;
            }
            int comp = new Integer(s1.xgetLoadOnStartup().getStringValue()).compareTo(new Integer(s2.xgetLoadOnStartup().getStringValue()));
            if (comp == 0) {
                return s1.getServletName().getStringValue().trim().compareTo(s2.getServletName().getStringValue().trim());
            }
            return comp;
        }
    }

    private static class JettyAuthenticationWrapper
    implements AuthenticationWrapper {
        private final JettyAuthenticationType authType;

        private JettyAuthenticationWrapper(JettyAuthenticationType authType) {
            this.authType = authType;
        }

        public JaspiConfigProviderType getConfigProvider() {
            return this.authType.getConfigProvider();
        }

        public boolean isSetConfigProvider() {
            return this.authType.isSetConfigProvider();
        }

        public JaspiServerAuthConfigType getServerAuthConfig() {
            return this.authType.getServerAuthConfig();
        }

        public boolean isSetServerAuthConfig() {
            return this.authType.isSetServerAuthConfig();
        }

        public JaspiServerAuthContextType getServerAuthContext() {
            return this.authType.getServerAuthContext();
        }

        public boolean isSetServerAuthContext() {
            return this.authType.isSetServerAuthContext();
        }

        public JaspiAuthModuleType getServerAuthModule() {
            return this.authType.getServerAuthModule();
        }

        public boolean isSetServerAuthModule() {
            return this.authType.isSetServerAuthModule();
        }
    }
}

