/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6.connector;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.system.threads.ThreadPool;

public class JettyThreadPool
implements org.mortbay.thread.ThreadPool {
    private static final Log log = LogFactory.getLog(JettyThreadPool.class);
    private final ThreadPool executor;
    private final String name;

    public JettyThreadPool(ThreadPool executor, String name) {
        this.executor = executor;
        this.name = name;
    }

    public boolean dispatch(Runnable runnable) {
        try {
            this.executor.execute(this.name, runnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            log.warn((Object)"Unable to execute task", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            log.warn((Object)"Thread interrupted", (Throwable)e);
            return false;
        }
    }

    public void join() throws InterruptedException {
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public int getThreads() {
        return this.executor.getPoolSize();
    }

    public int getIdleThreads() {
        return this.executor.getMaximumPoolSize() - this.executor.getPoolSize();
    }

    public boolean isLowOnThreads() {
        return this.executor.getPoolSize() >= this.executor.getMaximumPoolSize();
    }
}

