/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.apache.geronimo.jetty6.JettyServletRegistration;
import org.apache.geronimo.jetty6.handler.AbstractImmutableHandler;
import org.apache.geronimo.jetty6.handler.LifecycleCommand;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.mortbay.jetty.servlet.ServletHolder;

public class InternalJettyServletHolder
extends ServletHolder {
    private static final ThreadLocal<String> currentServletName = new ThreadLocal();
    private final AbstractImmutableHandler lifecycleChain;
    private final Subject runAsSubject;
    private final JettyServletRegistration servletRegistration;
    private boolean stopped;

    public InternalJettyServletHolder(AbstractImmutableHandler lifecycleChain, Subject runAsSubject, JettyServletRegistration servletRegistration) {
        this.lifecycleChain = lifecycleChain;
        this.runAsSubject = runAsSubject;
        this.servletRegistration = servletRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        block7: {
            String oldServletName = InternalJettyServletHolder.getCurrentServletName();
            InternalJettyServletHolder.setCurrentServletName(this.getName());
            try {
                if (this.runAsSubject == null) {
                    super.handle(request, response);
                    break block7;
                }
                Callers oldCallers = ContextManager.pushNextCaller((Subject)this.runAsSubject);
                try {
                    super.handle(request, response);
                }
                finally {
                    ContextManager.popCallers((Callers)oldCallers);
                }
            }
            finally {
                InternalJettyServletHolder.setCurrentServletName(oldServletName);
            }
        }
    }

    public synchronized Object newInstance() throws InstantiationException, IllegalAccessException {
        return this.servletRegistration.newInstance(this._className);
    }

    public void destroyInstance(Object o) throws Exception {
        if (!this.stopped) {
            super.destroyInstance(o);
            this.servletRegistration.destroyInstance(o);
        }
    }

    static String getCurrentServletName() {
        return currentServletName.get();
    }

    static void setCurrentServletName(String servletName) {
        currentServletName.set(servletName);
    }

    public void doStart() throws Exception {
        StartCommand lifecycleCommand = new StartCommand();
        this.lifecycleChain.lifecycleCommand(lifecycleCommand);
    }

    public void doStop() {
        StopCommand lifecycleCommand = new StopCommand();
        try {
            this.lifecycleChain.lifecycleCommand(lifecycleCommand);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void internalDoStart() throws Exception {
        super.doStart();
    }

    private void internalDoStop() {
        super.doStop();
        this.stopped = true;
    }

    public class StopCommand
    implements LifecycleCommand {
        public void lifecycleMethod() throws Exception {
            InternalJettyServletHolder.this.internalDoStop();
        }
    }

    public class StartCommand
    implements LifecycleCommand {
        public void lifecycleMethod() throws Exception {
            InternalJettyServletHolder.this.internalDoStart();
        }
    }
}

