/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.jetty6.handler.AbstractImmutableHandler;
import org.apache.geronimo.jetty6.handler.LifecycleCommand;
import org.mortbay.jetty.handler.AbstractHandler;

public class ThreadClassloaderHandler
extends AbstractImmutableHandler {
    private final ClassLoader classLoader;

    public ThreadClassloaderHandler(AbstractHandler next, ClassLoader classLoader) {
        super(next);
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        Thread thread = Thread.currentThread();
        ClassLoader oldClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.classLoader);
        try {
            this.next.handle(target, request, response, dispatch);
        }
        finally {
            thread.setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lifecycleCommand(LifecycleCommand lifecycleCommand) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.classLoader);
        try {
            super.lifecycleCommand(lifecycleCommand);
        }
        finally {
            thread.setContextClassLoader(oldClassLoader);
        }
    }
}

