/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.RuntimeCustomizer;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.jetty6.Host;
import org.apache.geronimo.jetty6.InternalJAASJettyRealm;
import org.apache.geronimo.jetty6.JAASJettyRealm;
import org.apache.geronimo.jetty6.JettyContainer;
import org.apache.geronimo.jetty6.JettyServletRegistration;
import org.apache.geronimo.jetty6.PreHandler;
import org.apache.geronimo.jetty6.PreHandlerFactory;
import org.apache.geronimo.jetty6.SessionHandlerFactory;
import org.apache.geronimo.jetty6.handler.AbstractImmutableHandler;
import org.apache.geronimo.jetty6.handler.ComponentContextHandler;
import org.apache.geronimo.jetty6.handler.InstanceContextHandler;
import org.apache.geronimo.jetty6.handler.JettySecurityHandler;
import org.apache.geronimo.jetty6.handler.LifecycleCommand;
import org.apache.geronimo.jetty6.handler.ThreadClassloaderHandler;
import org.apache.geronimo.jetty6.handler.UserTransactionHandler;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebModule;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.AbstractHandlerContainer;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.servlet.ErrorPageErrorHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyWebAppContext
implements GBeanLifecycle,
JettyServletRegistration,
WebModule {
    private static Log log = LogFactory.getLog(JettyWebAppContext.class);
    private final String originalSpecDD;
    private final J2EEServer server;
    private final J2EEApplication application;
    private final ClassLoader webClassLoader;
    private final JettyContainer jettyContainer;
    private final String webAppRoot;
    private final URL configurationBaseURL;
    private String displayName;
    private final String objectName;
    private final WebAppContext webAppContext;
    private final AbstractHandlerContainer contextHandler;
    private final AbstractImmutableHandler lifecycleChain;
    private final Context componentContext;
    private final Holder holder;
    private final RunAsSource runAsSource;
    private final Set<String> servletNames = new HashSet<String>();
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_ATTR_SESSION_TIMEOUT = "sessionTimeoutSeconds";
    public static final String GBEAN_REF_SESSION_HANDLER_FACTORY = "SessionHandlerFactory";
    public static final String GBEAN_REF_PRE_HANDLER_FACTORY = "PreHandlerFactory";

    public JettyWebAppContext(String objectName, String originalSpecDD, Map<String, Object> componentContext, ClassLoader classLoader, URL configurationBaseUrl, Set unshareableResources, Set applicationManagedSecurityResources, String displayName, Map contextParamMap, Collection<String> listenerClassNames, boolean distributable, Map mimeMap, String[] welcomeFiles, Map<String, String> localeEncodingMapping, Map errorPages, Authenticator authenticator, String realmName, Map<String, String> tagLibMap, int sessionTimeoutSeconds, SessionHandlerFactory handlerFactory, PreHandlerFactory preHandlerFactory, String policyContextID, String securityRealmName, RunAsSource runAsSource, Holder holder, Host host, TransactionManager transactionManager, TrackedConnectionAssociator trackedConnectionAssociator, JettyContainer jettyContainer, RuntimeCustomizer contextCustomizer, J2EEServer server, J2EEApplication application, Kernel kernel) throws Exception {
        SessionHandler sessionHandler;
        assert (componentContext != null);
        assert (classLoader != null);
        assert (configurationBaseUrl != null);
        assert (transactionManager != null);
        assert (trackedConnectionAssociator != null);
        assert (jettyContainer != null);
        this.holder = holder == null ? Holder.EMPTY : holder;
        RunAsSource runAsSource2 = this.runAsSource = runAsSource == null ? RunAsSource.NULL : runAsSource;
        if (null != handlerFactory) {
            if (null == preHandlerFactory) {
                throw new IllegalStateException("A preHandlerFactory must be set if an handler factory is set.");
            }
            PreHandler preHandler = preHandlerFactory.createHandler();
            sessionHandler = handlerFactory.createHandler(preHandler);
        } else {
            sessionHandler = new SessionHandler();
        }
        JettySecurityHandler securityHandler = null;
        if (securityRealmName != null) {
            InternalJAASJettyRealm internalJAASJettyRealm = jettyContainer.addRealm(securityRealmName);
            JAASJettyRealm realm = new JAASJettyRealm(realmName, internalJAASJettyRealm);
            Subject defaultSubject = this.runAsSource.getDefaultSubject();
            securityHandler = new JettySecurityHandler(authenticator, realm, policyContextID, defaultSubject);
        }
        ServletHandler servletHandler = new ServletHandler();
        this.webAppContext = new WebAppContext(securityHandler, sessionHandler, servletHandler, null);
        GeronimoUserTransaction userTransaction = new GeronimoUserTransaction(transactionManager);
        this.componentContext = EnterpriseNamingContext.createEnterpriseNamingContext(componentContext, (UserTransaction)userTransaction, (Kernel)kernel, (ClassLoader)classLoader);
        this.contextHandler = new ComponentContextHandler((AbstractHandler)this.webAppContext, this.componentContext);
        if (contextCustomizer != null) {
            HashMap servletContext = new HashMap();
            HashMap<Class, Object> customizerContext = new HashMap<Class, Object>();
            customizerContext.put(Map.class, servletContext);
            customizerContext.put(Context.class, this.componentContext);
            contextCustomizer.customize(customizerContext);
            for (Map.Entry entry : servletContext.entrySet()) {
                this.webAppContext.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        Object next = sessionHandler;
        next = new ThreadClassloaderHandler((AbstractHandler)next, classLoader);
        next = new InstanceContextHandler((AbstractHandler)next, unshareableResources, applicationManagedSecurityResources, trackedConnectionAssociator);
        next = new UserTransactionHandler((AbstractHandler)next, (UserTransaction)userTransaction);
        this.webAppContext.setHandler((Handler)next);
        next = new ComponentContextHandler((AbstractHandler)next, this.componentContext);
        this.lifecycleChain = (AbstractImmutableHandler)((Object)next);
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.setMimeMap(mimeMap);
        this.webAppContext.setMimeTypes(mimeTypes);
        this.server = server;
        this.application = application;
        this.objectName = objectName;
        if (objectName != null) {
            ObjectName myObjectName = ObjectNameUtil.getObjectName((String)objectName);
            this.verifyObjectName(myObjectName);
        }
        this.configurationBaseURL = configurationBaseUrl;
        this.jettyContainer = jettyContainer;
        this.originalSpecDD = originalSpecDD;
        this.webAppContext.setConfigurationClasses(new String[0]);
        this.webAppRoot = configurationBaseUrl.toString();
        this.webClassLoader = classLoader;
        this.webAppContext.setClassLoader(this.webClassLoader);
        if (host != null) {
            this.webAppContext.setConnectorNames(host.getHosts());
            this.webAppContext.setVirtualHosts(host.getVirtualHosts());
        }
        this.webAppContext.setDisplayName(displayName);
        this.webAppContext.setInitParams(contextParamMap);
        this.setListenerClassNames(listenerClassNames);
        this.webAppContext.setDistributable(distributable);
        this.webAppContext.setWelcomeFiles(welcomeFiles);
        this.setLocaleEncodingMapping(localeEncodingMapping);
        this.setErrorPages(errorPages);
        this.setTagLibMap(tagLibMap);
        if (!distributable) {
            this.setSessionTimeoutSeconds(sessionTimeoutSeconds);
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public URL getWARDirectory() {
        return this.configurationBaseURL;
    }

    public String getWARName() {
        try {
            return ObjectName.getInstance(this.objectName).getKeyProperty("name");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public WebContainer getContainer() {
        return this.jettyContainer;
    }

    public void setContextPath(String path) {
        if (path == null || !path.startsWith("/")) {
            throw new IllegalArgumentException("context path must be non-null and start with '/', not " + path);
        }
        this.webAppContext.setContextPath(path);
    }

    public String getContextPath() {
        return this.webAppContext.getContextPath();
    }

    public void setWorkDir(String workDir) {
        if (workDir == null) {
            return;
        }
        this.webAppContext.setTempDirectory(this.jettyContainer.resolveToJettyHome(workDir));
    }

    @Override
    public ClassLoader getWebClassLoader() {
        return this.webClassLoader;
    }

    @Override
    public AbstractImmutableHandler getLifecycleChain() {
        return this.lifecycleChain;
    }

    @Override
    public Subject getSubjectForRole(String role) throws LoginException {
        return this.runAsSource.getSubjectForRole(role);
    }

    @Override
    public Object newInstance(String className) throws InstantiationException, IllegalAccessException {
        if (className == null) {
            throw new InstantiationException("no class loaded");
        }
        return this.holder.newInstance(className, this.webClassLoader, this.componentContext);
    }

    @Override
    public void destroyInstance(Object o) throws Exception {
        Map preDestroy;
        Class<?> clazz = o.getClass();
        if (this.holder != null && (preDestroy = this.holder.getPreDestroy()) != null) {
            Holder.apply((Object)o, clazz, (Map)preDestroy);
        }
    }

    public void doStart() throws Exception {
        this.webAppContext.setClassLoader(this.webClassLoader);
        this.webAppContext.setWar(this.webAppRoot);
        this.getLifecycleChain().lifecycleCommand(new StartCommand());
    }

    public void doStop() throws Exception {
        this.getLifecycleChain().lifecycleCommand(new StopCommand());
        LogFactory.release((ClassLoader)this.webClassLoader);
        log.debug((Object)"JettyWebAppContext stopped");
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.warn((Object)"JettyWebAppContext failed");
    }

    public void setLocaleEncodingMapping(Map<String, String> localeEncodingMap) {
        if (localeEncodingMap != null) {
            for (Map.Entry<String, String> entry : localeEncodingMap.entrySet()) {
                this.webAppContext.addLocaleEncoding(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setListenerClassNames(Collection<String> eventListeners) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (eventListeners != null) {
            ArrayList<EventListener> listeners = new ArrayList<EventListener>();
            for (String listenerClassName : eventListeners) {
                EventListener listener = (EventListener)this.newInstance(listenerClassName);
                listeners.add(listener);
            }
            this.webAppContext.setEventListeners(listeners.toArray(new EventListener[listeners.size()]));
        }
    }

    public void setErrorPages(Map errorPageMap) {
        if (errorPageMap != null) {
            ((ErrorPageErrorHandler)this.webAppContext.getErrorHandler()).setErrorPages(errorPageMap);
        }
    }

    public void setTagLibMap(Map<String, String> tagLibMap) {
        if (tagLibMap != null) {
            for (Map.Entry<String, String> entry : tagLibMap.entrySet()) {
                this.webAppContext.setResourceAlias(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setSessionTimeoutSeconds(int seconds) {
        this.webAppContext.getSessionHandler().getSessionManager().setMaxInactiveInterval(seconds);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.webAppContext.setDisplayName(displayName);
    }

    public String getDeploymentDescriptor() {
        return this.originalSpecDD;
    }

    public String getServer() {
        return this.server.getObjectName();
    }

    public String getApplication() {
        if (this.application == null) {
            return null;
        }
        return this.application.getObjectName();
    }

    public String[] getJavaVMs() {
        return this.server.getJavaVMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getServlets() {
        Set<String> set = this.servletNames;
        synchronized (set) {
            return this.servletNames.toArray(new String[this.servletNames.size()]);
        }
    }

    @Override
    public ServletHandler getServletHandler() {
        return this.webAppContext.getServletHandler();
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"WebModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("WebModule object name j2eeType property must be 'WebModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("WebModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("WebModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServletHolder(ServletHolder servletHolder, String servletName, Set<String> servletMappings, String objectName) throws Exception {
        this.webAppContext.getServletHandler().addServlet(servletHolder);
        if (servletMappings != null) {
            for (String urlPattern : servletMappings) {
                ServletMapping servletMapping = new ServletMapping();
                servletMapping.setPathSpec(urlPattern);
                servletMapping.setServletName(servletName);
                this.webAppContext.getServletHandler().addServletMapping(servletMapping);
            }
        }
        if (objectName != null) {
            Set<String> set = this.servletNames;
            synchronized (set) {
                this.servletNames.add(objectName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterServletHolder(ServletHolder servletHolder, String servletName, Set<String> servletMappings, String objectName) throws Exception {
        if (objectName != null) {
            Set<String> set = this.servletNames;
            synchronized (set) {
                this.servletNames.remove(objectName);
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"Jetty WebApplication Context", JettyWebAppContext.class, (String)"WebModule");
        infoBuilder.addAttribute("deploymentDescriptor", String.class, true);
        infoBuilder.addAttribute("displayName", String.class, true);
        infoBuilder.addAttribute("contextParamMap", Map.class, true);
        infoBuilder.addAttribute("listenerClassNames", Collection.class, true);
        infoBuilder.addAttribute("distributable", Boolean.TYPE, true);
        infoBuilder.addAttribute("mimeMap", Map.class, true);
        infoBuilder.addAttribute("welcomeFiles", String[].class, true);
        infoBuilder.addAttribute("localeEncodingMapping", Map.class, true);
        infoBuilder.addAttribute("errorPages", Map.class, true);
        infoBuilder.addAttribute("authenticator", Authenticator.class, true);
        infoBuilder.addAttribute("realmName", String.class, true);
        infoBuilder.addAttribute("tagLibMap", Map.class, true);
        infoBuilder.addAttribute(GBEAN_ATTR_SESSION_TIMEOUT, Integer.TYPE, true);
        infoBuilder.addReference(GBEAN_REF_SESSION_HANDLER_FACTORY, SessionHandlerFactory.class, "GBean");
        infoBuilder.addReference(GBEAN_REF_PRE_HANDLER_FACTORY, PreHandlerFactory.class, "GBean");
        infoBuilder.addAttribute("componentContext", Map.class, true);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("configurationBaseUrl", URL.class, true);
        infoBuilder.addAttribute("unshareableResources", Set.class, true);
        infoBuilder.addAttribute("applicationManagedSecurityResources", Set.class, true);
        infoBuilder.addAttribute("contextPath", String.class, true);
        infoBuilder.addAttribute("workDir", String.class, true);
        infoBuilder.addReference("Host", Host.class, "Host");
        infoBuilder.addReference("TransactionManager", TransactionManager.class, "TransactionManager");
        infoBuilder.addReference("TrackedConnectionAssociator", TrackedConnectionAssociator.class, "JCAConnectionTracker");
        infoBuilder.addReference("JettyContainer", JettyContainer.class, "GBean");
        infoBuilder.addReference("ContextCustomizer", RuntimeCustomizer.class, "GBean");
        infoBuilder.addInterface(JettyServletRegistration.class);
        infoBuilder.addAttribute("policyContextID", String.class, true);
        infoBuilder.addAttribute("securityRealmName", String.class, true);
        infoBuilder.addReference("RunAsSource", RunAsSource.class, "JACCManager");
        infoBuilder.addAttribute("holder", Holder.class, true);
        infoBuilder.addReference("J2EEServer", J2EEServer.class);
        infoBuilder.addReference("J2EEApplication", J2EEApplication.class);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addAttribute("application", String.class, false);
        infoBuilder.addAttribute("javaVMs", String[].class, false);
        infoBuilder.addAttribute("servlets", String[].class, false);
        infoBuilder.addInterface(WebModule.class);
        infoBuilder.setConstructor(new String[]{"objectName", "deploymentDescriptor", "componentContext", "classLoader", "configurationBaseUrl", "unshareableResources", "applicationManagedSecurityResources", "displayName", "contextParamMap", "listenerClassNames", "distributable", "mimeMap", "welcomeFiles", "localeEncodingMapping", "errorPages", "authenticator", "realmName", "tagLibMap", GBEAN_ATTR_SESSION_TIMEOUT, GBEAN_REF_SESSION_HANDLER_FACTORY, GBEAN_REF_PRE_HANDLER_FACTORY, "policyContextID", "securityRealmName", "RunAsSource", "holder", "Host", "TransactionManager", "TrackedConnectionAssociator", "JettyContainer", "ContextCustomizer", "J2EEServer", "J2EEApplication", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    public class StopCommand
    implements LifecycleCommand {
        public void lifecycleMethod() throws Exception {
            JettyWebAppContext.this.contextHandler.stop();
            for (EventListener listener : JettyWebAppContext.this.webAppContext.getEventListeners()) {
                JettyWebAppContext.this.destroyInstance(listener);
            }
            JettyWebAppContext.this.jettyContainer.removeContext(JettyWebAppContext.this.contextHandler);
        }
    }

    public class StartCommand
    implements LifecycleCommand {
        public void lifecycleMethod() throws Exception {
            JettyWebAppContext.this.jettyContainer.addContext(JettyWebAppContext.this.contextHandler);
            JettyWebAppContext.this.contextHandler.start();
        }
    }
}

