/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6;

import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty6.InternalJettyServletHolder;
import org.apache.geronimo.jetty6.JettyServletRegistration;
import org.apache.geronimo.management.Servlet;
import org.mortbay.jetty.servlet.ServletHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyServletHolder
implements Servlet,
GBeanLifecycle {
    private final JettyServletRegistration servletRegistration;
    private final ServletHolder servletHolder;
    private final String objectName;
    public static final GBeanInfo GBEAN_INFO;

    public JettyServletHolder() {
        this.servletRegistration = null;
        this.servletHolder = null;
        this.objectName = null;
    }

    public JettyServletHolder(String objectName, String servletName, String servletClassName, String jspFile, Map initParams, Integer loadOnStartup, Set<String> servletMappings, String runAsRole, JettyServletRegistration context) throws Exception {
        this.servletRegistration = context;
        Subject runAsSubject = context == null ? null : context.getSubjectForRole(runAsRole);
        this.servletHolder = new InternalJettyServletHolder(context == null ? null : context.getLifecycleChain(), runAsSubject, this.servletRegistration);
        this.servletHolder.setName(servletName);
        this.servletHolder.setClassName(servletClassName);
        if (context != null) {
            this.servletHolder.setInitParameters(initParams);
            this.servletHolder.setForcedPath(jspFile);
            if (loadOnStartup != null) {
                this.servletHolder.setInitOrder(loadOnStartup.intValue());
            }
            context.registerServletHolder(this.servletHolder, servletName, servletMappings, objectName);
        }
        this.objectName = objectName;
    }

    public String getServletName() {
        return this.servletHolder.getName();
    }

    public String getServletClassName() {
        return this.servletHolder.getClassName();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        this.servletHolder.stop();
        if (this.servletRegistration != null) {
            this.servletRegistration.unregisterServletHolder(this.servletHolder, this.servletHolder.getName(), null, this.objectName);
        }
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(JettyServletHolder.class, (String)"Servlet");
        infoBuilder.addAttribute("servletName", String.class, true);
        infoBuilder.addAttribute("servletClass", String.class, true);
        infoBuilder.addAttribute("jspFile", String.class, true);
        infoBuilder.addAttribute("initParams", Map.class, true);
        infoBuilder.addAttribute("loadOnStartup", Integer.class, true);
        infoBuilder.addAttribute("servletMappings", Set.class, true);
        infoBuilder.addAttribute("runAsRole", String.class, true);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addInterface(Servlet.class);
        infoBuilder.addReference("JettyServletRegistration", JettyServletRegistration.class, "WebModule");
        infoBuilder.setConstructor(new String[]{"objectName", "servletName", "servletClass", "jspFile", "initParams", "loadOnStartup", "servletMappings", "runAsRole", "JettyServletRegistration"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

