/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty6.InternalJettyServletHolder;
import org.apache.geronimo.jetty6.JettyServletRegistration;
import org.apache.geronimo.webservices.POJOWebServiceServlet;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerFactory;
import org.apache.geronimo.webservices.WebServiceContainerInvoker;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.servlet.ServletHolder;

public class JettyPOJOWebServiceHolder
implements GBeanLifecycle {
    private final ServletHolder servletHolder;
    private final WebServiceContainer webServiceContainer;
    private final Set servletMappings;
    private final JettyServletRegistration context;
    private final String pojoClassName;
    public static final GBeanInfo GBEAN_INFO;

    public JettyPOJOWebServiceHolder() {
        this.servletHolder = null;
        this.webServiceContainer = null;
        this.servletMappings = null;
        this.context = null;
        this.pojoClassName = null;
    }

    public JettyPOJOWebServiceHolder(String pojoClassName, String servletName, Map initParams, Integer loadOnStartup, Set servletMappings, String runAsRole, WebServiceContainerFactory webServiceContainerFactory, JettyServletRegistration context) throws Exception {
        Subject runAsSubject = context == null ? null : context.getSubjectForRole(runAsRole);
        this.servletHolder = new InternalJettyServletHolder(context == null ? null : context.getLifecycleChain(), runAsSubject, context);
        this.pojoClassName = pojoClassName;
        this.context = context;
        this.webServiceContainer = webServiceContainerFactory == null ? null : webServiceContainerFactory.getWebServiceContainer();
        this.servletMappings = servletMappings;
        if (context != null) {
            this.servletHolder.setName(servletName);
            this.servletHolder.setClassName(POJOWebServiceServlet.class.getName());
            this.servletHolder.setInitParameters(initParams);
            if (loadOnStartup != null) {
                this.servletHolder.setInitOrder(loadOnStartup.intValue());
            }
        }
    }

    public String getServletName() {
        return this.servletHolder.getName();
    }

    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        InternalJettyServletHolder.setCurrentServletName(this.getServletName());
        PolicyContext.setHandlerData((Object)Request.getRequest((HttpServletRequest)((HttpServletRequest)request)));
        this.servletHolder.handle(request, response);
    }

    public void doStart() throws Exception {
        if (this.context != null) {
            Class<?> pojoClass = this.context.getWebClassLoader().loadClass(this.pojoClassName);
            ServletContext servletContext = this.context.getServletHandler().getServletContext();
            String webServicecontainerID = this.getServletName() + WebServiceContainerInvoker.WEBSERVICE_CONTAINER + this.webServiceContainer.hashCode();
            this.servletHolder.setInitParameter(WebServiceContainerInvoker.WEBSERVICE_CONTAINER, webServicecontainerID);
            servletContext.setAttribute(webServicecontainerID, (Object)this.webServiceContainer);
            String pojoClassID = this.getServletName() + POJOWebServiceServlet.POJO_CLASS + pojoClass.hashCode();
            this.servletHolder.setInitParameter(POJOWebServiceServlet.POJO_CLASS, pojoClassID);
            servletContext.setAttribute(pojoClassID, pojoClass);
            this.context.registerServletHolder(this.servletHolder, this.getServletName(), this.servletMappings, null);
            this.servletHolder.start();
        }
    }

    public void doStop() throws Exception {
        this.servletHolder.stop();
    }

    public void doFail() {
        try {
            this.servletHolder.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(JettyPOJOWebServiceHolder.class, (String)"ServletWebServiceTemplate");
        infoBuilder.addAttribute("pojoClassName", String.class, true);
        infoBuilder.addAttribute("servletName", String.class, true);
        infoBuilder.addAttribute("initParams", Map.class, true);
        infoBuilder.addAttribute("loadOnStartup", Integer.class, true);
        infoBuilder.addAttribute("servletMappings", Set.class, true);
        infoBuilder.addAttribute("runAsRole", String.class, true);
        infoBuilder.addReference("WebServiceContainerFactory", WebServiceContainerFactory.class);
        infoBuilder.addReference("JettyServletRegistration", JettyServletRegistration.class);
        infoBuilder.setConstructor(new String[]{"pojoClassName", "servletName", "initParams", "loadOnStartup", "servletMappings", "runAsRole", "WebServiceContainerFactory", "JettyServletRegistration"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

