/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6.connector;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty6.JettyContainer;
import org.apache.geronimo.jetty6.JettyWebConnector;
import org.apache.geronimo.jetty6.connector.JettyThreadPool;
import org.apache.geronimo.system.threads.ThreadPool;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Connector;

public abstract class JettyConnector
implements GBeanLifecycle,
JettyWebConnector {
    public static final String CONNECTOR_CONTAINER_REFERENCE = "JettyContainer";
    private final JettyContainer container;
    protected final AbstractConnector listener;
    private String connectHost;
    public static final GBeanInfo GBEAN_INFO;

    public JettyConnector() {
        this.container = null;
        this.listener = null;
    }

    public JettyConnector(JettyContainer container, ThreadPool threadPool) {
        this.container = container;
        this.listener = null;
    }

    public JettyConnector(JettyContainer container, AbstractConnector listener, ThreadPool threadPool, String name) {
        this.container = container;
        this.listener = listener;
        if (threadPool != null) {
            JettyThreadPool jettyThreadPool = new JettyThreadPool(threadPool, name);
            listener.setThreadPool((org.mortbay.thread.ThreadPool)jettyThreadPool);
        }
    }

    public String getHost() {
        return this.listener.getHost();
    }

    public void setHost(String host) throws UnknownHostException {
        this.listener.setHost(host);
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public void setPort(int port) {
        this.listener.setPort(port);
    }

    public abstract int getDefaultPort();

    public String getDefaultScheme() {
        return null;
    }

    public String getConnectUrl() {
        if (this.connectHost == null) {
            String host = this.getHost();
            if (host == null || host.equals("0.0.0.0")) {
                InetAddress address = null;
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    host = "unknown-host";
                }
                if (address != null && ((host = address.getHostName()) == null || host.equals(""))) {
                    host = address.getHostAddress();
                }
            }
            this.connectHost = host;
        }
        return this.getProtocol().toLowerCase() + "://" + this.connectHost + (this.getPort() == this.getDefaultPort() ? "" : ":" + this.getPort());
    }

    public int getMaxIdleTimeMs() {
        return this.listener.getMaxIdleTime();
    }

    public void setMaxIdleTimeMs(int idleTime) {
        this.listener.setMaxIdleTime(idleTime);
    }

    public int getBufferSizeBytes() {
        return this.listener.getRequestBufferSize();
    }

    public void setBufferSizeBytes(int bytes) {
        this.listener.setRequestBufferSize(bytes);
    }

    public int getAcceptQueueSize() {
        return this.listener.getAcceptQueueSize();
    }

    public void setAcceptQueueSize(int size) {
        this.listener.setAcceptQueueSize(size);
    }

    public int getLingerMillis() {
        return (int)this.listener.getSoLingerTime();
    }

    public void setLingerMillis(int millis) {
        this.listener.setSoLingerTime(millis);
    }

    public boolean isTcpNoDelay() {
        return true;
    }

    public void setTcpNoDelay(boolean enable) {
        throw new UnsupportedOperationException(this.listener == null ? "No Listener" : this.listener.getClass().getName());
    }

    public void setMaxThreads(int maxThreads) {
        this.listener.setAcceptors(maxThreads);
    }

    public int getMaxThreads() {
        return this.listener.getAcceptors();
    }

    public int getRedirectPort() {
        return this.listener.getConfidentialPort();
    }

    public InetSocketAddress getListenAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByName(this.listener.getHost()), this.listener.getPort());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("InetSocketAddress cannot be determined for host=" + this.listener.getHost(), e);
        }
    }

    public void setRedirectPort(int port) {
        throw new UnsupportedOperationException("No redirect port on " + this.getClass().getName());
    }

    public abstract String getProtocol();

    public void doStart() throws Exception {
        this.container.addListener((Connector)this.listener);
        this.listener.start();
    }

    public void doStop() {
        while (true) {
            try {
                this.listener.stop();
                this.container.removeListener((Connector)this.listener);
                return;
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
    }

    public void doFail() {
        while (true) {
            try {
                this.listener.stop();
                this.container.removeListener((Connector)this.listener);
                return;
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Jetty HTTP Connector", JettyConnector.class);
        infoFactory.addReference(CONNECTOR_CONTAINER_REFERENCE, JettyContainer.class, "GBean");
        infoFactory.addReference("ThreadPool", ThreadPool.class, "GBean");
        infoFactory.addInterface(JettyWebConnector.class, new String[]{"host", "port", "minThreads", "maxThreads", "bufferSizeBytes", "acceptQueueSize", "lingerMillis", "protocol", "redirectPort", "connectUrl", "maxIdleTimeMs"}, new String[]{"host", "port", "redirectPort", "maxThreads", "minThreads", "protocol"});
        infoFactory.setConstructor(new String[]{CONNECTOR_CONTAINER_REFERENCE, "ThreadPool"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

