/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6.cluster;

import org.apache.geronimo.clustering.SessionManager;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jetty6.PreHandler;
import org.apache.geronimo.jetty6.SessionHandlerFactory;
import org.apache.geronimo.jetty6.cluster.ClusteredSessionHandler;
import org.apache.geronimo.jetty6.cluster.ClusteredSessionManager;
import org.mortbay.jetty.servlet.SessionHandler;

public class ClusteredSessionHandlerFactory
implements SessionHandlerFactory {
    private final SessionManager sessionManager;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_REF_SESSION_MANAGER = "SessionManager";

    public ClusteredSessionHandlerFactory(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public SessionHandler createHandler(PreHandler preHandler) {
        ClusteredSessionManager clusteredSessionManager = new ClusteredSessionManager(this.sessionManager);
        return new ClusteredSessionHandler(clusteredSessionManager, preHandler);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Clustered Web Application Handler Factory", ClusteredSessionHandlerFactory.class, (String)"GBean");
        infoFactory.addReference(GBEAN_REF_SESSION_MANAGER, SessionManager.class, "GBean");
        infoFactory.addInterface(SessionHandlerFactory.class);
        infoFactory.setConstructor(new String[]{GBEAN_REF_SESSION_MANAGER});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

