/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6.cluster;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.jetty6.AbstractPreHandler;
import org.apache.geronimo.jetty6.PreHandler;
import org.apache.geronimo.jetty6.cluster.ClusteredSessionManager;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.servlet.SessionHandler;

public class ClusteredSessionHandler
extends SessionHandler {
    private final PreHandler chainedHandler;

    public ClusteredSessionHandler(ClusteredSessionManager sessionManager, PreHandler chainedHandler) {
        if (null == chainedHandler) {
            throw new IllegalArgumentException("chainedHandler is required");
        }
        this.chainedHandler = chainedHandler;
        chainedHandler.setNextHandler((Handler)new ActualHandler());
        this.setSessionManager((SessionManager)sessionManager);
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        this.setRequestedId(request, dispatch);
        try {
            this.chainedHandler.handle(target, request, response, dispatch);
        }
        catch (ServletException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    protected void doHandle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        super.handle(target, request, response, dispatch);
    }

    private class ActualHandler
    extends AbstractPreHandler {
        private ActualHandler() {
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            ClusteredSessionHandler.this.doHandle(target, request, response, dispatch);
        }
    }
}

