/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.cluster;

import java.io.IOException;
import org.apache.geronimo.clustering.ClusteredInvocation;
import org.apache.geronimo.clustering.ClusteredInvocationException;
import org.apache.geronimo.jetty.GeronimoServletHttpRequest;
import org.apache.geronimo.jetty.HandleInterceptor;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;

public abstract class AbstractClusteredHandleInterceptor
implements HandleInterceptor {
    public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse, HandleInterceptor end) throws HttpException, IOException {
        ClusteredInvocation invocation = this.newClusteredInvocation(pathInContext, pathParams, httpRequest, httpResponse, end);
        try {
            invocation.invoke();
        }
        catch (ClusteredInvocationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof HttpException) {
                throw (HttpException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw (IOException)new IOException().initCause(cause);
        }
    }

    protected abstract ClusteredInvocation newClusteredInvocation(String var1, String var2, HttpRequest var3, HttpResponse var4, HandleInterceptor var5);

    protected abstract class WebClusteredInvocation
    implements ClusteredInvocation {
        protected final String pathInContext;
        protected final String pathParams;
        protected final HttpRequest request;
        protected final HttpResponse response;
        protected final HandleInterceptor end;

        public WebClusteredInvocation(String pathInContext, String pathParams, HttpRequest request, HttpResponse response, HandleInterceptor end) {
            this.pathInContext = pathInContext;
            this.pathParams = pathParams;
            this.request = request;
            this.response = response;
            this.end = end;
            GeronimoServletHttpRequest servletHttpRequest = (GeronimoServletHttpRequest)((Object)request.getWrapper());
            servletHttpRequest.setRequestedSessionId(pathParams);
        }

        protected void invokeLocally() throws ClusteredInvocationException {
            try {
                this.end.handle(this.pathInContext, this.pathParams, this.request, this.response, null);
            }
            catch (IOException e) {
                throw new ClusteredInvocationException((Throwable)e);
            }
        }

        public String getRequestedSessionId() {
            GeronimoServletHttpRequest servletHttpRequest = (GeronimoServletHttpRequest)((Object)this.request.getWrapper());
            return servletHttpRequest.getRequestedSessionId();
        }
    }
}

