/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import [Ljava.lang.String;;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PermissionCollection;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.jetty.GeronimoServletHttpRequest;
import org.apache.geronimo.jetty.HandleInterceptor;
import org.apache.geronimo.jetty.Host;
import org.apache.geronimo.jetty.InternalJAASJettyRealm;
import org.apache.geronimo.jetty.JAASJettyRealm;
import org.apache.geronimo.jetty.JettyContainer;
import org.apache.geronimo.jetty.JettyServletRegistration;
import org.apache.geronimo.jetty.WebApplicationHandlerFactory;
import org.apache.geronimo.jetty.interceptor.BeforeAfter;
import org.apache.geronimo.jetty.interceptor.ComponentContextBeforeAfter;
import org.apache.geronimo.jetty.interceptor.InstanceContextBeforeAfter;
import org.apache.geronimo.jetty.interceptor.SecurityContextBeforeAfter;
import org.apache.geronimo.jetty.interceptor.ThreadClassloaderBeforeAfter;
import org.apache.geronimo.jetty.interceptor.WebApplicationContextBeforeAfter;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.geronimo.WebConnector;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebModule;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.mortbay.http.Authenticator;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.JSR154Filter;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletHttpResponse;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;

public class JettyWebAppContext
extends WebApplicationContext
implements GBeanLifecycle,
JettyServletRegistration,
WebModule {
    private static Log log;
    private final String originalSpecDD;
    private final J2EEServer server;
    private final J2EEApplication application;
    private final ClassLoader webClassLoader;
    private final JettyContainer jettyContainer;
    private final String webAppRoot;
    private final URL configurationBaseURL;
    private final WebApplicationHandler handler;
    private final HandleInterceptor handleInterceptor;
    private String displayName;
    private final String[] welcomeFiles;
    private final BeforeAfter chain;
    private final int contextLength;
    private final SecurityContextBeforeAfter securityInterceptor;
    private final String objectName;
    private final Set servletNames = new HashSet();
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_ATTR_SESSION_TIMEOUT = "sessionTimeoutSeconds";
    public static final String GBEAN_REF_WEB_APPLICATION_HANDLER_FACTORY = "WebApplicationHandlerFactory";
    public static final String GBEAN_REF_HANDLE_INTERCEPTOR = "HandleInterceptor";
    static final /* synthetic */ boolean $assertionsDisabled;

    public JettyWebAppContext() {
        this.server = null;
        this.application = null;
        this.originalSpecDD = null;
        this.webClassLoader = null;
        this.jettyContainer = null;
        this.webAppRoot = null;
        this.handler = null;
        this.handleInterceptor = null;
        this.chain = null;
        this.contextLength = 0;
        this.securityInterceptor = null;
        this.welcomeFiles = null;
        this.objectName = null;
        this.configurationBaseURL = null;
    }

    public JettyWebAppContext(String objectName, String originalSpecDD, Map componentContext, ClassLoader classLoader, URL configurationBaseUrl, Set unshareableResources, Set applicationManagedSecurityResources, String displayName, Map contextParamMap, Collection listenerClassNames, boolean distributable, Map mimeMap, String[] welcomeFiles, Map localeEncodingMapping, Map errorPages, Authenticator authenticator, String realmName, Map tagLibMap, int sessionTimeoutSeconds, WebApplicationHandlerFactory handlerFactory, HandleInterceptor handleInterceptor, String policyContextID, String securityRealmName, DefaultPrincipal defaultPrincipal, PermissionCollection checkedPermissions, PermissionCollection excludedPermissions, Host host, TransactionManager transactionManager, TrackedConnectionAssociator trackedConnectionAssociator, JettyContainer jettyContainer, J2EEServer server, J2EEApplication application, Kernel kernel) throws Exception, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (!$assertionsDisabled && componentContext == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && classLoader == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && configurationBaseUrl == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && transactionManager == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && trackedConnectionAssociator == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && jettyContainer == null) {
            throw new AssertionError();
        }
        this.server = server;
        this.application = application;
        this.objectName = objectName;
        if (objectName != null) {
            ObjectName myObjectName = ObjectNameUtil.getObjectName((String)objectName);
            this.verifyObjectName(myObjectName);
        }
        this.configurationBaseURL = configurationBaseUrl;
        this.jettyContainer = jettyContainer;
        this.originalSpecDD = originalSpecDD;
        this.handleInterceptor = handleInterceptor;
        this.setConfigurationClassNames(new String[0]);
        this.webAppRoot = configurationBaseUrl.toString();
        this.webClassLoader = classLoader;
        this.setClassLoader(this.webClassLoader);
        if (host != null) {
            this.setHosts(host.getHosts());
            this.setVirtualHosts(host.getVirtualHosts());
        }
        this.handler = handlerFactory.createHandler();
        this.addHandler((HttpHandler)this.handler);
        this.setDisplayName(displayName);
        this.setContextParamMap(contextParamMap);
        this.setListenerClassNames(listenerClassNames);
        this.setDistributable(distributable);
        this.setMimeMap(mimeMap);
        this.welcomeFiles = welcomeFiles;
        this.setLocaleEncodingMapping(localeEncodingMapping);
        this.setErrorPages(errorPages);
        this.setAuthenticator(authenticator);
        this.setRealmName(realmName);
        this.setTagLibMap(tagLibMap);
        if (!distributable) {
            this.setSessionTimeoutSeconds(sessionTimeoutSeconds);
        }
        GeronimoUserTransaction userTransaction = new GeronimoUserTransaction(transactionManager);
        Context enc = EnterpriseNamingContext.createEnterpriseNamingContext((Map)componentContext, (UserTransaction)userTransaction, (Kernel)kernel, (ClassLoader)this.webClassLoader);
        int index = 0;
        BeforeAfter interceptor = new InstanceContextBeforeAfter(null, index++, index++, unshareableResources, applicationManagedSecurityResources, trackedConnectionAssociator);
        interceptor = new ComponentContextBeforeAfter(interceptor, index++, enc);
        interceptor = new ThreadClassloaderBeforeAfter(interceptor, index++, index++, this.webClassLoader);
        interceptor = new WebApplicationContextBeforeAfter(interceptor, index++, this);
        if (securityRealmName != null) {
            InternalJAASJettyRealm internalJAASJettyRealm = jettyContainer.addRealm(securityRealmName);
            JAASJettyRealm realm = new JAASJettyRealm(realmName, internalJAASJettyRealm);
            this.setRealm(realm);
            this.securityInterceptor = new SecurityContextBeforeAfter(interceptor, index++, index++, policyContextID, defaultPrincipal, authenticator, checkedPermissions, excludedPermissions, realm, classLoader);
            interceptor = this.securityInterceptor;
        } else {
            this.securityInterceptor = null;
        }
        this.chain = interceptor;
        this.contextLength = index;
        FilterHolder jsr154FilterHolder = new FilterHolder((HttpHandler)this.handler, "jsr154", JSR154Filter.class.getName());
        this.handler.addFilterHolder(jsr154FilterHolder);
        jsr154FilterHolder.setInitParameter("unwrappedDispatch", "true");
        this.handler.addFilterPathMapping("/*", "jsr154", 15);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public URL getWARDirectory() {
        return this.configurationBaseURL;
    }

    public String getWARName() {
        try {
            return ObjectName.getInstance(this.objectName).getKeyProperty("name");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public WebContainer getContainer() {
        return this.jettyContainer;
    }

    public URL getURLFor() {
        WebConnector[] connectors = (WebConnector[])this.jettyContainer.getConnectors();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < connectors.length; ++i) {
            WebConnector connector = connectors[i];
            map.put(connector.getProtocol(), connector.getConnectUrl());
        }
        String urlPrefix = (String)map.get("HTTP");
        if (urlPrefix == null && (urlPrefix = (String)map.get("HTTPS")) == null) {
            urlPrefix = (String)map.get("AJP");
        }
        if (urlPrefix == null) {
            return null;
        }
        try {
            return new URL(urlPrefix + this.getContextPath());
        }
        catch (MalformedURLException e) {
            log.error((Object)"Bad URL to connect to web app", (Throwable)e);
            return null;
        }
    }

    public Object enterContextScope(HttpRequest httpRequest, HttpResponse httpResponse) {
        Object[] context = new Object[this.contextLength];
        this.chain.before(context, httpRequest, httpResponse);
        return context;
    }

    public void leaveContextScope(HttpRequest httpRequest, HttpResponse httpResponse, Object oldScope) {
        Object[] context = (Object[])oldScope;
        this.chain.after(context, httpRequest, httpResponse);
    }

    public void handle(HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        super.handle(httpRequest, httpResponse);
    }

    public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        ServletHttpRequest request = (ServletHttpRequest)httpRequest.getWrapper();
        if (null == request) {
            request = new GeronimoServletHttpRequest((ServletHandler)this.handler, null, httpRequest);
            ServletHttpResponse response = new ServletHttpResponse(request, httpResponse);
            httpRequest.setWrapper((Object)request);
            httpResponse.setWrapper((Object)response);
        }
        ((GeronimoServletHttpRequest)request).setRequestedSessionId(pathParams);
        if (null != this.handleInterceptor) {
            this.handleInterceptor.handle(pathInContext, pathParams, httpRequest, httpResponse, new EndHandleInterceptor());
        } else {
            super.handle(pathInContext, pathParams, httpRequest, httpResponse);
        }
    }

    public ClassLoader getWebClassLoader() {
        return this.webClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        this.setClassLoader(this.webClassLoader);
        if (!this.isStarting()) {
            super.start();
            return;
        }
        ((AbstractSessionManager)this.getServletHandler().getSessionManager()).setUseRequestedId(true);
        this.setWAR(this.webAppRoot);
        this.jettyContainer.addContext((HttpContext)this);
        Object context = this.enterContextScope(null, null);
        try {
            super.doStart();
        }
        finally {
            this.leaveContextScope(null, null, context);
        }
        this.setWelcomeFiles(this.welcomeFiles);
        log.debug((Object)"JettyWebAppContext started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        if (!this.isStopping()) {
            super.stop();
            return;
        }
        if (this.securityInterceptor != null) {
            this.securityInterceptor.stop(this.jettyContainer);
        }
        Object context = this.enterContextScope(null, null);
        try {
            super.doStop();
        }
        finally {
            this.leaveContextScope(null, null, context);
            this.jettyContainer.removeContext((HttpContext)this);
        }
        LogFactory.release((ClassLoader)this.webClassLoader);
        log.debug((Object)"JettyWebAppContext stopped");
    }

    public void doFail() {
        try {
            super.stop();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.warn((Object)"JettyWebAppContext failed");
    }

    public void setContextParamMap(Map initParameters) {
        if (initParameters != null) {
            Iterator iterator = initParameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.setInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setLocaleEncodingMapping(Map localeEncodingMap) {
        if (localeEncodingMap != null) {
            Iterator iterator = localeEncodingMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.addLocaleEncoding((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setListenerClassNames(Collection eventListeners) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (eventListeners != null) {
            Iterator iterator = eventListeners.iterator();
            while (iterator.hasNext()) {
                String listenerClassName = (String)iterator.next();
                Class clazz = this.loadClass(listenerClassName);
                EventListener listener = (EventListener)clazz.newInstance();
                this.addEventListener(listener);
                this.handler.addEventListener(listener);
            }
        }
    }

    public void setErrorPages(Map errorPageMap) {
        if (errorPageMap != null) {
            Iterator iterator = errorPageMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.setErrorPage((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setTagLibMap(Map tagLibMap) {
        if (tagLibMap != null) {
            Iterator iterator = tagLibMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.setResourceAlias((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setSessionTimeoutSeconds(int seconds) {
        this.handler.setSessionInactiveInterval(seconds);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        super.setDisplayName(displayName);
    }

    public String getDeploymentDescriptor() {
        return this.originalSpecDD;
    }

    public String getServer() {
        return this.server.getObjectName();
    }

    public String getApplication() {
        if (this.application == null) {
            return null;
        }
        return this.application.getObjectName();
    }

    public String[] getJavaVMs() {
        return this.server.getJavaVMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getServlets() {
        Set set = this.servletNames;
        synchronized (set) {
            return this.servletNames.toArray(new String[this.servletNames.size()]);
        }
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"WebModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("WebModule object name j2eeType property must be 'WebModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("WebModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("WebModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServletHolder(ServletHolder servletHolder, String servletName, Set servletMappings, String objectName) throws Exception {
        this.handler.addServletHolder(servletHolder);
        if (servletMappings != null) {
            Iterator iterator = servletMappings.iterator();
            while (iterator.hasNext()) {
                String urlPattern = (String)iterator.next();
                this.handler.mapPathToServlet(urlPattern, servletName);
            }
        }
        Object context = this.enterContextScope(null, null);
        try {
            servletHolder.start();
        }
        finally {
            this.leaveContextScope(null, null, context);
        }
        if (objectName != null) {
            Set set = this.servletNames;
            synchronized (set) {
                this.servletNames.add(objectName);
            }
        }
    }

    public boolean checkSecurityConstraints(String pathInContext, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (this.securityInterceptor != null) {
            return this.securityInterceptor.checkSecurityConstraints(pathInContext, request, response);
        }
        return super.checkSecurityConstraints(pathInContext, request, response);
    }

    private void doHandle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        super.handle(pathInContext, pathParams, httpRequest, httpResponse);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !JettyWebAppContext.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)JettyWebAppContext.class);
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"Jetty WebApplication Context", (Class)JettyWebAppContext.class, (String)"WebModule");
        infoBuilder.addAttribute("deploymentDescriptor", String.class, true);
        infoBuilder.addAttribute("displayName", String.class, true);
        infoBuilder.addAttribute("contextParamMap", Map.class, true);
        infoBuilder.addAttribute("listenerClassNames", Collection.class, true);
        infoBuilder.addAttribute("distributable", Boolean.TYPE, true);
        infoBuilder.addAttribute("mimeMap", Map.class, true);
        infoBuilder.addAttribute("welcomeFiles", String;.class, true);
        infoBuilder.addAttribute("localeEncodingMapping", Map.class, true);
        infoBuilder.addAttribute("errorPages", Map.class, true);
        infoBuilder.addAttribute("authenticator", Authenticator.class, true);
        infoBuilder.addAttribute("realmName", String.class, true);
        infoBuilder.addAttribute("tagLibMap", Map.class, true);
        infoBuilder.addAttribute(GBEAN_ATTR_SESSION_TIMEOUT, Integer.TYPE, true);
        infoBuilder.addReference(GBEAN_REF_WEB_APPLICATION_HANDLER_FACTORY, WebApplicationHandlerFactory.class, "GBean");
        infoBuilder.addReference(GBEAN_REF_HANDLE_INTERCEPTOR, HandleInterceptor.class, "GBean");
        infoBuilder.addAttribute("componentContext", Map.class, true);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("configurationBaseUrl", URL.class, true);
        infoBuilder.addAttribute("unshareableResources", Set.class, true);
        infoBuilder.addAttribute("applicationManagedSecurityResources", Set.class, true);
        infoBuilder.addAttribute("contextPath", String.class, true);
        infoBuilder.addReference("Host", Host.class, "Host");
        infoBuilder.addReference("TransactionManager", TransactionManager.class, "TransactionManager");
        infoBuilder.addReference("TrackedConnectionAssociator", TrackedConnectionAssociator.class, "JCAConnectionTracker");
        infoBuilder.addReference("JettyContainer", JettyContainer.class, "GBean");
        infoBuilder.addInterface(JettyServletRegistration.class);
        infoBuilder.addAttribute("policyContextID", String.class, true);
        infoBuilder.addAttribute("securityRealmName", String.class, true);
        infoBuilder.addAttribute("defaultPrincipal", DefaultPrincipal.class, true);
        infoBuilder.addAttribute("checkedPermissions", PermissionCollection.class, true);
        infoBuilder.addAttribute("excludedPermissions", PermissionCollection.class, true);
        infoBuilder.addReference("J2EEServer", J2EEServer.class);
        infoBuilder.addReference("J2EEApplication", J2EEApplication.class);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addAttribute("server", String.class, false);
        infoBuilder.addAttribute("application", String.class, false);
        infoBuilder.addAttribute("javaVMs", String;.class, false);
        infoBuilder.addAttribute("servlets", String;.class, false);
        infoBuilder.addInterface(WebModule.class);
        infoBuilder.setConstructor(new String[]{"objectName", "deploymentDescriptor", "componentContext", "classLoader", "configurationBaseUrl", "unshareableResources", "applicationManagedSecurityResources", "displayName", "contextParamMap", "listenerClassNames", "distributable", "mimeMap", "welcomeFiles", "localeEncodingMapping", "errorPages", "authenticator", "realmName", "tagLibMap", GBEAN_ATTR_SESSION_TIMEOUT, GBEAN_REF_WEB_APPLICATION_HANDLER_FACTORY, GBEAN_REF_HANDLE_INTERCEPTOR, "policyContextID", "securityRealmName", "defaultPrincipal", "checkedPermissions", "excludedPermissions", "Host", "TransactionManager", "TrackedConnectionAssociator", "JettyContainer", "J2EEServer", "J2EEApplication", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    private class EndHandleInterceptor
    implements HandleInterceptor {
        private EndHandleInterceptor() {
        }

        public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse, HandleInterceptor end) throws HttpException, IOException {
            JettyWebAppContext.this.doHandle(pathInContext, pathParams, httpRequest, httpResponse);
        }
    }
}

