/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.cluster.wadi;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.clustering.ClusteredInvocation;
import org.apache.geronimo.clustering.ClusteredInvocationException;
import org.apache.geronimo.clustering.wadi.WADISessionManager;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty.HandleInterceptor;
import org.apache.geronimo.jetty.cluster.AbstractClusteredHandleInterceptor;
import org.codehaus.wadi.Invocation;
import org.codehaus.wadi.InvocationException;
import org.codehaus.wadi.InvocationProxy;
import org.codehaus.wadi.impl.ClusteredManager;
import org.codehaus.wadi.web.impl.WebInvocation;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletHttpResponse;

public class WADIClusteredHandleInterceptor
extends AbstractClusteredHandleInterceptor
implements GBeanLifecycle {
    private final WADISessionManager sessionManager;
    private ClusteredManager wadiManager;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_REF_WADI_SESSION_MANAGER = "WADISessionManager";

    public WADIClusteredHandleInterceptor(WADISessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void doStart() throws Exception {
        this.wadiManager = this.sessionManager.getManager();
    }

    public void doStop() throws Exception {
        this.wadiManager = null;
    }

    public void doFail() {
        this.wadiManager = null;
    }

    protected ClusteredInvocation newClusteredInvocation(String pathInContext, String pathParams, HttpRequest request, HttpResponse response, HandleInterceptor end) {
        return new WADIWebClusteredInvocation(pathInContext, pathParams, request, response, end);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"WADI Clustered Handle Interceptor", (Class)WADIClusteredHandleInterceptor.class, (String)"GBean");
        infoBuilder.addReference(GBEAN_REF_WADI_SESSION_MANAGER, WADISessionManager.class, "GBean");
        infoBuilder.setConstructor(new String[]{GBEAN_REF_WADI_SESSION_MANAGER});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    protected class WADIWebClusteredInvocation
    extends AbstractClusteredHandleInterceptor.WebClusteredInvocation {
        public WADIWebClusteredInvocation(String pathInContext, String pathParams, HttpRequest request, HttpResponse response, HandleInterceptor end) {
            super((AbstractClusteredHandleInterceptor)WADIClusteredHandleInterceptor.this, pathInContext, pathParams, request, response, end);
        }

        public void invoke() throws ClusteredInvocationException {
            ServletHttpRequest servletHttpRequest = (ServletHttpRequest)this.request.getWrapper();
            ServletHttpResponse servletHttpResponse = (ServletHttpResponse)this.response.getWrapper();
            WebInvocation invocation = new WebInvocation();
            FilterChain chainAdapter = new FilterChain(){

                public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                    try {
                        WADIWebClusteredInvocation.this.invokeLocally();
                    }
                    catch (ClusteredInvocationException e) {
                        throw (IOException)new IOException().initCause(e);
                    }
                }
            };
            InvocationProxy invocationProxy = WADIClusteredHandleInterceptor.this.wadiManager.getInvocationProxy();
            invocation.init((HttpServletRequest)servletHttpRequest, (HttpServletResponse)servletHttpResponse, chainAdapter, invocationProxy);
            try {
                WADIClusteredHandleInterceptor.this.wadiManager.contextualise((Invocation)invocation);
            }
            catch (InvocationException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof IOException) {
                    throw new ClusteredInvocationException(throwable);
                }
                if (throwable instanceof ServletException) {
                    throw new ClusteredInvocationException(throwable);
                }
                throw new ClusteredInvocationException((Throwable)e);
            }
        }
    }
}

