/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.PortInfo;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.info.HandlerChainInfo;
import org.apache.geronimo.jaxws.info.HandlerInfo;
import org.apache.xbean.osgi.bundle.util.BundleClassLoader;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoHandlerChainBuilder {
    private static final Logger logger = LoggerFactory.getLogger(GeronimoHandlerChainBuilder.class);
    private Bundle bundle = null;
    private PortInfo portInfo;

    public GeronimoHandlerChainBuilder(Bundle bundle, PortInfo portInfo) {
        this.bundle = bundle;
        this.portInfo = portInfo;
    }

    public Bundle getHandlerBundle() {
        return this.bundle;
    }

    protected List<Handler> buildHandlerChain(HandlerChainInfo hc, Bundle bundle) {
        if (this.matchServiceName(this.portInfo, hc) && this.matchPortName(this.portInfo, hc) && this.matchBinding(this.portInfo, hc)) {
            return this.buildHandlerChain(hc, (ClassLoader)new BundleClassLoader(bundle));
        }
        return Collections.emptyList();
    }

    protected List<Handler> buildHandlerChain(HandlerChainInfo handlerChainInfo, ClassLoader classLoader) {
        ArrayList<Handler> handlerChain = new ArrayList<Handler>(handlerChainInfo.handlers.size());
        for (HandlerInfo handlerInfo : handlerChainInfo.handlers) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("loading handler :" + this.trimString(handlerInfo.handlerName));
                }
                Class<Handler> handlerClass = Class.forName(this.trimString(handlerInfo.handlerClass), true, classLoader).asSubclass(Handler.class);
                Handler handler = handlerClass.newInstance();
                if (logger.isDebugEnabled()) {
                    logger.debug("adding handler to chain: " + handler);
                }
                handlerChain.add(handler);
            }
            catch (Exception e) {
                throw new WebServiceException("Failed to instantiate handler", (Throwable)e);
            }
        }
        return handlerChain;
    }

    private boolean matchServiceName(PortInfo info, HandlerChainInfo hc) {
        if (hc.serviceNamePattern != null) {
            QName serviceName = info == null ? null : info.getServiceName();
            return this.match(serviceName, hc.serviceNamePattern);
        }
        return true;
    }

    private boolean matchPortName(PortInfo info, HandlerChainInfo hc) {
        if (hc.portNamePattern != null) {
            QName portName = info == null ? null : info.getPortName();
            return this.match(portName, hc.portNamePattern);
        }
        return true;
    }

    private boolean matchBinding(PortInfo info, HandlerChainInfo hc) {
        return this.match(info == null ? null : info.getBindingID(), hc.protocolBindings);
    }

    private boolean match(String binding, List<String> bindings) {
        if (binding == null) {
            return bindings == null || bindings.isEmpty();
        }
        if (bindings == null || bindings.isEmpty()) {
            return true;
        }
        String actualBindingURI = JAXWSUtils.getBindingURI(binding);
        for (String bindingToken : bindings) {
            String bindingURI = JAXWSUtils.getBindingURI(bindingToken);
            if (!actualBindingURI.equals(bindingURI)) continue;
            return true;
        }
        return false;
    }

    public List<Handler> buildHandlerChainFromConfiguration(HandlerChainInfo handlerChainInfo) {
        if (handlerChainInfo == null) {
            return null;
        }
        return this.sortHandlers(this.buildHandlerChain(handlerChainInfo, this.getHandlerBundle()));
    }

    private String trimString(String str) {
        return str != null ? str.trim() : null;
    }

    public List<Handler> sortHandlers(List<Handler> handlers) {
        ArrayList<LogicalHandler> logicalHandlers = new ArrayList<LogicalHandler>();
        ArrayList<Handler> protocolHandlers = new ArrayList<Handler>();
        for (Handler handler : handlers) {
            if (handler instanceof LogicalHandler) {
                logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            protocolHandlers.add(handler);
        }
        ArrayList<Handler> sortedHandlers = new ArrayList<Handler>();
        sortedHandlers.addAll(logicalHandlers);
        sortedHandlers.addAll(protocolHandlers);
        return sortedHandlers;
    }

    private boolean match(QName name, QName namePattern) {
        if (name == null) {
            return namePattern == null || namePattern.getLocalPart().equals("*");
        }
        if (namePattern == null) {
            return true;
        }
        String localNamePattern = namePattern.getLocalPart();
        if (!namePattern.getNamespaceURI().equals(name.getNamespaceURI())) {
            return false;
        }
        if ((localNamePattern = localNamePattern.trim()).contains("*")) {
            Pattern pattern = Pattern.compile(localNamePattern.replace("*", "(\\w|\\.|-|_)*"));
            Matcher matcher = pattern.matcher(name.getLocalPart());
            return matcher.matches();
        }
        return localNamePattern.equals(name.getLocalPart());
    }
}

