/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSDLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WSDLUtils.class);

    public static void trimDefinition(Definition def, Map<QName, Set<String>> servicePortNamesMap) {
        Map services = def.getServices();
        if (services == null) {
            return;
        }
        ArrayList<QName> servicesToRemove = new ArrayList<QName>(services.size());
        for (Map.Entry serviceEntry : services.entrySet()) {
            QName currServiceName = (QName)serviceEntry.getKey();
            if (servicePortNamesMap.containsKey(currServiceName)) {
                Service service = (Service)serviceEntry.getValue();
                WSDLUtils.trimService(service, servicePortNamesMap.get(currServiceName));
                continue;
            }
            servicesToRemove.add(currServiceName);
        }
        for (QName serviceToRemove : servicesToRemove) {
            def.removeService(serviceToRemove);
        }
    }

    public static void trimDefinition(Definition def, String serviceName, String portName) {
        Map services = def.getServices();
        if (services == null) {
            return;
        }
        ArrayList<QName> servicesToRemove = new ArrayList<QName>(services.size());
        for (Map.Entry serviceEntry : services.entrySet()) {
            QName currServiceName = (QName)serviceEntry.getKey();
            if (currServiceName.getLocalPart().equals(serviceName)) {
                Service service = (Service)serviceEntry.getValue();
                WSDLUtils.trimService(service, portName);
                continue;
            }
            servicesToRemove.add(currServiceName);
        }
        for (QName serviceToRemove : servicesToRemove) {
            def.removeService(serviceToRemove);
        }
    }

    public static void trimService(Service service, String portName) {
        WSDLUtils.trimService(service, Collections.singleton(portName));
    }

    public static void trimService(Service service, Set<String> portName) {
        Map ports = service.getPorts();
        if (ports == null) {
            return;
        }
        ArrayList<String> portsToRemove = new ArrayList<String>(ports.size());
        for (Map.Entry portEntry : ports.entrySet()) {
            String currPortName = (String)portEntry.getKey();
            if (portName.contains(currPortName)) continue;
            portsToRemove.add(currPortName);
        }
        for (String portToRemove : portsToRemove) {
            service.removePort(portToRemove);
        }
    }

    public static void updateLocations(Definition def, Map<QName, Map<String, String>> servicePortNameLocationMap) {
        Map services = def.getServices();
        if (services == null) {
            return;
        }
        for (Map.Entry serviceEntry : services.entrySet()) {
            Service service = (Service)serviceEntry.getValue();
            Map<String, String> portNameLocationMap = servicePortNameLocationMap.get(service.getQName());
            if (portNameLocationMap == null) continue;
            WSDLUtils.updateLocations(service, portNameLocationMap);
        }
    }

    public static void updateLocations(Service service, Map<String, String> portNameLocationsMap) {
        Map ports = service.getPorts();
        if (ports == null) {
            return;
        }
        for (Map.Entry portEntry : ports.entrySet()) {
            Port port = (Port)portEntry.getValue();
            String location = portNameLocationsMap.get(port.getName());
            if (location == null) continue;
            WSDLUtils.updateLocations(port, location);
        }
    }

    public static void updateLocations(Definition def, String location) {
        Map services = def.getServices();
        if (services == null) {
            return;
        }
        for (Map.Entry serviceEntry : services.entrySet()) {
            Service service = (Service)serviceEntry.getValue();
            WSDLUtils.updateLocations(service, location);
        }
    }

    public static void updateLocations(Service service, String location) {
        Map ports = service.getPorts();
        if (ports == null) {
            return;
        }
        for (Map.Entry portEntry : ports.entrySet()) {
            Port port = (Port)portEntry.getValue();
            WSDLUtils.updateLocations(port, location);
        }
    }

    public static void updateLocations(Port port, String location) {
        List exts = port.getExtensibilityElements();
        if (exts == null) {
            return;
        }
        for (Object extension : exts) {
            if (extension instanceof SOAP12Address) {
                ((SOAP12Address)extension).setLocationURI(location);
                continue;
            }
            if (extension instanceof SOAPAddress) {
                ((SOAPAddress)extension).setLocationURI(location);
                continue;
            }
            if (!(extension instanceof HTTPAddress)) continue;
            ((HTTPAddress)extension).setLocationURI(location);
        }
    }
}

