/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.wsdl.xml.WSDLLocator;
import org.xml.sax.InputSource;

public class JarWSDLLocator
implements WSDLLocator {
    private final List<InputStream> streams = new ArrayList<InputStream>();
    private final JarFile moduleFile;
    private final URI wsdlURI;
    private URI latestImportURI;

    public JarWSDLLocator(JarFile moduleFile, URI wsdlURI) {
        this.moduleFile = moduleFile;
        this.wsdlURI = wsdlURI;
    }

    public InputSource getBaseInputSource() {
        return this.resolve("", this.wsdlURI.toString());
    }

    public String getBaseURI() {
        return this.wsdlURI.toString();
    }

    public InputSource getImportInputSource(String parentLocation, String relativeLocation) {
        return this.resolve(parentLocation, relativeLocation);
    }

    protected InputSource resolve(String parentLocation, String relativeLocation) {
        InputStream importInputStream;
        URI parentURI = URI.create(parentLocation);
        URI relativeURI = URI.create(relativeLocation);
        if (relativeURI.isAbsolute()) {
            this.latestImportURI = relativeURI;
            importInputStream = this.getExternalFile(this.latestImportURI);
        } else if (parentURI.isAbsolute()) {
            this.latestImportURI = this.resolveRelative(parentURI, relativeURI);
            importInputStream = this.getExternalFile(this.latestImportURI);
        } else {
            this.latestImportURI = parentURI.resolve(relativeLocation);
            importInputStream = this.getModuleFile(this.latestImportURI);
        }
        this.streams.add(importInputStream);
        InputSource inputSource = new InputSource(importInputStream);
        inputSource.setSystemId(this.getLatestImportURI());
        return inputSource;
    }

    public String getLatestImportURI() {
        return this.latestImportURI.toString();
    }

    private URI resolveRelative(URI parentURI, URI relativeURI) {
        String str;
        int i;
        if ("jar".equals(parentURI.getScheme()) && (i = (str = parentURI.toString()).indexOf(33)) != -1) {
            String jarBase = str.substring(0, i + 1);
            String jarEntry = str.substring(i + 1);
            URI jarEntryURI = URI.create(jarEntry);
            URI resolvedRelatvieURI = jarEntryURI.resolve(relativeURI);
            return URI.create(jarBase + resolvedRelatvieURI.toString());
        }
        return parentURI.resolve(relativeURI);
    }

    private InputStream getExternalFile(URI file) {
        try {
            return file.toURL().openStream();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to import external file: " + this.latestImportURI, e);
        }
    }

    private InputStream getModuleFile(URI file) {
        ZipEntry entry = this.moduleFile.getEntry(file.toString());
        if (entry == null) {
            throw new RuntimeException("File does not exist in the module: " + file);
        }
        try {
            return this.moduleFile.getInputStream(entry);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not open stream to import file", e);
        }
    }

    public void close() {
        for (InputStream inputStream : this.streams) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.streams.clear();
    }
}

