/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.client;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.NoOp;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastConstructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.jaxws.client.EndpointInfo;
import org.apache.geronimo.jaxws.client.GenericService;
import org.apache.geronimo.jaxws.client.PortMethodFilter;
import org.apache.geronimo.jaxws.client.PortMethodInterceptor;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.reference.ClassLoaderAwareReference;
import org.apache.geronimo.naming.reference.KernelAwareReference;
import org.apache.geronimo.naming.reference.SimpleReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXWSServiceReference
extends SimpleReference
implements ClassLoaderAwareReference,
KernelAwareReference {
    private static final Log LOG = LogFactory.getLog(JAXWSServiceReference.class);
    private static final Class[] URL_SERVICE_NAME_CONSTRUCTOR = new Class[]{URL.class, QName.class};
    protected String serviceClassName;
    protected ClassLoader classLoader;
    protected AbstractName moduleName;
    protected URI wsdlURI;
    protected QName serviceQName;
    private Kernel kernel;
    protected String handlerChainsXML;
    protected Map<Object, EndpointInfo> seiInfoMap;
    protected String referenceClassName;
    protected Class enhancedServiceClass;
    protected Callback[] methodInterceptors;
    protected FastConstructor serviceConstructor;

    public JAXWSServiceReference(String handlerChainsXML, Map<Object, EndpointInfo> seiInfoMap, AbstractName name, QName serviceQName, URI wsdlURI, String referenceClassName, String serviceClassName) {
        this.handlerChainsXML = handlerChainsXML;
        this.seiInfoMap = seiInfoMap;
        this.moduleName = name;
        this.serviceQName = serviceQName;
        this.wsdlURI = wsdlURI;
        this.referenceClassName = referenceClassName;
        this.serviceClassName = serviceClassName;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    private Class loadClass(String name) throws NamingException {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            NamingException exception = new NamingException("Count not load class " + name);
            exception.initCause(e);
            throw exception;
        }
    }

    private URL getWsdlURL() {
        if (this.wsdlURI == null) {
            return null;
        }
        try {
            return new URL(this.wsdlURI.toString());
        }
        catch (MalformedURLException e1) {
            try {
                URL moduleBaseUrl = (URL)this.kernel.getAttribute(this.moduleName, "configurationBaseUrl");
                return new URL(moduleBaseUrl.toString() + this.wsdlURI.toString());
            }
            catch (Exception e) {
                URL wsdlURL = this.classLoader.getResource(this.wsdlURI.toString());
                if (wsdlURL == null) {
                    LOG.warn((Object)("Error obtaining WSDL: " + this.wsdlURI), (Throwable)e);
                }
                return wsdlURL;
            }
        }
    }

    private Class getReferenceClass() throws NamingException {
        return this.referenceClassName != null ? this.loadClass(this.referenceClassName) : null;
    }

    public Object getContent() throws NamingException {
        Service instance = null;
        URL wsdlURL = this.getWsdlURL();
        Class<GenericService> serviceClass = this.loadClass(this.serviceClassName);
        Class referenceClass = this.getReferenceClass();
        if (referenceClass != null && Service.class.isAssignableFrom(referenceClass)) {
            serviceClass = referenceClass;
        }
        if (Service.class.equals((Object)serviceClass)) {
            serviceClass = GenericService.class;
        }
        instance = this.createServiceProxy(serviceClass, this.classLoader, this.serviceQName, wsdlURL);
        HandlerResolver handlerResolver = this.getHandlerResolver(serviceClass);
        if (handlerResolver != null) {
            instance.setHandlerResolver(handlerResolver);
        }
        if (referenceClass != null && !Service.class.isAssignableFrom(referenceClass)) {
            return instance.getPort(referenceClass);
        }
        return instance;
    }

    protected abstract HandlerResolver getHandlerResolver(Class var1);

    protected PortMethodInterceptor getPortMethodInterceptor() {
        return new PortMethodInterceptor(this.seiInfoMap);
    }

    private Service createServiceProxy(Class superClass, ClassLoader classLoader, QName serviceName, URL wsdlLocation) throws NamingException {
        if (this.serviceConstructor == null) {
            PortMethodInterceptor callback = this.getPortMethodInterceptor();
            this.methodInterceptors = new Callback[]{NoOp.INSTANCE, callback};
            Enhancer enhancer = new Enhancer();
            enhancer.setClassLoader(classLoader);
            enhancer.setSuperclass(superClass);
            enhancer.setCallbackFilter((CallbackFilter)new PortMethodFilter());
            enhancer.setCallbackTypes(new Class[]{NoOp.class, MethodInterceptor.class});
            enhancer.setUseFactory(false);
            enhancer.setUseCache(false);
            this.enhancedServiceClass = enhancer.createClass();
            this.serviceConstructor = FastClass.create((Class)this.enhancedServiceClass).getConstructor(URL_SERVICE_NAME_CONSTRUCTOR);
        }
        LOG.debug((Object)("Initializing service with: " + wsdlLocation + " " + serviceName));
        Enhancer.registerCallbacks((Class)this.enhancedServiceClass, (Callback[])this.methodInterceptors);
        Object[] arguments = new Object[]{wsdlLocation, serviceName};
        try {
            return (Service)this.serviceConstructor.newInstance(arguments);
        }
        catch (InvocationTargetException e) {
            NamingException exception = new NamingException("Could not construct service proxy");
            exception.initCause(e.getTargetException());
            throw exception;
        }
    }
}

