/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.sun.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.wsdl.WsdlGeneratorOptions;
import org.apache.geronimo.jaxws.builder.wsdl.WsdlGeneratorUtils;
import org.apache.geronimo.jaxws.sun.tools.JAXWSTools;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsdlGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(WsdlGenerator.class);
    private JAXWSTools jaxwsTools;
    private WsdlGeneratorOptions options;

    public WsdlGenerator(WsdlGeneratorOptions options) {
        this.options = options;
        this.jaxwsTools = new JAXWSTools();
        this.jaxwsTools.setOverrideContextClassLoader(true);
        if (options.getSAAJ() == WsdlGeneratorOptions.SAAJ.SUN) {
            this.jaxwsTools.setUseSunSAAJ();
        } else if (options.getSAAJ() == WsdlGeneratorOptions.SAAJ.Axis2) {
            this.jaxwsTools.setUseAxis2SAAJ();
        }
    }

    private URL[] getWsgenClasspath(DeploymentContext context) throws Exception {
        ConfigurationManager cm = context.getConfigurationManager();
        Collection repositories = cm.getRepositories();
        File[] jars = this.jaxwsTools.getClasspath(repositories);
        return JAXWSTools.toURL(jars);
    }

    private String getEndorsedPath(DeploymentContext context) throws Exception {
        ConfigurationManager cm = context.getConfigurationManager();
        Collection repositories = cm.getRepositories();
        return this.jaxwsTools.getEndorsedPath(repositories);
    }

    private String[] buildArguments(String sei, String classPath, File moduleBaseDir, PortInfo portInfo) throws Exception {
        QName portName;
        ArrayList<String> arguments = new ArrayList<String>(11);
        arguments.add("-cp");
        arguments.add(classPath);
        arguments.add("-keep");
        arguments.add("-wsdl");
        arguments.add("-d");
        arguments.add(moduleBaseDir.getAbsolutePath());
        QName serviceName = this.options.getWsdlService();
        if (serviceName != null) {
            arguments.add("-servicename");
            arguments.add(serviceName.toString());
        }
        if ((portName = this.options.getWsdlPort()) != null) {
            arguments.add("-portname");
            arguments.add(portName.toString());
        }
        arguments.add(sei);
        return arguments.toArray(new String[0]);
    }

    private File findWsdlFile(File baseDir, PortInfo portInfo) {
        QName serviceQName = this.options.getWsdlService();
        String serviceName = serviceQName == null ? null : serviceQName.getLocalPart();
        return WsdlGeneratorUtils.findWsdlFile((File)baseDir, (String)serviceName);
    }

    public String generateWsdl(Module module, String serviceClass, DeploymentContext context, PortInfo portInfo) throws DeploymentException {
        URL[] urls;
        File baseDir;
        File moduleBase = module.getEarContext().getInPlaceConfigurationDir();
        if (moduleBase == null) {
            moduleBase = module.getEarContext().getBaseDir();
        }
        File moduleBaseDir = moduleBase.isFile() ? moduleBase.getParentFile() : moduleBase;
        try {
            baseDir = WsdlGeneratorUtils.createTempDirectory((File)moduleBaseDir);
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
        StringBuilder classPathBuilder = new StringBuilder();
        try {
            urls = this.getWsgenClasspath(context);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to generate the wsdl file using wsgen: unable to get the location of the required artifact(s).", (Throwable)e);
        }
        if (urls != null && urls.length > 0) {
            for (URL url : urls) {
                classPathBuilder.append(WsdlGeneratorUtils.toFile((URL)url).getAbsolutePath()).append(File.pathSeparator);
            }
        }
        String wsgenToolClassPath = classPathBuilder.toString();
        try {
            WsdlGeneratorUtils.getModuleClasspath((Module)module, (DeploymentContext)context, (StringBuilder)classPathBuilder);
        }
        catch (Exception e) {
            throw new DeploymentException("WSDL generation failed: unable to determine module classpath", (Throwable)e);
        }
        try {
            String[] arguments = this.buildArguments(serviceClass, classPathBuilder.toString(), baseDir, portInfo);
            boolean result = false;
            if (this.options.getFork()) {
                String endorsedPath = this.getEndorsedPath(context);
                result = this.forkWsgen(wsgenToolClassPath, endorsedPath, arguments);
            } else {
                result = this.invokeWsgen(urls, arguments);
            }
            if (result) {
                File wsdlFile = this.findWsdlFile(baseDir, portInfo);
                if (wsdlFile == null) {
                    throw new DeploymentException("Unable to find the service wsdl file");
                }
                if (this.options.getAddToClassPath()) {
                    String wsdlPath = WsdlGeneratorUtils.getRelativeNameOrURL((File)moduleBase, (File)wsdlFile.getParentFile());
                    if (wsdlPath.endsWith("/")) {
                        wsdlPath = wsdlPath.substring(0, wsdlPath.length() - 1);
                    }
                    context.addToClassPath(wsdlPath);
                }
                return WsdlGeneratorUtils.getRelativeNameOrURL((File)moduleBase, (File)wsdlFile);
            }
            throw new DeploymentException("WSDL generation failed");
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to generate the wsdl file using wsgen.", (Throwable)e);
        }
    }

    private boolean invokeWsgen(URL[] jars, String[] arguments) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        boolean rs = this.jaxwsTools.invokeWsgen(jars, os, arguments);
        os.close();
        if (!rs) {
            LOG.error("WSDL generator failed: {}", (Object)WsdlGenerator.getOutput(os));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("WSDL generator output: {}", (Object)WsdlGenerator.getOutput(os));
        }
        return rs;
    }

    private static String getOutput(ByteArrayOutputStream os) {
        byte[] arr = os.toByteArray();
        return new String(arr, 0, arr.length);
    }

    private boolean forkWsgen(String classPath, String endorsedPath, String[] arguments) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>(4 + arguments.length);
        cmd.add("-Djava.endorsed.dirs=\"" + endorsedPath + "\"");
        cmd.add("-classpath");
        cmd.add(classPath);
        cmd.add("com.sun.tools.ws.WsGen");
        cmd.addAll(Arrays.asList(arguments));
        try {
            return WsdlGeneratorUtils.execJava(cmd, (long)this.options.getForkTimeout());
        }
        catch (Exception e) {
            throw new DeploymentException("WSDL generation failed", (Throwable)e);
        }
    }
}

