/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.ejb.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.WebServiceFinder;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EJBWebServiceFinder
implements WebServiceFinder<EjbModule> {
    private static final Logger LOG = LoggerFactory.getLogger(EJBWebServiceFinder.class);

    public Map<String, PortInfo> discoverWebServices(EjbModule module, Map<String, String> correctedPortLocations) throws DeploymentException {
        HashMap<String, PortInfo> map = new HashMap<String, PortInfo>();
        this.discoverEJBWebServices(module, correctedPortLocations, map);
        return map;
    }

    private void discoverEJBWebServices(EjbModule ejbModule, Map<String, String> correctedPortLocations, Map<String, PortInfo> map) throws DeploymentException {
        Bundle bundle = ejbModule.getEarContext().getDeploymentBundle();
        HashSet<String> ejbWebServiceClassNames = new HashSet<String>();
        for (EnterpriseBeanInfo bean : ejbModule.getEjbJarInfo().enterpriseBeans) {
            if (bean.type != 2 && bean.type != 4) continue;
            try {
                Class ejbClass = bundle.loadClass(bean.ejbClass);
                if (!JAXWSUtils.isWebService((Class)ejbClass)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found EJB Web Service: " + bean.ejbName);
                }
                PortInfo portInfo = new PortInfo();
                String location = correctedPortLocations.get(bean.ejbName);
                if (location == null) {
                    location = "/" + JAXWSUtils.getServiceName((Class)ejbClass) + "/" + JAXWSUtils.getName((Class)ejbClass);
                }
                portInfo.setLocation(location);
                portInfo.setWsdlService(JAXWSUtils.getServiceQName((Class)ejbClass));
                portInfo.setWsdlPort(JAXWSUtils.getPortQName((Class)ejbClass));
                map.put(bean.ejbName, portInfo);
                ejbWebServiceClassNames.add(bean.ejbClass);
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to load ejb class " + bean.ejbName, (Throwable)e);
            }
        }
        ejbModule.getSharedContext().put("EJB_WEB_SERVICE_CLASS_NAMES", ejbWebServiceClassNames);
    }
}

