/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.ws.soap.AddressingFeature;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.jaxws.JAXWSEJBApplicationContext;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.JAXWSWebApplicationContext;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.annotations.AnnotationHolder;
import org.apache.geronimo.jaxws.builder.JAXWSBuilderUtils;
import org.apache.geronimo.jaxws.builder.WebServiceContextAnnotationHelper;
import org.apache.geronimo.jaxws.builder.WebServiceFinder;
import org.apache.geronimo.jaxws.feature.AddressingFeatureInfo;
import org.apache.geronimo.jaxws.feature.MTOMFeatureInfo;
import org.apache.geronimo.jaxws.feature.RespectBindingFeatureInfo;
import org.apache.geronimo.jaxws.handler.HandlerChainsInfoBuilder;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.openejb.jee.Addressing;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.PortComponent;
import org.apache.openejb.jee.ServiceImplBean;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.jee.Webservices;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JAXWSServiceBuilder
implements WebServiceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JAXWSServiceBuilder.class);
    private static final boolean JAX_WS_SERVER_SUPPORT;
    private HandlerChainsInfoBuilder handlerChainsInfoBuilder = new HandlerChainsInfoBuilder();
    protected final Environment defaultEnvironment;
    protected WebServiceFinder webServiceFinder;

    public JAXWSServiceBuilder(Environment defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    protected void setWebServiceFinder(WebServiceFinder finder) {
        this.webServiceFinder = finder;
    }

    protected String getKey() {
        return this.getClass().getName();
    }

    /*
     * Loose catch block
     */
    public void findWebServices(Module module, boolean isEJB, Map<String, String> servletLocations, Environment environment, Map sharedContext) throws DeploymentException {
        if (!JAX_WS_SERVER_SUPPORT) {
            return;
        }
        Map<String, PortInfo> serviceLinkPortInfoMap = this.discoverWebServices(module, isEJB, servletLocations);
        String path = isEJB ? "META-INF/webservices.xml" : "WEB-INF/webservices.xml";
        Deployable deployable = module.getDeployable();
        URL wsDDUrl = deployable.getResource(path);
        if (wsDDUrl != null) {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(wsDDUrl.openStream());
                Webservices wst = (Webservices)JaxbJavaee.unmarshalJavaee(Webservices.class, (InputStream)in);
                for (WebserviceDescription desc : wst.getWebserviceDescription()) {
                    String wsdlFile = null;
                    if (desc.getWsdlFile() != null) {
                        wsdlFile = this.getString(desc.getWsdlFile());
                    }
                    String serviceName = desc.getWebserviceDescriptionName();
                    for (PortComponent port : desc.getPortComponent()) {
                        String serviceLink = null;
                        ServiceImplBean beanType = port.getServiceImplBean();
                        if (beanType.getEjbLink() != null) {
                            serviceLink = beanType.getEjbLink();
                        } else if (beanType.getServletLink() != null) {
                            serviceLink = beanType.getServletLink();
                        }
                        PortInfo portInfo = serviceLinkPortInfoMap.get(serviceLink);
                        if (portInfo == null) {
                            portInfo = new PortInfo();
                            portInfo.setServiceLink(serviceLink);
                            serviceLinkPortInfoMap.put(serviceLink, portInfo);
                        }
                        if (port.getServiceEndpointInterface() != null) {
                            String sei = port.getServiceEndpointInterface();
                            portInfo.setServiceEndpointInterfaceName(sei);
                        }
                        if (port.getPortComponentName() != null) {
                            portInfo.setPortName(port.getPortComponentName());
                        }
                        if (port.getProtocolBinding() != null) {
                            portInfo.setProtocolBinding(port.getProtocolBinding());
                        }
                        portInfo.setServiceName(serviceName);
                        if (wsdlFile != null) {
                            portInfo.setWsdlFile(wsdlFile);
                        }
                        if (port.getHandlerChains() != null) {
                            portInfo.setHandlerChainsInfo(this.handlerChainsInfoBuilder.build(port.getHandlerChains()));
                        }
                        if (port.getWsdlPort() != null) {
                            portInfo.setWsdlPort(port.getWsdlPort());
                        }
                        if (port.getWsdlService() != null) {
                            portInfo.setWsdlService(port.getWsdlService());
                        }
                        String location = servletLocations.get(serviceLink);
                        portInfo.setLocation(location);
                        Addressing addressing = port.getAddressing();
                        if (addressing != null) {
                            AddressingFeatureInfo addressingFeatureInfo = portInfo.getAddressingFeatureInfo();
                            if (addressingFeatureInfo == null) {
                                addressingFeatureInfo = new AddressingFeatureInfo();
                                portInfo.setAddressingFeatureInfo(addressingFeatureInfo);
                            }
                            if (addressing.getEnabled() != null) {
                                addressingFeatureInfo.setEnabled(addressing.getEnabled().booleanValue());
                            }
                            if (addressing.getRequired() != null) {
                                addressingFeatureInfo.setRequired(addressing.getRequired().booleanValue());
                            }
                            if (addressing.getResponses() != null) {
                                addressingFeatureInfo.setResponses(AddressingFeature.Responses.valueOf((String)addressing.getResponses().name()));
                            }
                        }
                        if (port.getEnableMtom() != null || port.getMtomThreshold() != null) {
                            MTOMFeatureInfo mtomFeatureInfo = portInfo.getMtomFeatureInfo();
                            if (mtomFeatureInfo == null) {
                                mtomFeatureInfo = new MTOMFeatureInfo();
                                portInfo.setMtomFeatureInfo(mtomFeatureInfo);
                            }
                            if (port.getEnableMtom() != null) {
                                mtomFeatureInfo.setEnabled(port.getEnableMtom().booleanValue());
                            }
                            if (port.getMtomThreshold() != null) {
                                mtomFeatureInfo.setThreshold(port.getMtomThreshold().intValue());
                            }
                        }
                        if (port.getRespectBinding() == null || port.getRespectBinding().getEnabled() == null) continue;
                        RespectBindingFeatureInfo respectBindingFeatureInfo = portInfo.getRespectBindingFeatureInfo();
                        if (respectBindingFeatureInfo == null) {
                            respectBindingFeatureInfo = new RespectBindingFeatureInfo();
                            portInfo.setRespectBindingFeatureInfo(respectBindingFeatureInfo);
                        }
                        respectBindingFeatureInfo.setEnabled(port.getRespectBinding().getEnabled().booleanValue());
                    }
                }
            }
            catch (JAXBException e) {
                LOG.debug("Descriptor ignored (not a Java EE 5 descriptor)");
                IOUtils.close((Closeable)in);
            }
            catch (Exception e2) {
                throw new DeploymentException("Failed to parse " + path, (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        IOUtils.close(in);
                        throw throwable;
                    }
                }
            }
            IOUtils.close((Closeable)in);
        }
        if (serviceLinkPortInfoMap != null && !serviceLinkPortInfoMap.isEmpty()) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
            sharedContext.put(this.getKey(), serviceLinkPortInfoMap);
        }
    }

    private String getString(String in) {
        if (in != null && (in = in.trim()).length() == 0) {
            return null;
        }
        return in;
    }

    private Map<String, PortInfo> discoverWebServices(Module module, boolean isEJB, Map<String, String> correctedPortLocations) throws DeploymentException {
        if (this.webServiceFinder == null) {
            throw new DeploymentException("WebServiceFinder not configured");
        }
        return this.webServiceFinder.discoverWebServices(module, correctedPortLocations);
    }

    public boolean configurePOJO(GBeanData targetGBean, String servletName, Module module, String servletClassName, DeploymentContext context) throws DeploymentException {
        if (!JAX_WS_SERVER_SUPPORT) {
            return false;
        }
        Map sharedContext = ((WebModule)module).getSharedContext();
        Map portInfoMap = (Map)sharedContext.get(this.getKey());
        if (portInfoMap == null) {
            return false;
        }
        PortInfo portInfo = (PortInfo)portInfoMap.get(servletName);
        if (portInfo == null) {
            return false;
        }
        Bundle bundle = context.getDeploymentBundle();
        Class<?> servletClass = this.loadClass(servletClassName, bundle);
        if (!JAXWSUtils.isWebService(servletClass)) {
            return false;
        }
        HashMap<String, PortInfo> servletNamePortInfoMap = null;
        AbstractName jaxwsWebApplicationContextName = context.getNaming().createChildName(module.getModuleName(), "JAXWSWebApplicationContext", "JAXWSWebApplicationContext");
        try {
            servletNamePortInfoMap = (HashMap<String, PortInfo>)context.getGBeanInstance(jaxwsWebApplicationContextName).getAttribute("servletNamePortInfoMap");
        }
        catch (GBeanNotFoundException e) {
            GBeanData jaxwsWebApplicationContextGBeanData = new GBeanData(jaxwsWebApplicationContextName, JAXWSWebApplicationContext.class);
            try {
                context.addGBean(jaxwsWebApplicationContextGBeanData);
            }
            catch (GBeanAlreadyExistsException e1) {
                // empty catch block
            }
            servletNamePortInfoMap = new HashMap<String, PortInfo>();
            jaxwsWebApplicationContextGBeanData.setAttribute("servletNamePortInfoMap", servletNamePortInfoMap);
        }
        targetGBean.addDependency(jaxwsWebApplicationContextName);
        servletNamePortInfoMap.put(servletName, portInfo);
        Map componentContext = null;
        Holder moduleHolder = null;
        try {
            moduleHolder = (Holder)module.getSharedContext().get(NamingBuilder.INJECTION_KEY);
            GBeanData contextSourceGBean = context.getGBeanInstance(context.getNaming().createChildName(module.getModuleName(), "ContextSource", "ContextSource"));
            componentContext = (Map)contextSourceGBean.getAttribute("componentContext");
        }
        catch (GBeanNotFoundException e) {
            LOG.warn("ModuleGBean not found. JNDI resource injection will not work.");
        }
        AnnotationHolder serviceHolder = (AnnotationHolder)sharedContext.get(WebServiceContextAnnotationHelper.class.getName());
        if (serviceHolder == null) {
            serviceHolder = new AnnotationHolder(moduleHolder);
            sharedContext.put(WebServiceContextAnnotationHelper.class.getName(), serviceHolder);
        }
        WebServiceContextAnnotationHelper.addWebServiceContextInjections((Holder)serviceHolder, servletClass);
        String location = portInfo.getLocation();
        LOG.info("Configuring JAX-WS Web Service: " + servletName + " at " + location);
        AbstractName containerFactoryName = context.getNaming().createChildName(targetGBean.getAbstractName(), this.getContainerFactoryGBeanInfo().getName(), "GBean");
        GBeanData containerFactoryData = new GBeanData(containerFactoryName, this.getContainerFactoryGBeanInfo());
        containerFactoryData.setAttribute("portInfo", (Object)portInfo);
        containerFactoryData.setAttribute("endpointClassName", (Object)servletClassName);
        containerFactoryData.setAttribute("componentContext", (Object)componentContext);
        containerFactoryData.setAttribute("holder", (Object)serviceHolder);
        containerFactoryData.setAttribute("contextRoot", (Object)((WebModule)module).getContextRoot());
        containerFactoryData.setAttribute("catalogName", (Object)JAXWSBuilderUtils.normalizeCatalogPath(module, "WEB-INF/jax-ws-catalog.xml"));
        try {
            context.addGBean(containerFactoryData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add web service container factory gbean", (Throwable)e);
        }
        targetGBean.setReferencePattern("WebServiceContainerFactory", containerFactoryName);
        targetGBean.setAttribute("pojoClassName", (Object)"java.lang.Object");
        if (context instanceof EARContext) {
            containerFactoryData.setReferencePattern("TransactionManager", ((EARContext)context).getTransactionManagerName());
        }
        this.initialize(containerFactoryData, servletClass, portInfo, module, bundle);
        return true;
    }

    protected abstract GBeanInfo getContainerFactoryGBeanInfo();

    public boolean configureEJB(GBeanData targetGBean, String ejbName, Module module, Map sharedContext, Bundle bundle) throws DeploymentException {
        if (!JAX_WS_SERVER_SUPPORT) {
            return false;
        }
        Map portInfoMap = (Map)sharedContext.get(this.getKey());
        if (portInfoMap == null) {
            return false;
        }
        PortInfo portInfo = (PortInfo)portInfoMap.get(ejbName);
        if (portInfo == null) {
            return false;
        }
        String beanClassName = (String)targetGBean.getAttribute("ejbClass");
        Class<?> beanClass = this.loadClass(beanClassName, bundle);
        if (!JAXWSUtils.isWebService(beanClass)) {
            return false;
        }
        String location = portInfo.getLocation();
        if (location == null) {
            throw new DeploymentException("Endpoint URI for EJB WebService is missing");
        }
        HashMap<String, PortInfo> ejbNamePortInfoMap = null;
        EARContext context = module.getEarContext();
        AbstractName jaxwsEJBApplicationContextName = context.getNaming().createChildName(module.getModuleName(), "JAXWSEJBApplicationContext", "JAXWSEJBApplicationContext");
        try {
            ejbNamePortInfoMap = (HashMap<String, PortInfo>)context.getGBeanInstance(jaxwsEJBApplicationContextName).getAttribute("ejbNamePortInfoMap");
        }
        catch (GBeanNotFoundException e) {
            GBeanData jaxwsEJBApplicationContextGBeanData = new GBeanData(jaxwsEJBApplicationContextName, JAXWSEJBApplicationContext.class);
            try {
                context.addGBean(jaxwsEJBApplicationContextGBeanData);
            }
            catch (GBeanAlreadyExistsException e1) {
                // empty catch block
            }
            ejbNamePortInfoMap = new HashMap<String, PortInfo>();
            jaxwsEJBApplicationContextGBeanData.setAttribute("ejbNamePortInfoMap", ejbNamePortInfoMap);
        }
        targetGBean.addDependency(jaxwsEJBApplicationContextName);
        ejbNamePortInfoMap.put(ejbName, portInfo);
        LOG.info("Configuring EJB JAX-WS Web Service: " + ejbName + " at " + location);
        targetGBean.setAttribute("portInfo", (Object)portInfo);
        targetGBean.setAttribute("catalogName", (Object)JAXWSBuilderUtils.normalizeCatalogPath(module, "META-INF/jax-ws-catalog.xml"));
        this.initialize(targetGBean, beanClass, portInfo, module, bundle);
        return true;
    }

    protected void initialize(GBeanData targetGBean, Class wsClass, PortInfo info, Module module, Bundle bundle) throws DeploymentException {
    }

    Class<?> loadClass(String className, Bundle bundle) throws DeploymentException {
        try {
            return bundle.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new DeploymentException("Unable to load Web Service class: " + className, (Throwable)ex);
        }
    }

    protected boolean isWsdlSet(PortInfo portInfo, Class serviceClass, Bundle bundle) {
        return portInfo.getWsdlFile() != null && !portInfo.getWsdlFile().trim().equals("") || JAXWSUtils.containsWsdlLocation((Class)serviceClass, (Bundle)bundle);
    }

    protected boolean isHTTPBinding(PortInfo portInfo, Class serviceClass) {
        String bindingURI = "";
        if (portInfo.getProtocolBinding() != null) {
            bindingURI = JAXWSUtils.getBindingURI((String)portInfo.getProtocolBinding());
        }
        String bindingURIFromAnnot = JAXWSUtils.getBindingURIFromAnnot((Class)serviceClass);
        if (bindingURI != null && !bindingURI.trim().equals("")) {
            return bindingURI.equals("http://www.w3.org/2004/08/wsdl/http");
        }
        if (bindingURIFromAnnot != null && !bindingURIFromAnnot.trim().equals("")) {
            return bindingURIFromAnnot.equals("http://www.w3.org/2004/08/wsdl/http");
        }
        return false;
    }

    static {
        String webServiceServerSupported = System.getProperty("org.apache.geronimo.jaxws.server.support");
        if (webServiceServerSupported == null) {
            webServiceServerSupported = System.getProperty("org.apache.geronimo.jaxws.support");
        }
        JAX_WS_SERVER_SUPPORT = webServiceServerSupported == null ? true : Boolean.valueOf(webServiceServerSupported);
    }
}

