/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.WARWebServiceFinder;
import org.apache.geronimo.jaxws.builder.WebServiceFinder;
import org.apache.geronimo.xbeans.javaee.ServletMappingType;
import org.apache.geronimo.xbeans.javaee.ServletType;
import org.apache.geronimo.xbeans.javaee.WebAppType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedWARWebServiceFinder
implements WebServiceFinder {
    private static final Logger LOG = LoggerFactory.getLogger(AdvancedWARWebServiceFinder.class);

    @Override
    public Map<String, PortInfo> discoverWebServices(Module module, boolean isEJB, Map correctedPortLocations) throws DeploymentException {
        HashMap<String, PortInfo> map = new HashMap<String, PortInfo>();
        this.discoverPOJOWebServices(module, correctedPortLocations, map);
        return map;
    }

    private void discoverPOJOWebServices(Module module, Map portLocations, Map<String, PortInfo> map) throws DeploymentException {
        ClassLoader classLoader = module.getEarContext().getClassLoader();
        WebAppType webApp = (WebAppType)module.getSpecDD();
        if (webApp.isSetMetadataComplete()) {
            ServletType[] servletTypes;
            for (ServletType servletType : servletTypes = webApp.getServletArray()) {
                String servletName = servletType.getServletName().getStringValue().trim();
                PortInfo portInfo = this.getPortInfo(servletType, classLoader, portLocations);
                if (portInfo == null) continue;
                LOG.debug("Found POJO Web Service: {}", (Object)servletName);
                map.put(servletName, portInfo);
            }
        } else {
            ServletType[] servletTypes;
            Map<String, List<String>> classServletMap = this.createClassServetMap(webApp);
            List<Class> services = WARWebServiceFinder.discoverWebServices(module.getModuleFile(), false, classLoader);
            String contextRoot = ((WebModule)module).getContextRoot();
            for (Class service : services) {
                PortInfo portInfo;
                if (!JAXWSUtils.isWebService((Class)service)) continue;
                LOG.debug("Discovered POJO Web Service class: {}", (Object)service.getName());
                List<String> mappedServlets = classServletMap.get(service.getName());
                if (mappedServlets == null) {
                    LOG.debug("POJO Web Service class {} is not mapped to any servlet", (Object)service.getName());
                    ServletType servlet = webApp.addNewServlet();
                    servlet.addNewServletName().setStringValue(service.getName());
                    servlet.addNewServletClass().setStringValue(service.getName());
                    String location = (String)portLocations.get(service.getName());
                    if (location == null) {
                        location = "/" + JAXWSUtils.getServiceName((Class)service);
                        ServletMappingType servletMapping = webApp.addNewServletMapping();
                        servletMapping.addNewServletName().setStringValue(service.getName());
                        servletMapping.addNewUrlPattern().setStringValue(location);
                    } else {
                        LOG.warn("Found <servlet-mapping> but corresponding <servlet> was not defined");
                    }
                    portInfo = new PortInfo();
                    portInfo.setLocation(contextRoot + location);
                    map.put(service.getName(), portInfo);
                    continue;
                }
                for (String servlet : mappedServlets) {
                    LOG.debug("POJO Web Service class {} is mapped to {} servlet", (Object)service.getName(), (Object)servlet);
                    portInfo = this.createPortInfo(servlet, portLocations);
                    map.put(servlet, portInfo);
                }
            }
            for (ServletType servletType : servletTypes = webApp.getServletArray()) {
                PortInfo portInfo;
                String servletName = servletType.getServletName().getStringValue().trim();
                if (map.get(servletName) != null || (portInfo = this.getPortInfo(servletType, classLoader, portLocations)) == null) continue;
                LOG.debug("Found POJO Web Service: {}", (Object)servletName);
                map.put(servletName, portInfo);
            }
        }
    }

    private PortInfo getPortInfo(ServletType servletType, ClassLoader classLoader, Map portLocations) throws DeploymentException {
        PortInfo portInfo = null;
        if (servletType.isSetServletClass()) {
            String servletClassName = servletType.getServletClass().getStringValue().trim();
            try {
                Class<?> servletClass = classLoader.loadClass(servletClassName);
                if (JAXWSUtils.isWebService(servletClass)) {
                    String servletName = servletType.getServletName().getStringValue().trim();
                    portInfo = this.createPortInfo(servletName, portLocations);
                }
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Failed to load servlet class " + servletClassName, (Throwable)e);
            }
        }
        return portInfo;
    }

    private PortInfo createPortInfo(String servlet, Map portLocations) {
        PortInfo portInfo = new PortInfo();
        String location = (String)portLocations.get(servlet);
        if (location != null) {
            portInfo.setLocation(location);
        }
        return portInfo;
    }

    private Map<String, List<String>> createClassServetMap(WebAppType webApp) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ServletType[] servletTypes = webApp.getServletArray();
        if (servletTypes != null) {
            for (ServletType servletType : servletTypes) {
                String servletName = servletType.getServletName().getStringValue().trim();
                if (!servletType.isSetServletClass()) continue;
                String servletClassName = servletType.getServletClass().getStringValue().trim();
                ArrayList<String> servlets = (ArrayList<String>)map.get(servletClassName);
                if (servlets == null) {
                    servlets = new ArrayList<String>();
                    map.put(servletClassName, servlets);
                }
                servlets.add(servletName);
            }
        }
        return map;
    }
}

