/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.apache.geronimo.jaxws.builder.JAXWSTools;
import org.apache.geronimo.kernel.repository.Maven2Repository;

public class JAXWSToolsCLI {
    private static final String USAGE_MSG = "Usage: jaxws-tools <toolName> <tool options>\n\nwhere <toolName> is:\n  wsgen       - generate portable artifacts from class\n  wsimport    - generate portable artifacts from WSDL\n";

    public static void main(String[] args) throws Throwable {
        if (args.length == 0) {
            System.err.println(USAGE_MSG);
            System.exit(1);
        }
        Command cmd = null;
        if (args[0].equalsIgnoreCase("wsgen")) {
            cmd = Command.WSGEN;
        } else if (args[0].equalsIgnoreCase("wsimport")) {
            cmd = Command.WSIMPORT;
        } else {
            System.err.println("Error: Unsupported toolName [" + args[0] + "].");
            System.err.println();
            System.err.println(USAGE_MSG);
            System.exit(1);
        }
        String geroninoHome = JAXWSToolsCLI.getGeronimoHome();
        String[] arguments = JAXWSToolsCLI.getCmdArguments(args);
        boolean rs = JAXWSToolsCLI.run(cmd, geroninoHome, arguments, System.out);
        System.exit(rs ? 0 : 1);
    }

    static boolean run(Command cmd, String geronimoHome, String[] args, OutputStream out) throws Exception {
        String repository = System.getProperty("Xorg.apache.geronimo.repository.boot.path", "repository");
        Maven2Repository mavenRepository = new Maven2Repository(new File(geronimoHome, repository).getCanonicalFile());
        ArrayList<Maven2Repository> repositories = new ArrayList<Maven2Repository>(1);
        repositories.add(mavenRepository);
        JAXWSTools tools = new JAXWSTools();
        tools.setUseSunSAAJ();
        tools.setOverrideContextClassLoader(true);
        File[] jars = tools.getClasspath(repositories);
        URL[] jarUrls = JAXWSTools.toURL(jars);
        String javaClassPath = System.getProperty("java.class.path");
        System.setProperty("java.class.path", JAXWSTools.toString(jars));
        try {
            if (cmd.equals((Object)Command.WSGEN)) {
                boolean bl = tools.invokeWsgen(jarUrls, out, args);
                return bl;
            }
            if (cmd.equals((Object)Command.WSIMPORT)) {
                boolean bl = tools.invokeWsimport(jarUrls, out, args);
                return bl;
            }
            try {
                throw new IllegalArgumentException("Invalid command: " + (Object)((Object)cmd));
            }
            catch (InvocationTargetException e) {
                Throwable exception = e.getTargetException();
                if (exception instanceof Exception) {
                    throw (Exception)exception;
                }
                throw e;
            }
        }
        finally {
            System.setProperty("java.class.path", javaClassPath);
        }
    }

    private static String[] getCmdArguments(String[] args) {
        String[] cmdArgs = new String[args.length - 1];
        System.arraycopy(args, 1, cmdArgs, 0, args.length - 1);
        return cmdArgs;
    }

    private static String getGeronimoHome() {
        String geronimoHome = System.getProperty("org.apache.geronimo.home.dir");
        if (geronimoHome != null) {
            return geronimoHome;
        }
        URL url = JAXWSToolsCLI.class.getClassLoader().getResource("META-INF/startup-jar");
        if (url != null) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                url = jarConnection.getJarFileURL();
                URI baseURI = new URI(url.toString()).resolve("..");
                File dir = new File(baseURI);
                return dir.getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "..";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Command {
        WSGEN,
        WSIMPORT;

    }
}

