/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jasper;

import java.net.URL;
import java.util.Collection;
import org.osgi.framework.Bundle;

public interface TldProvider {
    public Collection<TldEntry> getTlds();

    public static class TldEntry {
        private URL url;
        private Bundle bundle;
        private URL jarUrl;
        private URL fileUrl;
        private String name;

        public TldEntry(Bundle bundle, URL url) {
            this(bundle, url, null, null);
        }

        public TldEntry(Bundle bundle, URL url, URL jarUrl) {
            this.bundle = bundle;
            this.url = url;
            this.jarUrl = jarUrl;
            this.fileUrl = null;
            String path = url.getPath();
            this.name = path.startsWith("/") ? path.substring(1) : path;
        }

        public TldEntry(Bundle bundle, URL url, URL jarUrl, URL fileUrl) {
            this.bundle = bundle;
            this.url = url;
            this.jarUrl = jarUrl;
            this.fileUrl = fileUrl;
            String path = url.getPath();
            this.name = path.startsWith("/") ? path.substring(1) : path;
        }

        public URL getURL() {
            return this.url;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public URL getJarUrl() {
            return this.jarUrl;
        }

        public String getName() {
            return this.name;
        }

        public URL getFileUrl() {
            return this.fileUrl;
        }
    }
}

