/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jasper.deployment;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeployableBundle;
import org.apache.geronimo.deployment.DeployableJarFile;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.jasper.JasperServletContextCustomizer;
import org.apache.geronimo.jasper.TldProvider;
import org.apache.geronimo.jasper.deployment.BundleTldScanner;
import org.apache.geronimo.jasper.deployment.JarFileTldScanner;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.web25.deployment.AbstractWebModuleBuilder;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.ListenerType;
import org.apache.geronimo.xbeans.javaee.TagType;
import org.apache.geronimo.xbeans.javaee.TaglibDocument;
import org.apache.geronimo.xbeans.javaee.TldTaglibType;
import org.apache.geronimo.xbeans.javaee6.JspConfigType;
import org.apache.geronimo.xbeans.javaee6.TaglibType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ModuleBuilder")
public class JspModuleBuilderExtension
implements ModuleBuilderExtension {
    private static final Logger log = LoggerFactory.getLogger(JspModuleBuilderExtension.class);
    private static final QName TLIB_VERSION = new QName("http://java.sun.com/xml/ns/javaee", "tlib-version");
    private static final QName SHORT_NAME = new QName("http://java.sun.com/xml/ns/javaee", "short-name");
    private static final QName TAG_CLASS = new QName("http://java.sun.com/xml/ns/javaee", "tag-class");
    private static final QName TEI_CLASS = new QName("http://java.sun.com/xml/ns/javaee", "tei-class");
    private static final QName BODY_CONTENT = new QName("http://java.sun.com/xml/ns/javaee", "body-content");
    private static final String SCHEMA_LOCATION_URL = "http://java.sun.com/xml/ns/javaee/web-jsptaglibrary_2_1.xsd";
    private static final String VERSION = "2.1";
    private final Environment defaultEnvironment;
    private final NamingBuilder namingBuilders;

    public JspModuleBuilderExtension(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamReference(name="NamingBuilders", namingType="ModuleBuilder") NamingBuilder namingBuilders) {
        this.defaultEnvironment = defaultEnvironment;
        this.namingBuilders = namingBuilders;
    }

    public void createModule(Module module, Bundle bundle, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
    }

    public void createModule(Module module, Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
    }

    public void initContext(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
    }

    public void addGBeans(EARContext earContext, Module module, Bundle bundle, Collection repository) throws DeploymentException {
        Object value;
        if (!(module instanceof WebModule)) {
            return;
        }
        EnvironmentBuilder.mergeEnvironments((Environment)module.getEnvironment(), (Environment)this.defaultEnvironment);
        WebModule webModule = (WebModule)module;
        WebAppType webApp = (WebAppType)webModule.getSpecDD();
        EARContext moduleContext = module.getEarContext();
        Map sharedContext = module.getSharedContext();
        GBeanData jspServletData = (GBeanData)AbstractWebModuleBuilder.DEFAULT_JSP_SERVLET_KEY.get(sharedContext);
        if (jspServletData != null) {
            try {
                moduleContext.addGBean(jspServletData);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("jsp servlet already present", (Throwable)e);
            }
        }
        GBeanData webAppData = (GBeanData)sharedContext.get("WEB_APP_DATA");
        AbstractName moduleName = module.getModuleName();
        HashMap<EARContext.Key, Object> buildingContext = new HashMap<EARContext.Key, Object>();
        buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, moduleName);
        Map compContext = (Map)NamingBuilder.JNDI_KEY.get(sharedContext);
        buildingContext.put(NamingBuilder.JNDI_KEY, compContext);
        Holder holder = (Holder)NamingBuilder.INJECTION_KEY.get(sharedContext);
        buildingContext.put(NamingBuilder.INJECTION_KEY, holder);
        XmlObject jettyWebApp = (XmlObject)webModule.getVendorDD();
        HashSet<String> listenerNames = new HashSet<String>();
        ClassFinder classFinder = this.createJspClassFinder(webApp, webModule, listenerNames);
        webModule.setClassFinder(classFinder);
        this.namingBuilders.buildNaming((XmlObject)webApp, jettyWebApp, (Module)webModule, buildingContext);
        GBeanInfo webAppGBeanInfo = webAppData.getGBeanInfo();
        if (webAppGBeanInfo.getReference("ContextCustomizer") != null) {
            AbstractName jspLifecycleName = moduleContext.getNaming().createChildName(moduleName, "jspLifecycleProvider", "GBean");
            GBeanData gbeanData = new GBeanData(jspLifecycleName, JasperServletContextCustomizer.class);
            gbeanData.setAttribute("holder", (Object)holder);
            try {
                moduleContext.addGBean(gbeanData);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Duplicate jspLifecycleProvider", (Throwable)e);
            }
            webAppData.setReferencePattern("ContextCustomizer", jspLifecycleName);
        }
        if ((value = webAppData.getAttribute("listenerClassNames")) instanceof Collection) {
            ((Collection)value).addAll(listenerNames);
        }
    }

    protected ClassFinder createJspClassFinder(WebAppType webApp, WebModule webModule, Set<String> listenerNames) throws DeploymentException {
        LinkedHashSet<URL> urls = this.getTldFiles(webApp, webModule);
        List<Class> classes = this.getListenerClasses(webApp, webModule, urls, listenerNames);
        return new ClassFinder(classes);
    }

    private LinkedHashSet<URL> getTldFiles(WebAppType webApp, WebModule webModule) throws DeploymentException {
        JspConfigType[] jspConfigs;
        if (log.isDebugEnabled()) {
            log.debug("getTldFiles( " + webApp.toString() + "," + webModule.getName() + " ): Entry");
        }
        LinkedHashSet<URL> tldURLs = new LinkedHashSet<URL>();
        for (JspConfigType jspConfig : jspConfigs = webApp.getJspConfigArray()) {
            TaglibType[] taglibs;
            for (TaglibType taglib : taglibs = jspConfig.getTaglibArray()) {
                String uri = taglib.getTaglibUri().getStringValue().trim();
                String location = taglib.getTaglibLocation().getStringValue().trim();
                if (location.equals("")) continue;
                if (location.startsWith("/")) {
                    location = location.substring(1);
                }
                try {
                    URL targetUrl = webModule.getEarContext().getTargetURL(webModule.resolve(this.createURI(location)));
                    if (targetUrl == null) continue;
                    tldURLs.add(targetUrl);
                }
                catch (URISyntaxException use) {
                    throw new DeploymentException("Could not locate TLD file specified in <taglib>: URI: " + uri + " Location: " + location + " " + use.getMessage(), (Throwable)use);
                }
            }
        }
        tldURLs.addAll(this.scanModule(webModule));
        log.debug("getTldFiles() Exit: URL[" + tldURLs.size() + "]: " + tldURLs.toString());
        return tldURLs;
    }

    private List<URL> scanModule(WebModule webModule) throws DeploymentException {
        Deployable deployable = webModule.getDeployable();
        if (deployable instanceof DeployableJarFile) {
            JarFileTldScanner scanner = new JarFileTldScanner();
            return scanner.scanModule(webModule);
        }
        if (deployable instanceof DeployableBundle) {
            BundleTldScanner scanner = new BundleTldScanner();
            return scanner.scanModule(webModule);
        }
        return Collections.emptyList();
    }

    private List<URL> scanGlobalTlds(Bundle bundle) throws DeploymentException {
        ServiceReference[] references;
        BundleContext bundleContext = bundle.getBundleContext();
        try {
            references = bundleContext.getServiceReferences(TldProvider.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            throw new DeploymentException("Invalid filter expression", (Throwable)e);
        }
        ArrayList<URL> tldURLs = new ArrayList<URL>();
        if (references != null) {
            for (ServiceReference reference : references) {
                TldProvider provider = (TldProvider)bundleContext.getService(reference);
                for (TldProvider.TldEntry entry : provider.getTlds()) {
                    URL url = entry.getURL();
                    tldURLs.add(url);
                }
                bundleContext.ungetService(reference);
            }
        }
        return tldURLs;
    }

    private List<Class> getListenerClasses(WebAppType webApp, WebModule webModule, Collection<URL> urls, Set<String> listenerNames) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug("getListenerClasses( " + webApp.toString() + "," + '\n' + webModule.getName() + " ): Entry");
        }
        Bundle bundle = webModule.getEarContext().getDeploymentBundle();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (URL url : urls) {
            this.parseTldFile(url, bundle, classes, listenerNames);
        }
        if (log.isDebugEnabled()) {
            log.debug("getListenerClasses() Exit: Classes[" + classes.size() + "]: " + ((Object)classes).toString());
        }
        return classes;
    }

    private void parseTldFile(URL url, Bundle bundle, List<Class> classes, Set<String> listenerNames) throws DeploymentException {
        log.debug("parseTLDFile( " + url.toString() + " ): Entry");
        try {
            TagType[] tags;
            ListenerType[] listeners;
            XmlObject xml = XmlBeansUtil.parse((URL)url, null);
            TaglibDocument tld = JspModuleBuilderExtension.convertToTaglibSchema(xml);
            TldTaglibType tl = tld.getTaglib();
            for (ListenerType listener : listeners = tl.getListenerArray()) {
                FullyQualifiedClassType cls = listener.getListenerClass();
                String className = cls.getStringValue().trim();
                try {
                    Class clas = bundle.loadClass(className);
                    classes.add(clas);
                    listenerNames.add(className);
                }
                catch (ClassNotFoundException e) {
                    log.warn("JspModuleBuilderExtension: Could not load listener class: " + className + " mentioned in TLD file at " + url.toString());
                }
            }
            for (TagType tag : tags = tl.getTagArray()) {
                FullyQualifiedClassType cls = tag.getTagClass();
                String className = cls.getStringValue().trim();
                try {
                    Class clas = bundle.loadClass(className);
                    classes.add(clas);
                }
                catch (ClassNotFoundException e) {
                    log.warn("JspModuleBuilderExtension: Could not load tag class: " + className + " mentioned in TLD file at " + url.toString());
                }
            }
        }
        catch (XmlException xmle) {
            throw new DeploymentException("Could not parse TLD file at " + url.toString(), (Throwable)xmle);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Could not find TLD file at " + url.toString(), (Throwable)ioe);
        }
        log.debug("parseTLDFile(): Exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TaglibDocument convertToTaglibSchema(XmlObject xmlObject) throws XmlException {
        if (log.isDebugEnabled()) {
            log.debug("convertToTaglibSchema( " + xmlObject.toString() + " ): Entry");
        }
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        try {
            String name;
            cursor.toStartDoc();
            cursor.toFirstChild();
            if ("http://java.sun.com/xml/ns/javaee".equals(cursor.getName().getNamespaceURI())) {
                log.debug("Nothing to do");
            } else if ("http://java.sun.com/xml/ns/j2ee".equals(cursor.getName().getNamespaceURI())) {
                log.debug("Converting XSD 2.0 to 2.1 schema");
                SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)SCHEMA_LOCATION_URL, (String)VERSION);
                cursor.toStartDoc();
                cursor.toChild("http://java.sun.com/xml/ns/javaee", "taglib");
                cursor.toFirstChild();
                do {
                    if (!"tag".equals(name = cursor.getName().getLocalPart())) continue;
                    cursor.push();
                    cursor.toFirstChild();
                    SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                    do {
                        name = cursor.getName().getLocalPart();
                        boolean rtexprvalueFound = false;
                        boolean typeFound = false;
                        if (!"attribute".equals(name)) continue;
                        cursor.push();
                        cursor.toFirstChild();
                        do {
                            if ("rtexprvalue".equals(name = cursor.getName().getLocalPart())) {
                                rtexprvalueFound = true;
                            }
                            if (!"type".equals(name)) continue;
                            typeFound = true;
                        } while (cursor.toNextSibling());
                        cursor.pop();
                        if (typeFound && !rtexprvalueFound) {
                            cursor.push();
                            cursor.toFirstChild();
                            cursor.insertElementWithText("rtexprvalue", "http://java.sun.com/xml/ns/javaee", "false");
                            cursor.pop();
                        }
                        cursor.push();
                        cursor.toFirstChild();
                        SchemaConversionUtils.convertToTldAttribute((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                        cursor.pop();
                    } while (cursor.toNextSibling());
                    cursor.pop();
                    SchemaConversionUtils.convertToTldTag((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                } while (cursor.toNextSibling());
            } else {
                log.debug("Converting DTD to 2.1 schema");
                SchemaConversionUtils.convertToSchema((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)SCHEMA_LOCATION_URL, (String)VERSION);
                cursor.toStartDoc();
                cursor.toChild("http://java.sun.com/xml/ns/javaee", "taglib");
                cursor.toFirstChild();
                SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                do {
                    if ("jsp-version".equals(name = cursor.getName().getLocalPart()) || "jspversion".equals(name) || "info".equals(name)) {
                        cursor.removeXmlContents();
                        cursor.removeXml();
                    }
                    if ("tlibversion".equals(name)) {
                        cursor.setName(TLIB_VERSION);
                    }
                    if ("tlibversion".equals(name)) {
                        cursor.setName(TLIB_VERSION);
                    }
                    if ("shortname".equals(name)) {
                        cursor.setName(SHORT_NAME);
                    }
                    if ("tag".equals(name)) {
                        cursor.push();
                        cursor.toFirstChild();
                        SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                        boolean bodyContentFound = false;
                        do {
                            if ("tagclass".equals(name = cursor.getName().getLocalPart())) {
                                cursor.setName(TAG_CLASS);
                            }
                            if ("teiclass".equals(name)) {
                                cursor.setName(TEI_CLASS);
                            }
                            if ("bodycontent".equals(name)) {
                                cursor.setName(BODY_CONTENT);
                                bodyContentFound = true;
                            }
                            if ("body-content".equals(name)) {
                                bodyContentFound = true;
                            }
                            if ("attribute".equals(name)) {
                                cursor.push();
                                cursor.toFirstChild();
                                SchemaConversionUtils.convertToTldAttribute((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                                cursor.pop();
                            }
                            if ("variable".equals(name)) {
                                cursor.push();
                                cursor.toFirstChild();
                                SchemaConversionUtils.convertToTldVariable((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                                cursor.pop();
                            }
                            if (!"info".equals(name)) continue;
                            cursor.removeXmlContents();
                            cursor.removeXml();
                        } while (cursor.toNextSibling());
                        cursor.pop();
                        if (!bodyContentFound) {
                            cursor.push();
                            cursor.toFirstChild();
                            cursor.insertElementWithText("body-content", "http://java.sun.com/xml/ns/javaee", "scriptless");
                            cursor.pop();
                        }
                        cursor.push();
                        cursor.toFirstChild();
                        SchemaConversionUtils.convertToTldTag((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                        cursor.pop();
                    }
                    if (!"validator".equals(name)) continue;
                    cursor.push();
                    cursor.toFirstChild();
                    SchemaConversionUtils.convertToTldValidator((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                    cursor.pop();
                } while (cursor.toNextSibling());
            }
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
        XmlObject result = xmlObject.changeType(TaglibDocument.type);
        if (result != null) {
            try {
                XmlBeansUtil.validateDD((XmlObject)result);
            }
            catch (XmlException e) {
                log.warn("Invalid transformed taglib", (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug("convertToTaglibSchema( " + result.toString() + " ): Exit 1");
            }
            return (TaglibDocument)result;
        }
        try {
            XmlBeansUtil.validateDD((XmlObject)xmlObject);
        }
        catch (XmlException e) {
            log.warn("Invalid transformed taglib", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("convertToTaglibSchema( " + xmlObject.toString() + " ): Exit 2");
        }
        return (TaglibDocument)xmlObject;
    }

    private URI createURI(String path) throws URISyntaxException {
        path = path.replaceAll(" ", "%20");
        return new URI(path);
    }
}

