/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.annotation.Resources;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.xbean.finder.AbstractFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceAnnotationHelper
extends AnnotationHelper {
    private static final Logger log = LoggerFactory.getLogger(ResourceAnnotationHelper.class);

    private ResourceAnnotationHelper() {
    }

    public static void processAnnotations(JndiConsumer annotatedApp, AbstractFinder classFinder, ResourceProcessor resourceProcessor) throws Exception {
        if (annotatedApp != null) {
            if (classFinder.isAnnotationPresent(Resources.class)) {
                ResourceAnnotationHelper.processResources(annotatedApp, classFinder, resourceProcessor);
            }
            if (classFinder.isAnnotationPresent(Resource.class)) {
                ResourceAnnotationHelper.processResource(annotatedApp, classFinder, resourceProcessor);
            }
        }
    }

    private static void processResource(JndiConsumer annotatedApp, AbstractFinder classFinder, ResourceProcessor resourceProcessor) throws Exception {
        Resource resource;
        log.debug("processResource(): Entry: AnnotatedApp: " + annotatedApp.toString());
        List classeswithResource = classFinder.findAnnotatedClasses(Resource.class);
        List methodswithResource = classFinder.findAnnotatedMethods(Resource.class);
        List fieldswithResource = classFinder.findAnnotatedFields(Resource.class);
        for (Class cls : classeswithResource) {
            resource = cls.getAnnotation(Resource.class);
            if (resource == null) continue;
            resourceProcessor.processResource(annotatedApp, resource, cls, null, null);
        }
        for (Method method : methodswithResource) {
            resource = method.getAnnotation(Resource.class);
            if (resource == null) continue;
            resourceProcessor.processResource(annotatedApp, resource, null, method, null);
        }
        for (Field field : fieldswithResource) {
            resource = field.getAnnotation(Resource.class);
            if (resource == null) continue;
            resourceProcessor.processResource(annotatedApp, resource, null, null, field);
        }
        log.debug("processResource(): Exit: AnnotatedApp: " + annotatedApp.toString());
    }

    private static void processResources(JndiConsumer annotatedApp, AbstractFinder classFinder, ResourceProcessor resourceProcessor) throws Exception {
        log.debug("processResources(): Entry");
        List classeswithResources = classFinder.findAnnotatedClasses(Resources.class);
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (Class cls : classeswithResources) {
            Resources resources = cls.getAnnotation(Resources.class);
            if (resources != null) {
                resourceList.addAll(Arrays.asList(resources.value()));
            }
            for (Resource resource : resourceList) {
                resourceProcessor.processResource(annotatedApp, resource, cls, null, null);
            }
            resourceList.clear();
        }
        log.debug("processResources(): Exit");
    }

    public static abstract class ResourceProcessor
    extends AnnotationHelper {
        public abstract boolean processResource(JndiConsumer var1, Resource var2, Class var3, Method var4, Field var5) throws DeploymentException;

        protected static String getResourceName(Resource annotation, Method method, Field field) {
            return ResourceProcessor.getName(annotation.name(), method, field);
        }

        protected static Class getResourceTypeClass(Resource annotation, Method method, Field field) {
            Class<?> resourceType = annotation.type();
            if (resourceType.equals(Object.class)) {
                if (method != null) {
                    resourceType = method.getParameterTypes()[0];
                } else if (field != null) {
                    resourceType = field.getType();
                }
            }
            return resourceType;
        }

        protected static String getResourceType(Resource annotation, Method method, Field field) {
            return ResourceProcessor.getResourceTypeClass(annotation, method, field).getCanonicalName();
        }
    }
}

